/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javolution.xml.XMLBinding;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.capabilities.Client;
import org.apache.jetspeed.serializer.objects.JSCapability;
import org.apache.jetspeed.serializer.objects.JSClientCapabilities;
import org.apache.jetspeed.serializer.objects.JSClientMimeTypes;
import org.apache.jetspeed.serializer.objects.JSMimeType;

public class JSClient {
    private String name;
    private int id;
    private int evalOrder;
    private String manufacturer;
    private String model;
    private String preferredMimeTypeID;
    private String userAgentPattern;
    private String version;
    private ArrayList capabilities;
    private ArrayList mimeTypes;
    private JSClientCapabilities capabilitiesString;
    private JSClientMimeTypes mimeTypesString;
    public static final String XML_TAG = "Client".intern();
    private static final XMLFormat XML = new XMLFormat(JSClient.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSClient g = (JSClient)o;
                xml.setAttribute("name", g.name);
                xml.setAttribute("evalOrder", g.evalOrder);
                xml.setAttribute("preferredMimeTypeID", g.preferredMimeTypeID);
                xml.add((Object)g.userAgentPattern, "userAgentPattern", String.class);
                xml.add((Object)g.version, "version", String.class);
                xml.add((Object)g.model, "model", String.class);
                xml.add((Object)g.manufacturer, "manufacturer", String.class);
                g.capabilitiesString = new JSClientCapabilities(g.putTokens(g.capabilities));
                g.mimeTypesString = new JSClientMimeTypes(g.putTokens(g.mimeTypes));
                xml.add((Object)g.capabilitiesString);
                xml.add((Object)g.mimeTypesString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSClient g = (JSClient)o;
                g.name = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("name", ""));
                g.evalOrder = xml.getAttribute("evalOrder", 0);
                g.preferredMimeTypeID = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("preferredMimeTypeID", "0"));
                g.userAgentPattern = StringEscapeUtils.unescapeHtml((String)((String)xml.get("userAgentPattern", String.class)));
                g.version = StringEscapeUtils.unescapeHtml((String)((String)xml.get("version", String.class)));
                g.model = StringEscapeUtils.unescapeHtml((String)((String)xml.get("model", String.class)));
                g.manufacturer = StringEscapeUtils.unescapeHtml((String)((String)xml.get("manufacturer", String.class)));
                g.capabilitiesString = (JSClientCapabilities)xml.getNext();
                g.mimeTypesString = (JSClientMimeTypes)xml.getNext();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public JSClient() {
    }

    public JSClient(Client c) {
        this.id = c.getClientId();
        this.name = c.getName();
        this.userAgentPattern = c.getUserAgentPattern();
        this.version = c.getVersion();
        this.model = c.getModel();
        this.evalOrder = c.getEvalOrder();
        this.manufacturer = c.getManufacturer();
        this.capabilities = new ArrayList();
        this.mimeTypes = new ArrayList();
    }

    public static void setupAliases(XMLBinding binding) {
        binding.setAlias(JSClient.class, XML_TAG);
    }

    public List getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(ArrayList capabilities) {
        this.capabilities = capabilities;
    }

    public int getEvalOrder() {
        return this.evalOrder;
    }

    public void setEvalOrder(int evalOrder) {
        this.evalOrder = evalOrder;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public List getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(ArrayList mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPreferredMimeTypeID() {
        return this.preferredMimeTypeID;
    }

    public void setPreferredMimeTypeID(String preferredMimeTypeID) {
        this.preferredMimeTypeID = preferredMimeTypeID;
    }

    public String getUserAgentPattern() {
        return this.userAgentPattern;
    }

    public void setUserAgentPattern(String userAgentPattern) {
        this.userAgentPattern = userAgentPattern;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private String append(JSCapability capability) {
        return capability.getName();
    }

    private String append(JSMimeType mime) {
        return mime.getName();
    }

    private String append(Object s) {
        if (s instanceof JSCapability) {
            return this.append((JSCapability)s);
        }
        if (s instanceof JSMimeType) {
            return this.append((JSMimeType)s);
        }
        return s.toString();
    }

    private String putTokens(ArrayList _list) {
        if (_list == null || _list.size() == 0) {
            return "";
        }
        boolean _start = true;
        Iterator _it = _list.iterator();
        StringBuffer _sb = new StringBuffer();
        while (_it.hasNext()) {
            if (!_start) {
                _sb.append(',');
            } else {
                _start = false;
            }
            _sb.append(this.append(_it.next()));
        }
        return _sb.toString();
    }

    public JSClientCapabilities getCapabilitiesString() {
        return this.capabilitiesString;
    }

    public JSClientMimeTypes getMimeTypesString() {
        return this.mimeTypesString;
    }
}

