/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.jetspeed.serializer.JetspeedDDLUtil;
import org.apache.jetspeed.serializer.objects.JSGroup;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JetspeedDDLApplication {
    public static final String JNDI_DS_NAME = "jetspeed";
    String propertyFileName = null;
    String exludeFileName = null;
    String orderFileName = null;
    String logLevel = null;
    PropertiesConfiguration configuration = null;
    boolean doImport = false;
    boolean doExport = false;
    String schemaDirectory = null;
    String outputFile = null;
    boolean overwrite = false;
    String driverClass = null;
    String url = null;
    String user = null;
    String password = null;
    String databaseName = null;
    String[] filesToProcess = null;
    String mergeFile = null;
    String[] args = null;

    public static void main(String[] args) throws Exception {
        JetspeedDDLApplication app = new JetspeedDDLApplication();
        app.processArguments(args);
    }

    private void checkDBSettings() {
        if (this.databaseName == null) {
            this.databaseName = System.getProperty("org.apache.jetspeed.database.databaseName", "mysql");
        }
        if (this.driverClass == null) {
            this.driverClass = System.getProperty("org.apache.jetspeed.database.driverClass", "com.mysql.jdbc.Driver");
        }
        if (this.url == null) {
            this.url = System.getProperty("org.apache.jetspeed.database.url", "jdbc:mysql://localhost/j2test");
        }
        if (this.user == null) {
            this.user = System.getProperty("org.apache.jetspeed.database.user", "user");
        }
        if (this.password == null) {
            this.password = System.getProperty("org.apache.jetspeed.database.password", "password");
        }
        if (this.driverClass == null) {
            throw new IllegalArgumentException("Can't proceed without a valid driver");
        }
        if (this.url == null) {
            throw new IllegalArgumentException("Can't proceed without a valid url to the target database");
        }
        if (this.user == null) {
            throw new IllegalArgumentException("Can't proceed without a valid database user");
        }
    }

    private void parseArguments() {
        for (int n = 0; n < this.args.length; ++n) {
            if (this.args[n].equals("-I")) {
                this.doImport = true;
                this.schemaDirectory = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-O")) {
                this.doExport = true;
                this.outputFile = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-s")) {
                this.orderFileName = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-x")) {
                this.exludeFileName = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-m")) {
                this.mergeFile = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-R")) {
                this.overwrite = true;
                continue;
            }
            if (this.args[n].equals("-dn")) {
                this.databaseName = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-dc")) {
                this.driverClass = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-ds")) {
                this.url = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-du")) {
                if (n + 1 >= this.args.length || this.args[n + 1].startsWith("-d")) {
                    this.user = "";
                    continue;
                }
                this.user = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-dp")) {
                if (n + 1 >= this.args.length || this.args[n + 1].startsWith("-d")) {
                    this.password = "";
                    continue;
                }
                this.password = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-P")) {
                this.propertyFileName = this.args[++n];
                continue;
            }
            if (this.args[n].equals("-l")) {
                this.logLevel = this.args[++n];
                continue;
            }
            throw new IllegalArgumentException("Unknown argument: " + this.args[n]);
        }
    }

    private String[] parseFiles() {
        String[] fileList = null;
        File dir = new File(this.schemaDirectory);
        if (!dir.exists()) {
            return fileList;
        }
        if (!dir.isDirectory()) {
            fileList = new String[]{this.schemaDirectory};
            return fileList;
        }
        LocalFilenameFilter filter = new LocalFilenameFilter(this.exludeFileName, this.orderFileName);
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return fileList;
        }
        fileList = new String[files.length];
        String sortorderFile = filter.getSortFile();
        if (sortorderFile == null) {
            for (int i = 0; i < files.length; ++i) {
                fileList[i] = files[i].getAbsolutePath();
            }
            return fileList;
        }
        try {
            ArrayList list = this.readOrderFile(sortorderFile);
            fileList = new String[files.length];
            if (list == null || list.size() == 0) {
                for (int i = 0; i < files.length; ++i) {
                    fileList[i] = files[i].getAbsolutePath();
                }
                return fileList;
            }
            String[] tempList = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                tempList[i] = files[i].getName();
            }
            Iterator _it = list.iterator();
            int j = 0;
            while (_it.hasNext()) {
                String filename = null;
                try {
                    filename = ((JSGroup)_it.next()).getName();
                }
                catch (Exception eeee) {
                    // empty catch block
                }
                if (filename == null) continue;
                for (int i = 0; i < files.length; ++i) {
                    if (!filename.equalsIgnoreCase(tempList[i])) continue;
                    fileList[j++] = files[i].getAbsolutePath();
                    tempList[i] = null;
                }
            }
            for (int i = 0; i < files.length; ++i) {
                if (tempList[i] == null) continue;
                fileList[j++] = files[i].getAbsolutePath();
            }
            return fileList;
        }
        catch (Exception eee) {
            try {
                eee.printStackTrace();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Processing the schema-directory " + this.schemaDirectory + " caused exception " + e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processArguments(String[] arguments) throws Exception {
        this.args = arguments;
        if (this.args == null) {
            throw new IllegalArgumentException("Either a schema directory, a schema file or an output filename have to be defined (-D followed by a driectory, -I or -O  followed by the filename");
        }
        this.parseArguments();
        this.processPropertyFile();
        this.checkDBSettings();
        if (!this.doImport && !this.doExport) {
            throw new IllegalArgumentException("Either a schema directory, a schema file or an output filename have to be defined (-I or -O  followed by the directory-/filename");
        }
        if (this.doImport) {
            this.filesToProcess = this.parseFiles();
            if (this.filesToProcess == null) {
                return;
            }
        }
        JetspeedDDLUtil ddlUtil = null;
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(JetspeedDDLUtil.DATASOURCE_DATABASENAME, this.databaseName);
        context.put(JetspeedDDLUtil.DATASOURCE_DRIVER, this.driverClass);
        context.put(JetspeedDDLUtil.DATASOURCE_URL, this.url);
        context.put(JetspeedDDLUtil.DATASOURCE_USERNAME, this.user);
        context.put(JetspeedDDLUtil.DATASOURCE_PASSWORD, this.password);
        Logger logger = Logger.getLogger((String)"org.apache.ddlutils");
        Level level = logger.getLevel();
        if (this.logLevel == null) {
            logger.setLevel(Level.ERROR);
        } else if (this.logLevel.equalsIgnoreCase("INFO")) {
            logger.setLevel(Level.INFO);
        } else if (this.logLevel.equalsIgnoreCase("WARN")) {
            logger.setLevel(Level.WARN);
        } else {
            logger.setLevel(Level.ERROR);
        }
        try {
            ddlUtil = new JetspeedDDLUtil();
            ddlUtil.startUp();
            ddlUtil.init(context);
        }
        catch (Exception e) {
            System.err.println("Failed to initialize Utility!!!!!");
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            if (this.doImport) {
                this.processImport(ddlUtil);
            }
            if (this.doExport) {
                this.processExport(ddlUtil);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to process XML " + (this.doExport ? "export" : "import") + ":" + e);
            e.printStackTrace();
        }
        finally {
            try {
                logger.setLevel(level);
                if (ddlUtil != null) {
                    ddlUtil.tearDown();
                }
            }
            catch (Exception e1) {
                System.out.println("starter framework teardown caused exception " + e1.getLocalizedMessage());
                e1.printStackTrace();
            }
        }
    }

    private void processImport(JetspeedDDLUtil ddlUtil) {
        String file = null;
        if (this.filesToProcess == null || this.filesToProcess.length == 0) {
            return;
        }
        if (this.filesToProcess.length > 1) {
            file = this.mergeFiles(this.filesToProcess);
        }
        System.out.println("Importing " + file);
        Database db = ddlUtil.createDatabaseSchemaFromXML(file);
        try {
            if (this.overwrite) {
                ddlUtil.createDatabase(db);
            } else {
                ddlUtil.alterDatabase(db);
            }
            System.out.println("Importing " + file + " completed");
        }
        catch (Exception ePr) {
            ePr.printStackTrace();
        }
    }

    private File createTemp(String suffix) {
        try {
            File temp = File.createTempFile("tmp", suffix);
            temp.deleteOnExit();
            return temp;
        }
        catch (IOException e) {
            System.out.println("Failed to create temproary file with " + e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    private File createXSLTFromFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        try {
            File f = new File(fileName);
            if (f.exists()) {
                return f;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("Failed to open merge template " + e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    private File createXSLTFromMemory() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\"?>");
        buffer.append("<xslt:transform version=\"1.0\" xmlns:xslt=\"http://www.w3.org/1999/XSL/Transform\">");
        buffer.append("<!-- Simple template to merge two database schemas into one  -->");
        buffer.append("<xslt:param name=\"fileTwo\" />");
        buffer.append("<xslt:template match=\"/\">");
        buffer.append("<xslt:message>");
        buffer.append("<xslt:text /> Merging input with '<xslt:value-of select=\"$fileTwo\"/>");
        buffer.append("<xslt:text>'</xslt:text>");
        buffer.append("</xslt:message>");
        buffer.append("<xslt:if test=\"string($fileTwo)=''\">");
        buffer.append("<xslt:message terminate=\"yes\">");
        buffer.append("<xslt:text>No input file specified (parameter 'fileTwo')</xslt:text>");
        buffer.append("</xslt:message>");
        buffer.append("</xslt:if>");
        buffer.append("<database name=\"generic\">");
        buffer.append("<xslt:apply-templates />");
        buffer.append("</database>");
        buffer.append("</xslt:template>");
        buffer.append("<xslt:template match=\"database\">");
        buffer.append("<xslt:apply-templates />");
        buffer.append("<xslt:apply-templates select=\"document($fileTwo)/database/table\"/>");
        buffer.append("</xslt:template>");
        buffer.append("<xslt:template match=\"@*|node()\">");
        buffer.append("<xslt:copy>");
        buffer.append("<xslt:apply-templates select=\"@*|node()\"/>");
        buffer.append("</xslt:copy>");
        buffer.append("</xslt:template>");
        buffer.append("</xslt:transform>");
        File xslt = this.createTemp(".xslt");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(xslt));
            out.write(buffer.toString());
            out.close();
            return xslt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String mergeFiles(String[] fileList) {
        try {
            File xsltFile = this.createXSLTFromFile(this.mergeFile);
            if (xsltFile == null) {
                xsltFile = this.createXSLTFromMemory();
            }
            StreamSource xslt = new StreamSource(xsltFile);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xslt);
            String sourceName = fileList[0];
            File target = null;
            for (int i = 1; i < fileList.length; ++i) {
                File soureFile = new File(sourceName);
                StreamSource source = new StreamSource(soureFile);
                target = this.createTemp(".xml");
                StreamResult targetResult = new StreamResult(target);
                File f = new File(fileList[i]);
                String other = "file:///" + f.getCanonicalPath();
                other = other.replace('\\', '/');
                transformer.setParameter("fileTwo", other);
                transformer.transform(source, targetResult);
                sourceName = target.getAbsolutePath();
            }
            return sourceName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void processExport(JetspeedDDLUtil ddlUtil) {
        ddlUtil.writeDatabaseSchematoFile(this.outputFile);
    }

    private void processPropertyFile() {
        if (this.propertyFileName == null) {
            this.propertyFileName = System.getProperty("org.apache.jetspeed.xml.ddlUtil.configuration", null);
        }
        if (this.propertyFileName == null) {
            return;
        }
        try {
            this.configuration = new PropertiesConfiguration(this.propertyFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (this.configuration != null) {
            if (this.driverClass == null) {
                this.driverClass = this.configuration.getString("driverClass");
            }
            if (this.url == null) {
                this.url = this.configuration.getString("url");
            }
            if (this.user == null) {
                this.user = this.configuration.getString("user");
            }
            if (this.password == null) {
                this.password = this.configuration.getString("password");
            }
            if (this.mergeFile == null) {
                this.mergeFile = this.configuration.getString("mergeFile");
            }
            if (!this.doImport) {
                this.schemaDirectory = this.configuration.getString("schema");
                if (this.schemaDirectory != null) {
                    this.doImport = true;
                }
            }
            if (!this.doExport) {
                this.outputFile = this.configuration.getString("outputFile");
                if (this.outputFile != null) {
                    this.doExport = true;
                }
            }
            if (this.logLevel == null) {
                this.logLevel = this.configuration.getString("loglevel");
            }
        }
    }

    public List getRows(JetspeedDDLUtil ddlUtil, String tableName) {
        Table table = ddlUtil.getModel().findTable(tableName, ddlUtil.getPlatform().isDelimitedIdentifierModeOn());
        return ddlUtil.getPlatform().fetch(ddlUtil.getModel(), this.getSelectQueryForAllString(ddlUtil, table), new Table[]{table});
    }

    public String getSelectQueryForAllString(JetspeedDDLUtil ddlUtil, Table table) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT * FROM ");
        if (ddlUtil.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(ddlUtil.getPlatform().getPlatformInfo().getDelimiterToken());
        }
        query.append(table.getName());
        if (ddlUtil.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(ddlUtil.getPlatform().getPlatformInfo().getDelimiterToken());
        }
        System.out.println(query.toString());
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList readOrderFile(String importFileName) {
        XMLObjectReader reader = null;
        XMLBinding binding = new XMLBinding();
        binding.setAlias(ArrayList.class, "ProcessOrder");
        binding.setAlias(JSGroup.class, "File");
        ArrayList snap = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(importFileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            reader.setBinding(binding);
            snap = (ArrayList)reader.read("ProcessOrder", ArrayList.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e1) {}
        }
        return snap;
    }

    class LocalFilenameFilter
    implements FilenameFilter {
        String exclude = null;
        String sortFile = null;
        String sort = null;

        String getSortFile() {
            return this.sortFile;
        }

        LocalFilenameFilter(String exclude, String sort) {
            this.exclude = exclude;
            this.sort = sort;
        }

        public boolean accept(File dir, String name) {
            if (this.exclude != null && name.equalsIgnoreCase(this.exclude)) {
                return false;
            }
            if (this.sort != null && name.equalsIgnoreCase(this.sort)) {
                this.sortFile = dir.getAbsolutePath() + "/" + this.sort;
                return false;
            }
            return name.endsWith(".xml");
        }
    }
}

