/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.security.Principal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.security.Credential;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.serializer.objects.JSGroup;
import org.apache.jetspeed.serializer.objects.JSNVPElement;
import org.apache.jetspeed.serializer.objects.JSPWAttributes;
import org.apache.jetspeed.serializer.objects.JSPrincipal;
import org.apache.jetspeed.serializer.objects.JSPrincipalRules;
import org.apache.jetspeed.serializer.objects.JSRole;
import org.apache.jetspeed.serializer.objects.JSSecurityAttributes;
import org.apache.jetspeed.serializer.objects.JSUserAttributes;
import org.apache.jetspeed.serializer.objects.JSUserGroups;
import org.apache.jetspeed.serializer.objects.JSUserRoles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSUser {
    private String name;
    private char[] password;
    private JSPWAttributes pwData = null;
    private List<JSPrincipal> roles = null;
    private List<JSPrincipal> groups = null;
    private JSUserAttributes userInfo = null;
    private JSSecurityAttributes attributes = null;
    private List<Credential> publicCredentials = null;
    private List<Credential> privateCredentials = null;
    private JSUserRoles roleString;
    private JSUserGroups groupString;
    private JSPrincipalRules rules = new JSPrincipalRules();
    private String userTemplate;
    private String subsite;
    private transient Principal principal;
    private static final XMLFormat XML = new XMLFormat(JSUser.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSUser g = (JSUser)o;
                String s = g.getName();
                if (s == null || s.length() == 0) {
                    s = "guest";
                }
                xml.setAttribute("name", s);
                s = g.getUserTemplate();
                if (s != null && s.length() > 0) {
                    xml.setAttribute("userTemplate", s);
                }
                if ((s = g.getSubsite()) != null && s.length() > 0) {
                    xml.setAttribute("subsite", s);
                }
                xml.add((Object)g.getPwData());
                g.groupString = new JSUserGroups(g.putTokens(g.getGroups()));
                g.roleString = new JSUserRoles(g.putTokens(g.getRoles()));
                xml.add((Object)g.roleString);
                xml.add((Object)g.groupString);
                xml.add((Object)g.attributes);
                xml.add((Object)g.userInfo);
                xml.add((Object)g.rules);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSUser g = (JSUser)o;
                g.name = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("name", "unknown"));
                g.userTemplate = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("userTemplate", ""));
                if (g.userTemplate.equals("")) {
                    g.userTemplate = null;
                }
                g.subsite = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("subsite", ""));
                if (g.subsite.equals("")) {
                    g.subsite = null;
                }
                Object o1 = null;
                while (xml.hasNext()) {
                    o1 = xml.getNext();
                    if (o1 instanceof JSPWAttributes) {
                        g.pwData = (JSPWAttributes)o1;
                        g.resetPassword();
                        continue;
                    }
                    if (o1 instanceof JSUserGroups) {
                        g.groupString = (JSUserGroups)o1;
                        continue;
                    }
                    if (o1 instanceof JSUserRoles) {
                        g.roleString = (JSUserRoles)o1;
                        continue;
                    }
                    if (o1 instanceof JSUserAttributes) {
                        g.userInfo = (JSUserAttributes)o1;
                        continue;
                    }
                    if (o1 instanceof JSSecurityAttributes) {
                        g.attributes = (JSSecurityAttributes)o1;
                        continue;
                    }
                    if (!(o1 instanceof JSPrincipalRules)) continue;
                    g.rules = (JSPrincipalRules)o1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public void addPublicCredential(Credential o) {
        if (this.publicCredentials == null) {
            this.publicCredentials = new ArrayList<Credential>();
        }
        this.publicCredentials.add(o);
    }

    public void addPrivateCredential(Credential o) {
        if (this.privateCredentials == null) {
            this.privateCredentials = new ArrayList<Credential>();
        }
        this.privateCredentials.add(o);
    }

    public void addGroup(JSPrincipal group) {
        if (this.groups == null) {
            this.groups = new ArrayList<JSPrincipal>();
        }
        this.groups.add(group);
    }

    public void addRole(JSPrincipal role) {
        if (this.roles == null) {
            this.roles = new ArrayList<JSPrincipal>();
        }
        this.roles.add(role);
    }

    public List<JSPrincipal> getGroups() {
        return this.groups;
    }

    public void setGroups(List<JSPrincipal> groups) {
        this.groups = groups;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setUserCredential(String name, char[] password, Date expirationDate, boolean isEnabled, boolean isExpired, boolean requireUpdate) {
        this.setName(name);
        this.setPassword(password);
        this.pwData = new JSPWAttributes();
        if (password != null) {
            this.pwData.getMyMap().put("password", this.getPasswordString());
            if (expirationDate != null) {
                this.pwData.getMyMap().put("expirationDate", expirationDate.toString());
            }
            this.pwData.getMyMap().put("enabled", isEnabled ? "TRUE" : "FALSE");
            this.pwData.getMyMap().put("requiresUpdate", requireUpdate ? "TRUE" : "FALSE");
        }
    }

    protected void resetPassword() {
        try {
            if (this.pwData != null) {
                String o = this.pwData.getMyMap().get("password");
                String pw = StringEscapeUtils.unescapeHtml((String)o);
                this.password = (char[])(pw != null && pw.length() > 0 ? pw.toCharArray() : null);
            }
        }
        catch (Exception e) {
            this.password = null;
        }
    }

    public boolean getPwEnabled() {
        return this.getPWBoolean("enabled", false);
    }

    public boolean getPwRequiredUpdate() {
        return this.getPWBoolean("requiresUpdate", false);
    }

    public Date getPwExpirationDate() {
        if (this.pwData != null) {
            String o = this.pwData.getMyMap().get("expirationDate");
            if (o == null) {
                return null;
            }
            if (o instanceof Date) {
                return (Date)((Object)o);
            }
            Date d = Date.valueOf(o);
            return d;
        }
        return null;
    }

    private boolean getPWBoolean(String property, boolean defaultSetting) {
        if (this.pwData == null) {
            return defaultSetting;
        }
        try {
            String o = this.pwData.getMyMap().get(property);
            if (o == null) {
                return defaultSetting;
            }
            return o.equalsIgnoreCase("TRUE");
        }
        catch (Exception e) {
            return defaultSetting;
        }
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<JSPrincipal> getRoles() {
        return this.roles;
    }

    public void setRoles(List<JSPrincipal> roles) {
        this.roles = roles;
    }

    public String getName() {
        return this.name;
    }

    public JSSecurityAttributes getSecurityAttributes() {
        return this.attributes;
    }

    public void setSecurityAttributes(Map<String, SecurityAttribute> sa) {
        this.attributes = new JSSecurityAttributes();
        for (Map.Entry<String, SecurityAttribute> e : sa.entrySet()) {
            SecurityAttribute attrib = e.getValue();
            JSNVPElement element = new JSNVPElement(attrib.getName(), attrib.getStringValue());
            this.attributes.add(element);
        }
    }

    public JSUserAttributes getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(Map<String, SecurityAttribute> sa) {
        this.userInfo = new JSUserAttributes();
        for (Map.Entry<String, SecurityAttribute> e : sa.entrySet()) {
            SecurityAttribute attrib = e.getValue();
            JSNVPElement element = new JSNVPElement(attrib.getName(), attrib.getStringValue());
            this.userInfo.add(element);
        }
    }

    public List<Credential> getPrivateCredentials() {
        return this.privateCredentials;
    }

    public void setPrivateCredentials(List<Credential> privateCredentials) {
        this.privateCredentials = privateCredentials;
    }

    public List<Credential> getPublicCredentials() {
        return this.publicCredentials;
    }

    public void setPublicCredentials(List<Credential> publicCredentials) {
        this.publicCredentials = publicCredentials;
    }

    private String append(JSPrincipal principal) {
        return principal.getName();
    }

    private String append(JSRole role) {
        return role.getName();
    }

    private String append(JSGroup group) {
        return group.getName();
    }

    private String append(Object s) {
        if (s instanceof JSPrincipal) {
            return this.append((JSPrincipal)s);
        }
        if (s instanceof JSRole) {
            return this.append((JSRole)s);
        }
        if (s instanceof JSGroup) {
            return this.append((JSGroup)s);
        }
        return s.toString();
    }

    private String putTokens(List _list) {
        if (_list == null || _list.size() == 0) {
            return "";
        }
        boolean _start = true;
        Iterator _it = _list.iterator();
        StringBuffer _sb = new StringBuffer();
        while (_it.hasNext()) {
            if (!_start) {
                _sb.append(',');
            } else {
                _start = false;
            }
            _sb.append(this.append(_it.next()));
        }
        return _sb.toString();
    }

    private String getPasswordString() {
        if (this.getPassword() == null || this.getPassword().length == 0) {
            return "";
        }
        return new String(this.getPassword());
    }

    public JSPrincipalRules getRules() {
        return this.rules;
    }

    public void setRules(JSPrincipalRules rules) {
        this.rules = rules;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public JSUserGroups getGroupString() {
        return this.groupString;
    }

    public JSUserRoles getRoleString() {
        return this.roleString;
    }

    public JSPWAttributes getPwData() {
        return this.pwData;
    }

    public String getPwDataValue(String key) {
        return this.getPwDataValue(key, null);
    }

    public String getPwDataValue(String key, String defValue) {
        String value = this.pwData != null ? this.pwData.getMyMap().get(key) : null;
        return value != null ? value : defValue;
    }

    public boolean getPwDataValueAsBoolean(String key) {
        return this.getPwDataValueAsBoolean(key, false);
    }

    public boolean getPwDataValueAsBoolean(String key, boolean defValue) {
        String sv = this.getPwDataValue(key);
        return sv != null ? Boolean.parseBoolean(sv) : defValue;
    }

    public Date getPwDataValueAsDate(String key) {
        return this.getPwDataValueAsDate(key, null);
    }

    public Date getPwDataValueAsDate(String key, Date defValue) {
        Date value = null;
        String sv = this.getPwDataValue(key, null);
        if (sv != null) {
            value = Date.valueOf(sv);
        }
        return value != null ? value : defValue;
    }

    public void setPwData(JSPWAttributes pwData) {
        this.pwData = pwData;
    }

    public String getSubsite() {
        return this.subsite;
    }

    public void setSubsite(String subsite) {
        this.subsite = subsite;
    }

    public String getUserTemplate() {
        return this.userTemplate;
    }

    public void setUserTemplate(String userTemplate) {
        this.userTemplate = userTemplate;
    }
}

