/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class JSSnapshot {
    private String name;
    private int savedVersion;
    private int savedSubversion;
    private String dateCreated;
    private String dataSource;
    protected static final XMLFormat XML = new XMLFormat(JSSnapshot.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSSnapshot g = (JSSnapshot)o;
                xml.setAttribute("name", g.getName());
                xml.add((Object)String.valueOf(g.getSoftwareVersion()), "softwareVersion");
                xml.add((Object)String.valueOf(g.getSoftwareSubVersion()), "softwareSubVersion");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSSnapshot g = (JSSnapshot)o;
                g.name = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("name", "unknown"));
                Object o1 = xml.get("softwareVersion", class$java$lang$String == null ? (class$java$lang$String = JSSnapshot.class$("java.lang.String")) : class$java$lang$String);
                if (o1 instanceof String) {
                    g.savedVersion = Integer.parseInt((String)o1);
                }
                if ((o1 = xml.get("softwareSubVersion", class$java$lang$String == null ? (class$java$lang$String = JSSnapshot.class$("java.lang.String")) : class$java$lang$String)) instanceof String) {
                    g.savedSubversion = Integer.parseInt((String)o1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    public boolean checkVersion() {
        return true;
    }

    public JSSnapshot() {
        System.out.println(this.getClass().getName() + " created");
    }

    public JSSnapshot(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public abstract int getSoftwareSubVersion();

    public abstract int getSoftwareVersion();

    public final String getDataSource() {
        return this.dataSource;
    }

    public final void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public final String getDateCreated() {
        return this.dateCreated;
    }

    public final void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public final int getSavedSubversion() {
        return this.savedSubversion;
    }

    public final void setSavedSubversion(int savedSubversion) {
        this.savedSubversion = savedSubversion;
    }

    public final int getSavedVersion() {
        return this.savedVersion;
    }

    public final void setSavedVersion(int savedVersion) {
        this.savedVersion = savedVersion;
    }

    public final void setName(String name) {
        this.name = name;
    }
}

