/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import javolution.xml.XMLBinding;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.MutablePortletEntity;
import org.apache.jetspeed.om.preference.impl.PrefsPreferenceSetImpl;
import org.apache.jetspeed.prefs.PreferencesProvider;
import org.apache.jetspeed.serializer.JetspeedSerializer;
import org.apache.jetspeed.serializer.JetspeedSerializerBase;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSApplication;
import org.apache.jetspeed.serializer.objects.JSApplications;
import org.apache.jetspeed.serializer.objects.JSEntities;
import org.apache.jetspeed.serializer.objects.JSEntity;
import org.apache.jetspeed.serializer.objects.JSEntityPreference;
import org.apache.jetspeed.serializer.objects.JSEntityPreferences;
import org.apache.jetspeed.serializer.objects.JSNVPElements;
import org.apache.jetspeed.serializer.objects.JSPortlet;
import org.apache.jetspeed.serializer.objects.JSPortlets;
import org.apache.jetspeed.serializer.objects.JSSecondaryData;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.portlet.PortletDefinitionList;

public class JetspeedSerializerSecondaryImpl
extends JetspeedSerializerBase
implements JetspeedSerializer {
    boolean overwrite = true;
    int refCouter = 0;
    private PortletEntityAccessComponent entityAccess = null;
    private PortletRegistry registry;
    private PreferencesProvider prefProvider;

    protected Class getSerializerDataClass() {
        return JSSecondaryData.class;
    }

    protected String getSerializerDataTag() {
        return "SecondaryData";
    }

    public JetspeedSerializerSecondaryImpl() {
    }

    public JetspeedSerializerSecondaryImpl(ComponentManager cm) {
        super(cm);
    }

    public JetspeedSerializerSecondaryImpl(String appRoot, String[] bootConfig, String[] appConfig) throws SerializerException {
        super(appRoot, bootConfig, appConfig);
    }

    protected void resetSettings() {
        this.setSetting(JetspeedSerializer.KEY_PROCESS_USERS, false);
        this.setSetting(JetspeedSerializer.KEY_PROCESS_CAPABILITIES, false);
        this.setSetting(JetspeedSerializer.KEY_PROCESS_PROFILER, false);
        this.setSetting(JetspeedSerializer.KEY_PROCESS_PERMISSIONS, false);
        this.setSetting(JetspeedSerializer.KEY_PROCESS_USER_PREFERENCES, false);
        this.setSetting(JetspeedSerializer.KEY_PROCESS_SSO, false);
        this.setSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING, true);
        this.setSetting(JetspeedSerializer.KEY_BACKUP_BEFORE_PROCESS, true);
    }

    protected void getSnapshotData() {
        this.logMe("date created : " + ((JSSecondaryData)this.getSnapshot()).getDateCreated());
        this.logMe("software Version : " + ((JSSecondaryData)this.getSnapshot()).getSavedVersion());
        this.logMe("software SUbVersion : " + ((JSSecondaryData)this.getSnapshot()).getSavedSubversion());
    }

    protected void setSnapshotData() {
        super.setSnapshotData();
    }

    private JSPortlet exportPD(PortletDefinition pd) throws SerializerException {
        try {
            Collection col = this.entityAccess.getPortletEntities(pd);
            if (col == null || col.size() == 0) {
                return null;
            }
            JSPortlet portlet = new JSPortlet();
            portlet.setName(pd.getName());
            Iterator list = null;
            try {
                list = col.iterator();
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"entityAccess", e.getMessage()}));
            }
            JSEntities entities = new JSEntities();
            while (list.hasNext()) {
                MutablePortletEntity entity = (MutablePortletEntity)list.next();
                JSEntity jsEntity = this.exportEntityPref(entity);
                if (jsEntity == null) continue;
                entities.add(jsEntity);
            }
            portlet.setEntities(entities);
            return portlet;
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Entity", e.getMessage()}));
        }
    }

    JSEntity exportEntityPref(MutablePortletEntity entity) {
        JSEntity jsEntity = new JSEntity();
        jsEntity.setId(entity.getId().toString());
        String rootForEntity = "portlet_entity/" + entity.getId();
        try {
            if (!Preferences.userRoot().nodeExists(rootForEntity)) {
                return jsEntity;
            }
            Preferences prefNode = Preferences.userRoot().node(rootForEntity);
            String[] children = prefNode.childrenNames();
            if (children != null && children.length > 0) {
                JSEntityPreferences permissions = new JSEntityPreferences();
                for (int i = 0; i < children.length; ++i) {
                    JSEntityPreference permission = this.processPreferenceNode(entity, children[i]);
                    if (permission == null) continue;
                    permissions.add(permission);
                }
                jsEntity.setEntityPreferences(permissions);
                return jsEntity;
            }
            return jsEntity;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    JSEntityPreference processPreferenceNode(MutablePortletEntity entity, String child) {
        String prefNodePath = "portlet_entity/" + entity.getId() + "/" + child + "/" + "preferences";
        Preferences prefNode = Preferences.userRoot().node(prefNodePath);
        if (prefNode == null) {
            return null;
        }
        JSEntityPreference permission = new JSEntityPreference();
        permission.setName(child);
        try {
            PrefsPreferenceSetImpl preferenceSet = new PrefsPreferenceSetImpl(prefNode);
            if (preferenceSet.size() == 0) {
                return null;
            }
            Iterator it = preferenceSet.iterator();
            JSNVPElements v = new JSNVPElements();
            while (it.hasNext()) {
                Preference pref = (Preference)it.next();
                String name = pref.getName();
                Iterator ii = pref.getValues();
                while (ii.hasNext()) {
                    Object o = ii.next();
                    v.add(name, o.toString());
                }
            }
            if (v.size() > 0) {
                permission.setPreferences(v);
                return permission;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSApplication exportPA(MutablePortletApplication pa) throws SerializerException {
        JSApplication app = new JSApplication();
        app.setID(pa.getId().toString());
        app.setName(pa.getName());
        PortletDefinitionList portletList = pa.getPortletDefinitionList();
        Iterator pi = portletList.iterator();
        PortletDefinition pd = null;
        JSPortlets portlets = new JSPortlets();
        while (pi.hasNext()) {
            try {
                pd = (PortletDefinition)pi.next();
                JSPortlet p = this.exportPD(pd);
                if (p == null) continue;
                portlets.add(p);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"PortletDefinition", e.getMessage()}));
            }
        }
        app.setPortlets(portlets);
        return app;
    }

    private JSApplications exportEntities() throws SerializerException {
        this.registry = (PortletRegistry)this.getCM().getComponent((Object)"org.apache.jetspeed.components.portletregistry.PortletRegistry");
        if (this.registry == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.components.portletregistry.PortletRegistry"));
        }
        Object o = this.getCM().getComponent((Object)"org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent");
        this.entityAccess = (PortletEntityAccessComponent)o;
        if (this.entityAccess == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent"));
        }
        JSApplications applications = new JSApplications();
        Collection col = this.registry.getPortletApplications();
        if (col == null || col.size() == 0) {
            return applications;
        }
        Iterator list = null;
        try {
            list = col.iterator();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"registry", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                MutablePortletApplication pa = (MutablePortletApplication)list.next();
                applications.add(this.exportPA(pa));
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"PortletApplicationDefinition", e.getMessage()}));
            }
        }
        return applications;
    }

    protected void processImport() throws SerializerException {
        this.logMe("*********reinstalling data*********");
        this.logMe("creating entities");
        this.importEntities();
    }

    protected void processExport(String name, XMLBinding binding) throws SerializerException {
        this.logMe("*********collecting data*********");
        this.setSnapshot(new JSSecondaryData(name));
        this.setSnapshotData();
        JSApplications apps = this.exportEntities();
        ((JSSecondaryData)this.getSnapshot()).setApplications(apps);
    }

    protected void setupAliases(XMLBinding binding) {
        binding.setAlias(JSApplication.class, "PortletApplication");
        binding.setAlias(JSApplications.class, "PortletApplications");
        binding.setAlias(JSPortlet.class, "Portlet");
        binding.setAlias(JSPortlets.class, "Portlets");
        binding.setAlias(JSEntity.class, "Entity");
        binding.setAlias(JSEntities.class, "Entities");
        binding.setAlias(JSEntityPreference.class, "Principal");
        binding.setAlias(JSEntityPreferences.class, "Settings");
        binding.setAlias(JSSecondaryData.class, "RegistryData");
        binding.setAlias(JSNVPElements.class, "preferences");
        binding.setAlias(String.class, "String");
        binding.setAlias(Integer.class, "int");
        binding.setClassAttribute(null);
    }

    private void importEntities() throws SerializerException {
        this.overwrite = this.getSetting(JetspeedSerializer.KEY_OVERWRITE_EXISTING);
        this.registry = (PortletRegistry)this.getCM().getComponent((Object)"org.apache.jetspeed.components.portletregistry.PortletRegistry");
        if (this.registry == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.components.portletregistry.PortletRegistry"));
        }
        Object o = this.getCM().getComponent((Object)"org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent");
        this.entityAccess = (PortletEntityAccessComponent)o;
        if (this.entityAccess == null) {
            throw new SerializerException(SerializerException.COMPONENTMANAGER_DOES_NOT_EXIST.create((Object)"org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent"));
        }
        JSApplications applications = ((JSSecondaryData)this.getSnapshot()).getApplications();
        if (applications == null) {
            return;
        }
        boolean importAll = this.registry.getPortletApplications().isEmpty();
        if (!applications.isEmpty()) {
            Iterator it = applications.iterator();
            while (it.hasNext()) {
                JSApplication app = (JSApplication)it.next();
                MutablePortletApplication portletApp = this.registry.getPortletApplication(app.getName());
                if (portletApp == null && !importAll) continue;
                this.importPA(app, portletApp);
            }
        }
    }

    void importPA(JSApplication app, MutablePortletApplication pa) throws SerializerException {
        Iterator pi = app.getPortlets().iterator();
        while (pi.hasNext()) {
            JSPortlet portlet = (JSPortlet)pi.next();
            if (pa != null) {
                PortletDefinition pd = pa.getPortletDefinitionByName(portlet.getName());
                if (pd == null) continue;
                this.importPD(portlet, pd);
                continue;
            }
            this.importPD(portlet, null);
        }
    }

    private void importPD(JSPortlet portlet, PortletDefinition pd) throws SerializerException {
        JSEntities entities = portlet.getEntities();
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            JSEntity entity = (JSEntity)it.next();
            if (pd != null) {
                MutablePortletEntity portletEntity = this.entityAccess.getPortletEntity(entity.getId());
                if (portletEntity == null) {
                    portletEntity = this.entityAccess.newPortletEntityInstance(pd, entity.getId());
                    try {
                        this.entityAccess.storePortletEntity((PortletEntity)portletEntity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.importEntityPref(entity, portletEntity);
                continue;
            }
            this.importEntityPref(entity, null);
        }
    }

    private void importEntityPref(JSEntity entity, MutablePortletEntity portletEntity) {
        JSEntityPreferences preferences = entity.getEntityPreferences();
        if (preferences == null || preferences.size() == 0) {
            return;
        }
        String entityId = portletEntity != null ? portletEntity.getId().toString() : entity.getId().toString();
        String rootForEntity = "portlet_entity/" + entityId;
        try {
            Preferences.userRoot().node(rootForEntity);
            Iterator it = preferences.iterator();
            while (it.hasNext()) {
                JSEntityPreference preference = (JSEntityPreference)it.next();
                this.importPreferenceNode(preference, entityId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void importPreferenceNode(JSEntityPreference preference, String entityId) {
        String child = preference.getName();
        String prefNodePath = "portlet_entity/" + entityId + "/" + child + "/" + "preferences";
        Preferences prefNode = Preferences.userRoot().node(prefNodePath);
        if (prefNode == null) {
            return;
        }
        JSNVPElements prefList = preference.getPreferences();
        try {
            PrefsPreferenceSetImpl preferenceSet = new PrefsPreferenceSetImpl(prefNode);
            Iterator it = prefList.getMyMap().keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)prefList.getMyMap().get(key);
                Preference p = preferenceSet.get(key);
                if (p != null && !this.overwrite) continue;
                Vector<String> v = new Vector<String>();
                v.add(value);
                preferenceSet.add(key, v);
            }
            preferenceSet.flush();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

