/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.CredentialPasswordValidator;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.PasswordCredentialInterceptor;
import org.apache.jetspeed.security.spi.impl.AbstractPasswordCredentialInterceptorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatePasswordOnLoadInterceptor
extends AbstractPasswordCredentialInterceptorImpl {
    private static final Logger log = LoggerFactory.getLogger(PasswordCredentialInterceptor.class);

    @Override
    public boolean afterLoad(String userName, PasswordCredential credential, CredentialPasswordEncoder encoder, CredentialPasswordValidator validator) throws SecurityException {
        boolean updated = false;
        if (credential.getPassword() != null && !credential.isEncoded() && validator != null) {
            try {
                validator.validate(credential.getPassword());
            }
            catch (SecurityException e) {
                log.error("Loaded password for user " + userName + " is invalid. The user will be required to change it.");
                credential.setUpdateRequired(true);
                updated = true;
            }
        }
        return updated;
    }
}

