/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.i18n.KeyedMessage;
import org.apache.jetspeed.security.JetspeedPermission;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationReference;
import org.apache.jetspeed.security.JetspeedPrincipalQueryContext;
import org.apache.jetspeed.security.JetspeedPrincipalResultList;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityDomain;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.impl.PersistentJetspeedPrincipal;
import org.apache.jetspeed.security.impl.SecurityDomainImpl;
import org.apache.jetspeed.security.impl.TransientJetspeedPrincipal;
import org.apache.jetspeed.security.spi.JetspeedDomainPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPermissionAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPermissionStorageManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAssociationStorageManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalLookupManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalStorageManager;
import org.apache.jetspeed.security.spi.PersistentJetspeedPermission;
import org.apache.jetspeed.security.spi.SecurityDomainAccessManager;
import org.apache.jetspeed.security.spi.SecurityDomainStorageManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialAccessManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialStorageManager;
import org.apache.jetspeed.security.spi.impl.JetspeedPrincipalAssociation;
import org.apache.jetspeed.security.spi.impl.JetspeedPrincipalLookupManagerFactory;
import org.apache.jetspeed.security.spi.impl.JetspeedPrincipalPermission;
import org.apache.jetspeed.security.spi.impl.PasswordCredentialImpl;
import org.apache.jetspeed.security.spi.impl.PersistentJetspeedPermissionImpl;
import org.apache.jetspeed.security.spi.impl.cache.JSPMCache;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.ojb.broker.util.collections.ManageableArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.ojb.PersistenceBrokerCallback;

public class JetspeedSecurityPersistenceManager
extends InitablePersistenceBrokerDaoSupport
implements Serializable,
JetspeedPrincipalAccessManager,
JetspeedPrincipalStorageManager,
JetspeedDomainPrincipalAccessManager,
UserPasswordCredentialStorageManager,
UserPasswordCredentialAccessManager,
JetspeedPrincipalAssociationStorageManager,
JetspeedPermissionAccessManager,
JetspeedPermissionStorageManager,
SecurityDomainStorageManager,
SecurityDomainAccessManager {
    private static final long serialVersionUID = -2689340557699526023L;
    static final Logger log = LoggerFactory.getLogger(JetspeedSecurityPersistenceManager.class);
    private Long defaultSecurityDomainId;
    private JetspeedPrincipalLookupManagerFactory jpplf = null;
    private JSPMCache jspmCache = null;

    public JetspeedSecurityPersistenceManager(String repositoryPath, JetspeedPrincipalLookupManagerFactory lookupManagerFactory, JSPMCache jspmCache) {
        super(repositoryPath);
        this.jpplf = lookupManagerFactory;
        this.jspmCache = jspmCache;
    }

    public Long getPrincipalId(String name, String type, Long domainId) throws SecurityException {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", (Object)name);
        criteria.addEqualTo("type", (Object)type);
        criteria.addEqualTo("domainId", (Object)domainId);
        String cacheKey = "getPrincipalId:" + criteria;
        Object principalId = this.jspmCache.getPrincipalQuery(cacheKey);
        if (principalId != null) {
            if (principalId != JSPMCache.CACHE_NULL) {
                return (Long)principalId;
            }
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(type, (Object)name));
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"id"});
        query.setJdbcTypes(new int[]{-5});
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        if (iter.hasNext()) {
            principalId = ((Object[])iter.next())[0];
            this.jspmCache.putPrincipalQuery(cacheKey, (Long)principalId, null, domainId, principalId);
            return (Long)principalId;
        }
        this.jspmCache.putPrincipalQuery(cacheKey, JSPMCache.ANY_ID, null, domainId, JSPMCache.CACHE_NULL);
        throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(type, (Object)name));
    }

    public boolean principalExists(JetspeedPrincipal principal) {
        if (principal.getId() == null) {
            if (principal.getDomainId() != null) {
                return this.principalExists(principal.getName(), principal.getType(), principal.getDomainId());
            }
            return this.principalExists(principal.getName(), principal.getType());
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("id", (Object)principal.getId());
        criteria.addEqualTo("type", (Object)principal.getType().getName());
        criteria.addEqualTo("domainId", (Object)principal.getDomainId());
        String cacheKey = "principalExists:" + criteria;
        Boolean principalExists = (Boolean)this.jspmCache.getPrincipalQuery(cacheKey);
        if (principalExists != null) {
            return principalExists;
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        principalExists = this.getPersistenceBrokerTemplate().getCount((Query)query) == 1;
        this.jspmCache.putPrincipalQuery(cacheKey, principalExists != false ? principal.getId() : JSPMCache.ANY_ID, null, principal.getDomainId(), principalExists);
        return principalExists;
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedFrom(String principalFromName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedFrom(principalFromName, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedFrom(String principalFromName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsTo.associationName", (Object)associationName);
        criteria.addEqualTo("associationsTo.from.name", (Object)principalFromName);
        criteria.addEqualTo("associationsTo.from.type", (Object)from.getName());
        criteria.addEqualTo("type", (Object)to.getName());
        criteria.addEqualTo("associationsTo.from.domainId", (Object)fromSecurityDomain);
        criteria.addEqualTo("domainId", (Object)toSecurityDomain);
        String cacheKey = "getAssociatedFrom:" + criteria;
        List associatedFrom = (List)this.jspmCache.getAssociationQuery(cacheKey);
        if (associatedFrom != null) {
            return new ArrayList<JetspeedPrincipal>(associatedFrom);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        associatedFrom = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        try {
            Long principalFromId = this.getPrincipalId(principalFromName, from.getName(), fromSecurityDomain);
            this.jspmCache.putAssociationQuery(cacheKey, principalFromId, this.extractPrincipalIds(associatedFrom), fromSecurityDomain, toSecurityDomain, new ArrayList(associatedFrom));
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return associatedFrom;
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedTo(String principalToName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedTo(principalToName, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedTo(String principalToName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsFrom.associationName", (Object)associationName);
        criteria.addEqualTo("associationsFrom.to.name", (Object)principalToName);
        criteria.addEqualTo("type", (Object)from.getName());
        criteria.addEqualTo("associationsFrom.to.type", (Object)to.getName());
        criteria.addEqualTo("associationsFrom.to.domainId", (Object)toSecurityDomain);
        criteria.addEqualTo("domainId", (Object)fromSecurityDomain);
        String cacheKey = "getAssociatedTo:" + criteria;
        List associatedTo = (List)this.jspmCache.getAssociationQuery(cacheKey);
        if (associatedTo != null) {
            return new ArrayList<JetspeedPrincipal>(associatedTo);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        associatedTo = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        try {
            Long principalToId = this.getPrincipalId(principalToName, to.getName(), toSecurityDomain);
            this.jspmCache.putAssociationQuery(cacheKey, principalToId, this.extractPrincipalIds(associatedTo), fromSecurityDomain, toSecurityDomain, new ArrayList(associatedTo));
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return associatedTo;
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedFrom(Long principalFromId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedFrom(principalFromId, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedFrom(Long principalFromId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsTo.associationName", (Object)associationName);
        criteria.addEqualTo("associationsTo.from.id", (Object)principalFromId);
        criteria.addEqualTo("associationsTo.from.type", (Object)from.getName());
        criteria.addEqualTo("type", (Object)to.getName());
        criteria.addEqualTo("associationsTo.from.domainId", (Object)fromSecurityDomain);
        criteria.addEqualTo("domainId", (Object)toSecurityDomain);
        String cacheKey = "getAssociatedFrom:" + criteria;
        List associatedFrom = (List)this.jspmCache.getAssociationQuery(cacheKey);
        if (associatedFrom != null) {
            return new ArrayList<JetspeedPrincipal>(associatedFrom);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        associatedFrom = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putAssociationQuery(cacheKey, principalFromId, this.extractPrincipalIds(associatedFrom), fromSecurityDomain, toSecurityDomain, new ArrayList(associatedFrom));
        return associatedFrom;
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedTo(Long principalToId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedTo(principalToId, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<JetspeedPrincipal> getAssociatedTo(Long principalToId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsFrom.associationName", (Object)associationName);
        criteria.addEqualTo("associationsFrom.to.id", (Object)principalToId);
        criteria.addEqualTo("type", (Object)from.getName());
        criteria.addEqualTo("associationsFrom.to.type", (Object)to.getName());
        criteria.addEqualTo("associationsFrom.to.domainId", (Object)toSecurityDomain);
        criteria.addEqualTo("domainId", (Object)fromSecurityDomain);
        String cacheKey = "getAssociatedTo:" + criteria;
        List associatedTo = (List)this.jspmCache.getAssociationQuery(cacheKey);
        if (associatedTo != null) {
            return new ArrayList<JetspeedPrincipal>(associatedTo);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        associatedTo = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putAssociationQuery(cacheKey, principalToId, this.extractPrincipalIds(associatedTo), fromSecurityDomain, toSecurityDomain, new ArrayList(associatedTo));
        return associatedTo;
    }

    private Long[] extractPrincipalIds(List<JetspeedPrincipal> principals) {
        if (principals == null || principals.isEmpty()) {
            return null;
        }
        ArrayList<Long> principalIds = new ArrayList<Long>(principals.size());
        for (JetspeedPrincipal principal : principals) {
            principalIds.add(principal.getId());
        }
        return principalIds.toArray(new Long[principalIds.size()]);
    }

    @Override
    public List<String> getAssociatedNamesFrom(String principalFromName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedNamesFrom(principalFromName, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<String> getAssociatedNamesFrom(String principalFromName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsTo.associationName", (Object)associationName);
        criteria.addEqualTo("associationsTo.from.name", (Object)principalFromName);
        criteria.addEqualTo("associationsTo.from.type", (Object)from.getName());
        criteria.addEqualTo("type", (Object)to.getName());
        criteria.addEqualTo("associationsTo.from.domainId", (Object)fromSecurityDomain);
        criteria.addEqualTo("domainId", (Object)toSecurityDomain);
        String cacheKey = "getAssociatedNamesFrom:" + criteria;
        ArrayList<String> associatedNamesFrom = (ArrayList<String>)this.jspmCache.getAssociationQuery(cacheKey);
        if (associatedNamesFrom != null) {
            return new ArrayList<String>(associatedNamesFrom);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name", "id"});
        query.setJdbcTypes(new int[]{12, -5});
        associatedNamesFrom = new ArrayList<String>();
        ArrayList<Long> associatedIdsFrom = new ArrayList<Long>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            Object[] associatedFrom = (Object[])iter.next();
            associatedNamesFrom.add((String)associatedFrom[0]);
            associatedIdsFrom.add((Long)associatedFrom[1]);
        }
        try {
            Long principalFromId = this.getPrincipalId(principalFromName, from.getName(), fromSecurityDomain);
            this.jspmCache.putAssociationQuery(cacheKey, principalFromId, associatedIdsFrom.toArray(new Long[associatedIdsFrom.size()]), fromSecurityDomain, toSecurityDomain, new ArrayList<String>(associatedNamesFrom));
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return associatedNamesFrom;
    }

    @Override
    public List<String> getAssociatedNamesFrom(Long principalFromId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedNamesFrom(principalFromId, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<String> getAssociatedNamesFrom(Long principalFromId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsTo.associationName", (Object)associationName);
        criteria.addEqualTo("associationsTo.from.id", (Object)principalFromId);
        criteria.addEqualTo("associationsTo.from.type", (Object)from.getName());
        criteria.addEqualTo("type", (Object)to.getName());
        criteria.addEqualTo("associationsTo.from.domainId", (Object)fromSecurityDomain);
        criteria.addEqualTo("domainId", (Object)toSecurityDomain);
        String cacheKey = "getAssociatedNamesFrom:" + criteria;
        ArrayList<String> associatedNamesFrom = (ArrayList<String>)this.jspmCache.getAssociationQuery(cacheKey);
        if (associatedNamesFrom != null) {
            return new ArrayList<String>(associatedNamesFrom);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name", "id"});
        query.setJdbcTypes(new int[]{12, -5});
        associatedNamesFrom = new ArrayList<String>();
        ArrayList<Long> associatedIdsFrom = new ArrayList<Long>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            Object[] associatedFrom = (Object[])iter.next();
            associatedNamesFrom.add((String)associatedFrom[0]);
            associatedIdsFrom.add((Long)associatedFrom[1]);
        }
        this.jspmCache.putAssociationQuery(cacheKey, principalFromId, associatedIdsFrom.toArray(new Long[associatedIdsFrom.size()]), fromSecurityDomain, toSecurityDomain, new ArrayList(associatedNamesFrom));
        return associatedNamesFrom;
    }

    @Override
    public List<String> getAssociatedNamesTo(String principalToName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedNamesTo(principalToName, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<String> getAssociatedNamesTo(String principalToName, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsFrom.associationName", (Object)associationName);
        criteria.addEqualTo("associationsFrom.to.name", (Object)principalToName);
        criteria.addEqualTo("type", (Object)from.getName());
        criteria.addEqualTo("associationsFrom.to.type", (Object)to.getName());
        criteria.addEqualTo("associationsFrom.to.domainId", (Object)toSecurityDomain);
        criteria.addEqualTo("domainId", (Object)fromSecurityDomain);
        String cacheKey = "getAssociatedNamesTo:" + criteria;
        ArrayList<String> associatedNamesTo = (ArrayList<String>)this.jspmCache.getAssociationQuery(cacheKey);
        if (associatedNamesTo != null) {
            return new ArrayList<String>(associatedNamesTo);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name", "id"});
        query.setJdbcTypes(new int[]{12, -5});
        associatedNamesTo = new ArrayList<String>();
        ArrayList<Long> associatedIdsTo = new ArrayList<Long>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            Object[] associatedTo = (Object[])iter.next();
            associatedNamesTo.add((String)associatedTo[0]);
            associatedIdsTo.add((Long)associatedTo[1]);
        }
        try {
            Long principalToId = this.getPrincipalId(principalToName, from.getName(), fromSecurityDomain);
            this.jspmCache.putAssociationQuery(cacheKey, principalToId, associatedIdsTo.toArray(new Long[associatedIdsTo.size()]), fromSecurityDomain, toSecurityDomain, new ArrayList<String>(associatedNamesTo));
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return associatedNamesTo;
    }

    @Override
    public List<String> getAssociatedNamesTo(Long principalToId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName) {
        Long defaultDomainId = this.getDefaultSecurityDomainId();
        return this.getAssociatedNamesTo(principalToId, from, to, associationName, defaultDomainId, defaultDomainId);
    }

    @Override
    public List<String> getAssociatedNamesTo(Long principalToId, JetspeedPrincipalType from, JetspeedPrincipalType to, String associationName, Long fromSecurityDomain, Long toSecurityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("associationsFrom.associationName", (Object)associationName);
        criteria.addEqualTo("associationsFrom.to.id", (Object)principalToId);
        criteria.addEqualTo("type", (Object)from.getName());
        criteria.addEqualTo("associationsFrom.to.type", (Object)to.getName());
        criteria.addEqualTo("associationsFrom.to.domainId", (Object)toSecurityDomain);
        criteria.addEqualTo("domainId", (Object)fromSecurityDomain);
        String cacheKey = "getAssociatedNamesTo:" + criteria;
        ArrayList<String> associatedNamesTo = (ArrayList<String>)this.jspmCache.getAssociationQuery(cacheKey);
        if (associatedNamesTo != null) {
            return new ArrayList<String>(associatedNamesTo);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name", "id"});
        query.setJdbcTypes(new int[]{12, -5});
        associatedNamesTo = new ArrayList<String>();
        ArrayList<Long> associatedIdsTo = new ArrayList<Long>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            Object[] associatedTo = (Object[])iter.next();
            associatedNamesTo.add((String)associatedTo[0]);
            associatedIdsTo.add((Long)associatedTo[1]);
        }
        this.jspmCache.putAssociationQuery(cacheKey, principalToId, associatedIdsTo.toArray(new Long[associatedIdsTo.size()]), fromSecurityDomain, toSecurityDomain, new ArrayList(associatedNamesTo));
        return associatedNamesTo;
    }

    @Override
    public JetspeedPrincipal getPrincipal(Long id) {
        Object principal = this.jspmCache.getPrincipal(id);
        if (principal != null) {
            return principal != JSPMCache.CACHE_NULL ? (JetspeedPrincipal)principal : null;
        }
        try {
            principal = this.getPersistenceBrokerTemplate().getObjectById(PersistentJetspeedPrincipal.class, (Object)id);
        }
        catch (ObjectRetrievalFailureException objectRetrievalFailureException) {
            // empty catch block
        }
        this.jspmCache.putPrincipal(id, principal != null ? principal : JSPMCache.CACHE_NULL);
        return (JetspeedPrincipal)principal;
    }

    @Override
    public JetspeedPrincipal getPrincipal(String principalName, JetspeedPrincipalType type) {
        return this.getPrincipal(principalName, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public JetspeedPrincipal getPrincipal(String principalName, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", (Object)principalName);
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        String cacheKey = "getPrincipal:" + criteria;
        Object principal = this.jspmCache.getPrincipalQuery(cacheKey);
        if (principal != null) {
            return principal != JSPMCache.CACHE_NULL ? (JetspeedPrincipal)principal : null;
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        principal = this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (principal != null) {
            this.jspmCache.putPrincipalQuery(cacheKey, ((JetspeedPrincipal)principal).getId(), null, securityDomain, principal);
        } else {
            this.jspmCache.putPrincipalQuery(cacheKey, JSPMCache.ANY_ID, null, securityDomain, JSPMCache.CACHE_NULL);
        }
        return (JetspeedPrincipal)principal;
    }

    @Override
    public List<String> getPrincipalNames(String nameFilter, JetspeedPrincipalType type) {
        return this.getPrincipalNames(nameFilter, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public List<String> getPrincipalNames(String nameFilter, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        if (nameFilter != null && nameFilter.length() > 0) {
            criteria.addLike((Object)"name", (Object)(nameFilter + "%"));
        }
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        String cacheKey = "getPrincipalNames:" + criteria;
        ArrayList<String> principalNames = (ArrayList<String>)this.jspmCache.getPrincipalQuery(cacheKey);
        if (principalNames != null) {
            return new ArrayList<String>(principalNames);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.setAttributes(new String[]{"name"});
        principalNames = new ArrayList<String>();
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iter.hasNext()) {
            principalNames.add((String)((Object[])iter.next())[0]);
        }
        this.jspmCache.putPrincipalQuery(cacheKey, JSPMCache.ANY_ID, null, securityDomain, new ArrayList(principalNames));
        return principalNames;
    }

    @Override
    public List<JetspeedPrincipal> getPrincipals(String nameFilter, JetspeedPrincipalType type) {
        return this.getPrincipals(nameFilter, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public List<JetspeedPrincipal> getPrincipals(String nameFilter, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        if (nameFilter != null && nameFilter.length() > 0) {
            criteria.addLike((Object)"name", (Object)(nameFilter + "%"));
        }
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        String cacheKey = "getPrincipals:" + criteria;
        List principals = (List)this.jspmCache.getPrincipalQuery(cacheKey);
        if (principals != null) {
            return new ArrayList<JetspeedPrincipal>(principals);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        principals = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putPrincipalQuery(cacheKey, JSPMCache.ANY_ID, null, securityDomain, new ArrayList(principals));
        return principals;
    }

    @Override
    public List<JetspeedPrincipal> getPrincipalsByAttribute(String attributeName, String attributeValue, JetspeedPrincipalType type) {
        return this.getPrincipalsByAttribute(attributeName, attributeValue, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public List<JetspeedPrincipal> getPrincipalsByAttribute(String attributeName, String attributeValue, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("attributes.name", (Object)attributeName);
        criteria.addEqualTo("attributes.value", (Object)attributeValue);
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        String cacheKey = "getPrincipalsByAttribute:" + criteria;
        List principals = (List)this.jspmCache.getPrincipalQuery(cacheKey);
        if (principals != null) {
            return new ArrayList<JetspeedPrincipal>(principals);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        principals = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putPrincipalQuery(cacheKey, JSPMCache.ANY_ID, null, securityDomain, new ArrayList(principals));
        return principals;
    }

    @Override
    public boolean principalExists(String principalName, JetspeedPrincipalType type) {
        return this.principalExists(principalName, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public boolean principalExists(String principalName, JetspeedPrincipalType type, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", (Object)principalName);
        criteria.addEqualTo("type", (Object)type.getName());
        criteria.addEqualTo("domainId", (Object)securityDomain);
        String cacheKey = "principalExists:" + criteria;
        Boolean principalExists = (Boolean)this.jspmCache.getPrincipalQuery(cacheKey);
        if (principalExists != null) {
            return principalExists;
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        principalExists = this.getPersistenceBrokerTemplate().getCount((Query)query) == 1;
        if (principalExists.booleanValue()) {
            try {
                Long principalId = this.getPrincipalId(principalName, type.getName(), securityDomain);
                this.jspmCache.putPrincipalQuery(cacheKey, principalId, null, securityDomain, principalExists);
            }
            catch (SecurityException se) {}
        } else {
            this.jspmCache.putPrincipalQuery(cacheKey, JSPMCache.ANY_ID, null, securityDomain, principalExists);
        }
        return principalExists;
    }

    @Override
    public void addPrincipal(JetspeedPrincipal principal, Set<JetspeedPrincipalAssociationReference> associations) throws SecurityException {
        if (principal.getDomainId() == null && principal instanceof TransientJetspeedPrincipal) {
            ((TransientJetspeedPrincipal)principal).setDomainId(this.getDefaultSecurityDomainId());
        }
        if (this.principalExists(principal)) {
            throw new SecurityException(SecurityException.PRINCIPAL_ALREADY_EXISTS.createScoped(principal.getType().getName(), (Object)principal.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)principal);
            this.jspmCache.evictPrincipal(principal.getId());
            this.jspmCache.putPrincipal(principal.getId(), principal);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"addPrincipal", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public boolean isMapped() {
        return false;
    }

    @Override
    public void removePrincipal(JetspeedPrincipal principal) throws SecurityException {
        if (!this.principalExists(principal)) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(principal.getType().getName(), (Object)principal.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().delete((Object)principal);
            this.jspmCache.evictPrincipal(principal.getId());
        }
        catch (Exception pbe) {
            if (pbe instanceof DataIntegrityViolationException) {
                this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                throw new SecurityException(SecurityException.PRINCIPAL_NOT_REMOVABLE.createScoped(principal.getType().getName(), (Object)principal.getName()));
            }
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removePrincipal", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void updatePrincipal(JetspeedPrincipal principal) throws SecurityException {
        if (!this.principalExists(principal)) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(principal.getType().getName(), (Object)principal.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)principal);
            this.jspmCache.evictPrincipal(principal.getId());
            this.jspmCache.putPrincipal(principal.getId(), principal);
        }
        catch (Exception pbe) {
            if (pbe instanceof DataIntegrityViolationException) {
                this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                throw new SecurityException(SecurityException.PRINCIPAL_UPDATE_FAILURE.createScoped(principal.getType().getName(), (Object)principal.getName()));
            }
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removePrincipal", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public PasswordCredential getPasswordCredential(User user) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)user.getId());
        criteria.addEqualTo("type", (Object)PasswordCredential.TYPE_CURRENT);
        String cacheKey = "getPasswordCredential:" + criteria;
        PasswordCredential passwordCredential = (PasswordCredential)this.jspmCache.getPasswordCredentialQuery(cacheKey);
        if (passwordCredential != null) {
            return passwordCredential;
        }
        QueryByCriteria query = QueryFactory.newQuery(PasswordCredentialImpl.class, (Criteria)criteria);
        passwordCredential = (PasswordCredential)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (passwordCredential != null) {
            ((PasswordCredentialImpl)passwordCredential).setUser(user);
        }
        if (passwordCredential != null) {
            this.jspmCache.putPasswordCredentialQuery(cacheKey, user.getId(), user.getDomainId(), passwordCredential);
        }
        if (passwordCredential == null) {
            passwordCredential = new PasswordCredentialImpl();
            ((PasswordCredentialImpl)passwordCredential).setUser(user);
        }
        return passwordCredential;
    }

    @Override
    public void storePasswordCredential(PasswordCredential credential) throws SecurityException {
        if (credential.getUser() == null) {
            this.loadPasswordCredentialUser(credential);
        }
        if (credential.isNewPasswordSet() && credential.getNewPassword() != null) {
            credential.setPassword(credential.getNewPassword(), false);
        }
        this.getPersistenceBrokerTemplate().store((Object)credential);
        this.jspmCache.evictPrincipal(credential.getUser().getId());
    }

    @Override
    public PasswordCredential getPasswordCredential(String userName) {
        return this.getPasswordCredential(userName, this.getDefaultSecurityDomainId());
    }

    @Override
    public PasswordCredential getPasswordCredential(String userName, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("user.name", (Object)userName);
        criteria.addEqualTo("user.enabled", (Object)true);
        criteria.addEqualTo("type", (Object)PasswordCredential.TYPE_CURRENT);
        criteria.addEqualTo("domainId", (Object)securityDomain);
        String cacheKey = "getPasswordCredential:" + criteria;
        Object passwordCredential = this.jspmCache.getPasswordCredentialQuery(cacheKey);
        if (passwordCredential != null) {
            return passwordCredential != JSPMCache.CACHE_NULL ? (PasswordCredential)passwordCredential : null;
        }
        QueryByCriteria query = QueryFactory.newQuery(PasswordCredentialImpl.class, (Criteria)criteria);
        passwordCredential = (PasswordCredential)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (passwordCredential != null) {
            ((PasswordCredentialImpl)passwordCredential).setUserName(userName);
        }
        if (passwordCredential != null) {
            try {
                Long principalId = this.getPrincipalId(userName, "user", securityDomain);
                this.jspmCache.putPasswordCredentialQuery(cacheKey, principalId, securityDomain, passwordCredential);
            }
            catch (SecurityException se) {}
        } else {
            this.jspmCache.putPasswordCredentialQuery(cacheKey, JSPMCache.ANY_ID, securityDomain, JSPMCache.CACHE_NULL);
        }
        return (PasswordCredential)passwordCredential;
    }

    @Override
    public void loadPasswordCredentialUser(final PasswordCredential credential) {
        if (credential.getUser() == null) {
            this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

                public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                    pb.retrieveReference((Object)credential, "user");
                    return null;
                }
            });
        }
    }

    @Override
    public List<PasswordCredential> getHistoricPasswordCredentials(User user) {
        return this.getHistoricPasswordCredentials(user, this.getDefaultSecurityDomainId());
    }

    @Override
    public List<PasswordCredential> getHistoricPasswordCredentials(User user, Long securityDomain) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)user.getId());
        criteria.addEqualTo("type", (Object)PasswordCredential.TYPE_HISTORICAL);
        String cacheKey = "getHistoricPasswordCredentials:" + criteria;
        List passwordCredentials = (List)this.jspmCache.getPasswordCredentialQuery(cacheKey);
        if (passwordCredentials != null) {
            return new ArrayList<PasswordCredential>(passwordCredentials);
        }
        QueryByCriteria query = QueryFactory.newQuery(PasswordCredentialImpl.class, (Criteria)criteria);
        passwordCredentials = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        for (PasswordCredential passwordCredential : passwordCredentials) {
            ((PasswordCredentialImpl)passwordCredential).setUser(user);
        }
        this.jspmCache.putPasswordCredentialQuery(cacheKey, user.getId(), user.getDomainId(), new ArrayList(passwordCredentials));
        return passwordCredentials;
    }

    @Override
    public void addAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("fromPrincipalId", (Object)from.getId());
        criteria.addEqualTo("toPrincipalId", (Object)to.getId());
        criteria.addEqualTo("associationName", (Object)associationName);
        QueryByCriteria query = QueryFactory.newQuery(JetspeedPrincipalAssociation.class, (Criteria)criteria);
        if (this.getPersistenceBrokerTemplate().getCount((Query)query) == 0) {
            try {
                this.getPersistenceBrokerTemplate().store((Object)new JetspeedPrincipalAssociation(from, to, associationName));
                this.jspmCache.evictPrincipal(from.getId());
                this.jspmCache.evictPrincipal(to.getId());
            }
            catch (Exception pbe) {
                if (pbe instanceof DataIntegrityViolationException) {
                    this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                    throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(from.getType().getName(), (Object)from.getName()));
                }
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"addAssociation", (Object)pbe.getMessage());
                this.logger.error((Object)msg, (Throwable)pbe);
                throw new SecurityException(msg, (Throwable)pbe);
            }
        }
    }

    @Override
    public void removeAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("fromPrincipalId", (Object)from.getId());
        criteria.addEqualTo("toPrincipalId", (Object)to.getId());
        criteria.addEqualTo("associationName", (Object)associationName);
        QueryByCriteria query = QueryFactory.newQuery(JetspeedPrincipalAssociation.class, (Criteria)criteria);
        if (this.getPersistenceBrokerTemplate().getCount((Query)query) != 0) {
            try {
                this.getPersistenceBrokerTemplate().delete((Object)new JetspeedPrincipalAssociation(from, to, associationName));
                this.jspmCache.evictPrincipal(from.getId());
                this.jspmCache.evictPrincipal(to.getId());
            }
            catch (Exception pbe) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removeAssociation", (Object)pbe.getMessage());
                this.logger.error((Object)msg, (Throwable)pbe);
                throw new SecurityException(msg, (Throwable)pbe);
            }
        }
    }

    public List<PersistentJetspeedPermission> getPermissions() {
        String cacheKey = "getPermissions:[]";
        List permissions = (List)this.jspmCache.getPermissionQuery(cacheKey);
        if (permissions != null) {
            return new ArrayList<PersistentJetspeedPermission>(permissions);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)new Criteria());
        query.addOrderByAscending("type");
        query.addOrderByAscending("name");
        permissions = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putPermissionQuery(cacheKey, null, null, JSPMCache.ANY_ID, null, new ArrayList(permissions));
        return permissions;
    }

    public List<PersistentJetspeedPermission> getPermissions(String type) {
        return this.getPermissions(type, null);
    }

    public List<PersistentJetspeedPermission> getPermissions(String type, String nameFilter) {
        String cacheKey;
        List permissions;
        Criteria criteria = new Criteria();
        criteria.addEqualTo("type", (Object)type);
        if (nameFilter != null && nameFilter.length() > 0) {
            criteria.addLike((Object)"name", (Object)(nameFilter + "%"));
        }
        if ((permissions = (List)this.jspmCache.getPermissionQuery(cacheKey = "getPermissions:" + criteria)) != null) {
            return new ArrayList<PersistentJetspeedPermission>(permissions);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        query.addOrderByAscending("name");
        permissions = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putPermissionQuery(cacheKey, null, null, JSPMCache.ANY_ID, null, new ArrayList(permissions));
        return permissions;
    }

    @Override
    public boolean permissionExists(JetspeedPermission permission) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("type", (Object)permission.getType());
        criteria.addEqualTo("name", (Object)permission.getName());
        criteria.addEqualTo("actions", (Object)permission.getActions());
        String cacheKey = "permissionExists:" + criteria;
        Boolean permissionExists = (Boolean)this.jspmCache.getPermissionQuery(cacheKey);
        if (permissionExists != null) {
            return permissionExists;
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        permissionExists = this.getPersistenceBrokerTemplate().getCount((Query)query) == 1;
        this.jspmCache.putPermissionQuery(cacheKey, null, null, JSPMCache.ANY_ID, null, permissionExists);
        return permissionExists;
    }

    public List<PersistentJetspeedPermission> getPermissions(PersistentJetspeedPrincipal principal) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principals.principalId", (Object)principal.getId());
        String cacheKey = "getPermissions:" + criteria;
        List permissions = (List)this.jspmCache.getPermissionQuery(cacheKey);
        if (permissions != null) {
            return new ArrayList<PersistentJetspeedPermission>(permissions);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        query.addOrderByAscending("type");
        query.addOrderByAscending("name");
        permissions = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putPermissionQuery(cacheKey, principal.getId(), null, JSPMCache.ANY_ID, null, new ArrayList(permissions));
        return permissions;
    }

    @Override
    public List<JetspeedPrincipal> getPrincipals(PersistentJetspeedPermission permission, String principalType) {
        return this.getPrincipals(permission, principalType, this.getDefaultSecurityDomainId());
    }

    public List<JetspeedPrincipal> getPrincipals(PersistentJetspeedPermission permission, String principalType, Long securityDomain) {
        Criteria criteria = new Criteria();
        if (permission.getId() != null) {
            criteria.addEqualTo("permissions.permissionId", (Object)permission.getId());
        } else {
            criteria.addEqualTo("permissions.permission.type", (Object)permission.getType());
            criteria.addEqualTo("permissions.permission.name", (Object)permission.getName());
        }
        if (principalType != null) {
            criteria.addEqualTo("type", (Object)principalType);
        }
        criteria.addEqualTo("domainId", (Object)securityDomain);
        String cacheKey = "getPrincipals:" + criteria;
        List principals = (List)this.jspmCache.getPermissionQuery(cacheKey);
        if (principals != null) {
            return new ArrayList<JetspeedPrincipal>(principals);
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        query.addOrderByAscending("type");
        query.addOrderByAscending("name");
        principals = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putPermissionQuery(cacheKey, null, this.extractPrincipalIds(principals), permission.getId() != null ? permission.getId() : JSPMCache.ANY_ID, securityDomain, new ArrayList(principals));
        return principals;
    }

    @Override
    public void addPermission(PersistentJetspeedPermission permission) throws SecurityException {
        if (permission.getId() != null || this.permissionExists(permission)) {
            throw new SecurityException(SecurityException.PERMISSION_ALREADY_EXISTS.create((Object)permission.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)permission);
            this.jspmCache.evictPermission(permission.getId());
            this.jspmCache.putPermission(permission.getId(), permission);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"addPermission", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void updatePermission(PersistentJetspeedPermission permission) throws SecurityException {
        Criteria criteria = new Criteria();
        if (permission.getId() == null) {
            criteria.addEqualTo("type", (Object)permission.getType());
            criteria.addEqualTo("name", (Object)permission.getName());
        } else {
            criteria.addEqualTo("id", (Object)permission.getId());
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        PersistentJetspeedPermission current = (PersistentJetspeedPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (current == null) {
            throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
        }
        if (!current.getActions().equals(permission.getActions())) {
            current.setActions(permission.getActions());
            try {
                this.getPersistenceBrokerTemplate().store((Object)current);
                this.jspmCache.evictPermission(current.getId());
                this.jspmCache.putPermission(current.getId(), current);
            }
            catch (Exception pbe) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"updatePermission", (Object)pbe.getMessage());
                this.logger.error((Object)msg, (Throwable)pbe);
                throw new SecurityException(msg, (Throwable)pbe);
            }
        }
    }

    @Override
    public void removePermission(PersistentJetspeedPermission permission) throws SecurityException {
        Criteria criteria = new Criteria();
        if (permission.getId() == null) {
            criteria.addEqualTo("type", (Object)permission.getType());
            criteria.addEqualTo("name", (Object)permission.getName());
        } else {
            criteria.addEqualTo("id", (Object)permission.getId());
        }
        QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
        PersistentJetspeedPermission current = (PersistentJetspeedPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (current == null) {
            throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().delete((Object)current);
            this.jspmCache.evictPermission(current.getId());
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removePermission", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void grantPermission(PersistentJetspeedPermission permission, JetspeedPrincipal principal) throws SecurityException {
        if (permission.getId() == null) {
            Criteria criteria = new Criteria();
            criteria.addEqualTo("type", (Object)permission.getType());
            criteria.addEqualTo("name", (Object)permission.getName());
            QueryByCriteria query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
            PersistentJetspeedPermission p = (PersistentJetspeedPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (p == null) {
                throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
            }
            permission = p;
        }
        this.grantPermission(permission, principal, true);
    }

    protected void grantPermission(PersistentJetspeedPermission permission, JetspeedPrincipal principal, boolean checkExists) throws SecurityException {
        if (principal.isTransient() || principal.getId() == null) {
            JetspeedPrincipal p = this.getPrincipal(principal.getName(), principal.getType());
            if (p == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(principal.getType().getName(), (Object)principal.getName()));
            }
            principal = p;
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)principal.getId());
        criteria.addEqualTo("permissionId", (Object)permission.getId());
        QueryByCriteria query = QueryFactory.newQuery(JetspeedPrincipalPermission.class, (Criteria)criteria);
        if (!checkExists || this.getPersistenceBrokerTemplate().getCount((Query)query) == 0) {
            try {
                this.getPersistenceBrokerTemplate().store((Object)new JetspeedPrincipalPermission(principal, permission));
                this.jspmCache.evictPrincipal(permission.getId());
                this.jspmCache.evictPermission(permission.getId());
            }
            catch (Exception pbe) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"grantPermission", (Object)pbe.getMessage());
                this.logger.error((Object)msg, (Throwable)pbe);
                throw new SecurityException(msg, (Throwable)pbe);
            }
        }
    }

    @Override
    public void grantPermissionOnlyTo(PersistentJetspeedPermission permission, String principalType, List<JetspeedPrincipal> principals) throws SecurityException {
        this.grantPermissionOnlyTo(permission, principalType, principals, this.getDefaultSecurityDomainId());
    }

    public void grantPermissionOnlyTo(PersistentJetspeedPermission permission, String principalType, List<JetspeedPrincipal> principals, Long securityDomain) throws SecurityException {
        QueryByCriteria query;
        Criteria criteria;
        if (permission.getId() == null) {
            criteria = new Criteria();
            criteria.addEqualTo("type", (Object)permission.getType());
            criteria.addEqualTo("name", (Object)permission.getName());
            query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
            PersistentJetspeedPermission p = (PersistentJetspeedPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (p == null) {
                throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
            }
            permission = p;
        }
        criteria = new Criteria();
        criteria.addEqualTo("permissions.permissionId", (Object)permission.getId());
        if (principalType != null) {
            criteria.addEqualTo("type", (Object)principalType);
        }
        criteria.addEqualTo("domainId", (Object)securityDomain);
        query = QueryFactory.newQuery(PersistentJetspeedPrincipal.class, (Criteria)criteria);
        List currentList = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        ArrayList<JetspeedPrincipal> targetList = new ArrayList<JetspeedPrincipal>(principals);
        Iterator i = currentList.iterator();
        while (i.hasNext()) {
            JetspeedPrincipal current = (JetspeedPrincipal)i.next();
            Iterator j = targetList.iterator();
            while (j.hasNext()) {
                JetspeedPrincipal target = (JetspeedPrincipal)j.next();
                if (principalType != null && !target.getType().getName().equals(principalType)) {
                    throw new SecurityException(SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"grantPermissionOnlyTo", (Object)("Specified " + target.getType().getName() + " principal: " + target.getName() + " is not of type: " + principalType)));
                }
                if (!current.getType().getName().equals(target.getType().getName()) || !current.getName().equals(target.getName())) continue;
                j.remove();
                current = null;
                break;
            }
            if (current != null) continue;
            i.remove();
        }
        i = currentList.iterator();
        while (i.hasNext()) {
            this.revokePermission(permission, (JetspeedPrincipal)i.next());
        }
        i = targetList.iterator();
        while (i.hasNext()) {
            this.grantPermission(permission, (JetspeedPrincipal)i.next(), false);
        }
    }

    @Override
    public void revokePermission(PersistentJetspeedPermission permission, JetspeedPrincipal principal) throws SecurityException {
        QueryByCriteria query;
        Criteria criteria;
        Long principalId = null;
        if (principal.isTransient() || principal.getId() == null) {
            Long securityDomain = principal.getDomainId() != null ? principal.getDomainId() : this.getDefaultSecurityDomainId();
            principalId = this.getPrincipalId(principal.getName(), principal.getType().getName(), securityDomain);
        } else {
            principalId = principal.getId();
        }
        if (permission.getId() == null) {
            criteria = new Criteria();
            criteria.addEqualTo("type", (Object)permission.getType());
            criteria.addEqualTo("name", (Object)permission.getName());
            query = QueryFactory.newQuery(PersistentJetspeedPermissionImpl.class, (Criteria)criteria);
            PersistentJetspeedPermission p = (PersistentJetspeedPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (p == null) {
                throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
            }
            permission = p;
        }
        criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)principalId);
        criteria.addEqualTo("permissionId", (Object)permission.getId());
        query = QueryFactory.newQuery(JetspeedPrincipalPermission.class, (Criteria)criteria);
        try {
            this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
            this.jspmCache.evictPrincipal(principalId);
            this.jspmCache.evictPermission(permission.getId());
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"revokePermission", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void revokeAllPermissions(JetspeedPrincipal principal) throws SecurityException {
        Long principalId = null;
        Criteria criteria = new Criteria();
        if (principal.isTransient() || principal.getId() == null) {
            Long securityDomain = principal.getDomainId() != null ? principal.getDomainId() : this.getDefaultSecurityDomainId();
            principalId = this.getPrincipalId(principal.getName(), principal.getType().getName(), securityDomain);
        } else {
            principalId = principal.getId();
        }
        criteria.addEqualTo("principalId", (Object)principalId);
        QueryByCriteria query = QueryFactory.newQuery(JetspeedPrincipalPermission.class, (Criteria)criteria);
        try {
            this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
            this.jspmCache.evictPrincipal(principalId);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"revokeAllPermissions", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    protected boolean domainExists(SecurityDomain domain) {
        if (domain.getDomainId() != null) {
            return this.getDomain(domain.getDomainId()) != null;
        }
        return this.getDomainByName(domain.getName()) != null;
    }

    @Override
    public void addDomain(SecurityDomain domain) throws SecurityException {
        if (this.domainExists(domain)) {
            throw new SecurityException(SecurityException.SECURITY_DOMAIN_EXISTS.create((Object)domain.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)domain);
            this.jspmCache.evictDomain(domain.getDomainId());
            this.jspmCache.putDomain(domain.getDomainId(), domain);
        }
        catch (Exception pbe) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"addDomain", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public SecurityDomain getDomain(Long domainId) {
        Object domain = this.jspmCache.getDomain(domainId);
        if (domain != null) {
            return domain != JSPMCache.CACHE_NULL ? (SecurityDomain)domain : null;
        }
        try {
            domain = this.getPersistenceBrokerTemplate().getObjectById(SecurityDomainImpl.class, (Object)domainId);
        }
        catch (ObjectRetrievalFailureException objectRetrievalFailureException) {
            // empty catch block
        }
        this.jspmCache.putDomain(domainId, domain != null ? domain : JSPMCache.CACHE_NULL);
        return (SecurityDomain)domain;
    }

    protected Long getDefaultSecurityDomainId() {
        if (this.defaultSecurityDomainId == null) {
            SecurityDomain d = this.getDomainByName("[default]");
            if (d != null) {
                this.defaultSecurityDomainId = d.getDomainId();
            } else {
                throw new IllegalStateException("The default security domain could not be found.");
            }
        }
        return this.defaultSecurityDomainId;
    }

    @Override
    public SecurityDomain getDomainByName(String domainName) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", (Object)domainName);
        String cacheKey = "getDomainByName:" + criteria;
        Object domain = this.jspmCache.getDomainQuery(cacheKey);
        if (domain != null) {
            return domain != JSPMCache.CACHE_NULL ? (SecurityDomain)domain : null;
        }
        QueryByCriteria query = QueryFactory.newQuery(SecurityDomainImpl.class, (Criteria)criteria);
        domain = this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (domain != null) {
            this.jspmCache.putDomainQuery(cacheKey, ((SecurityDomain)domain).getDomainId(), domain);
        } else {
            this.jspmCache.putDomainQuery(cacheKey, JSPMCache.ANY_ID, JSPMCache.CACHE_NULL);
        }
        return (SecurityDomain)domain;
    }

    @Override
    public Collection<SecurityDomain> getAllDomains() {
        String cacheKey = "getDomains:[]";
        List domains = (List)this.jspmCache.getDomainQuery(cacheKey);
        if (domains != null) {
            return new ArrayList<SecurityDomain>(domains);
        }
        QueryByCriteria query = QueryFactory.newQuery(SecurityDomainImpl.class, (Criteria)new Criteria());
        query.addOrderByAscending("name");
        domains = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putDomainQuery(cacheKey, JSPMCache.ANY_ID, new ArrayList(domains));
        return domains;
    }

    @Override
    public void removeDomain(SecurityDomain domain) throws SecurityException {
        if (!this.domainExists(domain)) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.create((Object)domain.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().delete((Object)domain);
            this.jspmCache.evictDomain(domain.getDomainId());
        }
        catch (Exception pbe) {
            if (pbe instanceof DataIntegrityViolationException) {
                this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                throw new SecurityException(SecurityException.SECURITY_DOMAIN_NOT_REMOVABLE.create((Object)domain.getName()));
            }
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"removeDomain", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public void updateDomain(SecurityDomain domain) throws SecurityException {
        if (!this.domainExists(domain)) {
            throw new SecurityException(SecurityException.SECURITY_DOMAIN_DOES_NOT_EXIST.create((Object)domain.getName()));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)domain);
            this.jspmCache.evictDomain(domain.getDomainId());
            this.jspmCache.putDomain(domain.getDomainId(), domain);
        }
        catch (Exception pbe) {
            if (pbe instanceof DataIntegrityViolationException) {
                this.logger.error((Object)pbe.getMessage(), (Throwable)pbe);
                throw new SecurityException(SecurityException.SECURITY_DOMAIN_UPDATE_FAILURE.create((Object)domain.getDomainId()));
            }
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"JetspeedSecurityPersistenceManager", (Object)"updateDomain", (Object)pbe.getMessage());
            this.logger.error((Object)msg, (Throwable)pbe);
            throw new SecurityException(msg, (Throwable)pbe);
        }
    }

    @Override
    public Collection<SecurityDomain> getDomainsOwnedBy(Long ownerDomainId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("ownerDomainId", (Object)ownerDomainId);
        String cacheKey = "getDomainsOwnedBy:" + criteria;
        List domains = (List)this.jspmCache.getDomainQuery(cacheKey);
        if (domains != null) {
            return new ArrayList<SecurityDomain>(domains);
        }
        QueryByCriteria query = QueryFactory.newQuery(SecurityDomainImpl.class, (Criteria)criteria);
        query.addOrderByAscending("name");
        domains = (List)this.getPersistenceBrokerTemplate().execute((PersistenceBrokerCallback)new ManagedListByQueryCallback((Query)query));
        this.jspmCache.putDomainQuery(cacheKey, JSPMCache.ANY_ID, new ArrayList(domains));
        return domains;
    }

    @Override
    public JetspeedPrincipalResultList getPrincipals(JetspeedPrincipalQueryContext queryContext, JetspeedPrincipalType type) {
        return this.getPrincipals(queryContext, type, this.getDefaultSecurityDomainId());
    }

    @Override
    public JetspeedPrincipalResultList getPrincipals(JetspeedPrincipalQueryContext queryContext, JetspeedPrincipalType type, Long securityDomain) {
        JetspeedPrincipalLookupManager jppm = this.jpplf.getJetspeedPrincipalLookupManager();
        queryContext.put((Object)"jetspeedPrincipalType", (Object)type.getName());
        queryContext.put((Object)"securityDomain", (Object)securityDomain);
        return jppm.getPrincipals(queryContext);
    }

    protected static class ManagedListByQueryCallback
    implements PersistenceBrokerCallback {
        private Query query;

        public ManagedListByQueryCallback(Query query) {
            this.query = query;
        }

        public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException, LookupException, SQLException {
            return pb.getCollectionByQuery(ManageableArrayList.class, this.query);
        }
    }
}

