/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao.impl;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.EntitySearchResultHandler;
import org.apache.jetspeed.security.mapping.ldap.dao.EntityDAO;
import org.apache.jetspeed.security.mapping.ldap.dao.impl.AbstractRelationDAO;
import org.apache.jetspeed.security.mapping.model.Attribute;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

public class AttributeBasedRelationDAO
extends AbstractRelationDAO {
    private String relationAttribute;
    private boolean useFromEntityAttribute;
    private boolean attributeContainsInternalId;

    @Override
    public void getRelatedEntitiesFrom(EntityDAO fromDAO, EntityDAO toDAO, Entity fromEntity, EntitySearchResultHandler handler) throws SecurityException {
        this.internalGetRelatedEntities(fromDAO, toDAO, this.useFromEntityAttribute, fromEntity, handler);
    }

    @Override
    public void getRelatedEntitiesTo(EntityDAO fromDAO, EntityDAO toDAO, Entity toEntity, EntitySearchResultHandler handler) throws SecurityException {
        this.internalGetRelatedEntities(toDAO, fromDAO, !this.useFromEntityAttribute, toEntity, handler);
    }

    private void internalGetRelatedEntities(EntityDAO fromDAO, EntityDAO toDAO, boolean useFromEntityAttribute, Entity entity, EntitySearchResultHandler handler) throws SecurityException {
        if (useFromEntityAttribute) {
            Attribute relationAttrValue = entity.getAttribute(this.relationAttribute);
            if (relationAttrValue != null) {
                Collection<String> values = relationAttrValue.getValues();
                AttributeDef attrDef = relationAttrValue.getDefinition();
                if (attrDef.isMultiValue() && attrDef.isRequired()) {
                    String defaultValue = attrDef.requiresDnDefaultValue() ? entity.getInternalId() : attrDef.getRequiredDefaultValue();
                    values.remove(defaultValue);
                }
                if (this.attributeContainsInternalId) {
                    toDAO.getEntitiesByInternalId(values, handler);
                } else {
                    toDAO.getEntitiesById(values, handler);
                }
            }
        } else {
            String fromEntityUsedIdValue;
            String string = fromEntityUsedIdValue = this.attributeContainsInternalId ? this.getInternalId(entity, fromDAO) : entity.getId();
            if (!StringUtils.isEmpty((String)fromEntityUsedIdValue)) {
                EqualsFilter memberAttrFilter = new EqualsFilter(this.relationAttribute, fromEntityUsedIdValue);
                toDAO.getEntities((Filter)memberAttrFilter, handler);
            }
        }
    }

    private String getInternalId(Entity entity, EntityDAO entityDao) throws SecurityException {
        if (StringUtils.isEmpty((String)entity.getInternalId())) {
            entity = entityDao.getEntity(entity.getId());
        }
        return entity.getInternalId();
    }

    public void setRelationAttribute(String relationAttribute) {
        this.relationAttribute = relationAttribute;
    }

    public void setUseFromEntityAttribute(boolean useFromEntityAttribute) {
        this.useFromEntityAttribute = useFromEntityAttribute;
    }

    public void setAttributeContainsInternalId(boolean attributeContainsInternalId) {
        this.attributeContainsInternalId = attributeContainsInternalId;
    }

    @Override
    public void addRelation(EntityDAO sourceDao, EntityDAO targetDao, String sourceEntityId, String targetEntityId) throws SecurityException {
        if (this.useFromEntityAttribute) {
            sourceDao.addRelation(sourceEntityId, targetDao.getInternalId(targetEntityId, true), this.relationAttribute);
        } else {
            targetDao.addRelation(targetEntityId, sourceDao.getInternalId(sourceEntityId, true), this.relationAttribute);
        }
    }

    @Override
    public void removeRelation(EntityDAO sourceDao, EntityDAO targetDao, String sourceEntityId, String targetEntityId) throws SecurityException {
        if (this.useFromEntityAttribute) {
            String internalEntityId = targetDao.getInternalId(targetEntityId, false);
            if (internalEntityId != null) {
                sourceDao.removeRelation(sourceEntityId, internalEntityId, this.relationAttribute);
            }
        } else {
            String internalEntityId = sourceDao.getInternalId(sourceEntityId, false);
            if (internalEntityId != null) {
                targetDao.removeRelation(targetEntityId, internalEntityId, this.relationAttribute);
            }
        }
    }
}

