/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.filter.Filter;

public class LDAPEntityDAOConfiguration {
    private static final int DEFAULT_SEARCH_PAGE_SIZE = 256;
    private DistinguishedName baseDN = new DistinguishedName().immutableDistinguishedName();
    private DistinguishedName searchDN = new DistinguishedName().immutableDistinguishedName();
    private Filter baseFilter;
    private String ldapIdAttribute;
    private Map<String, AttributeDef> attributeDefinitions;
    private Map<String, AttributeDef> entityAttributeDefinitions;
    private String entityType;
    private String[] objectClassesArr;
    private String[] entityAttributeNames;
    private int searchPageSize = 256;

    public void initialize() throws JetspeedException {
        this.checkNotEmpty("entityType", this.entityType);
        this.checkNotEmpty("ldapIdAttribute", this.ldapIdAttribute);
        this.checkNotNull("attributeDefinitions", this.attributeDefinitions);
        boolean idAttributeNameFound = false;
        for (AttributeDef def : this.attributeDefinitions.values()) {
            if (!this.ldapIdAttribute.equals(def.getName())) continue;
            if (def.isMultiValue() || !def.isRequired() || def.isRelationOnly()) {
                throw new RuntimeException("Unsupported ldapIdAttribute Attribute definition: multi-value, optional and/or relationOnly attribute");
            }
            def.setEntityIdAttribute(true);
            idAttributeNameFound = true;
            break;
        }
        if (!idAttributeNameFound) {
            throw new RuntimeException("No ldapIdAttribute Attribute definition provided");
        }
    }

    private void checkNotNull(String fieldName, Object fieldValue) throws JetspeedException {
        if (fieldValue == null) {
            throw new JetspeedException(this.getClass().getName() + ": property '" + fieldName + "' cannot be null.");
        }
    }

    private void checkNotEmpty(String fieldName, String fieldValue) throws JetspeedException {
        if (fieldValue == null) {
            throw new JetspeedException(this.getClass().getName() + ": property '" + fieldName + "' cannot be null or empty.");
        }
    }

    public int getSearchPageSize() {
        return this.searchPageSize;
    }

    public void setSearchPageSize(int searchPageSize) {
        this.searchPageSize = searchPageSize;
    }

    public DistinguishedName getBaseDN() {
        return this.baseDN;
    }

    public void setLdapBase(String ldapBase) {
        this.baseDN = new DistinguishedName(ldapBase).immutableDistinguishedName();
    }

    public DistinguishedName getSearchDN() {
        return this.searchDN;
    }

    public void setSearchBase(String searchBase) {
        this.searchDN = new DistinguishedName(searchBase).immutableDistinguishedName();
    }

    public Filter getSearchFilter() {
        return this.baseFilter;
    }

    public void setSearchFilter(Filter baseFilter) {
        this.baseFilter = baseFilter;
    }

    public Map<String, AttributeDef> getAttributeDefinitionsMap() {
        return this.attributeDefinitions;
    }

    public Map<String, AttributeDef> getEntityAttributeDefinitionsMap() {
        return this.attributeDefinitions;
    }

    public AttributeDef getAttributeDef(String name) {
        return this.attributeDefinitions.get(name);
    }

    public void setAttributeDefinitions(Collection<AttributeDef> attributeDefinitions) {
        this.attributeDefinitions = new HashMap<String, AttributeDef>();
        this.entityAttributeDefinitions = new HashMap<String, AttributeDef>();
        for (AttributeDef def : attributeDefinitions) {
            if (!def.isRelationOnly()) {
                this.entityAttributeDefinitions.put(def.getName(), def);
            }
            this.attributeDefinitions.put(def.getName(), def);
        }
        this.entityAttributeNames = this.entityAttributeDefinitions.keySet().toArray(new String[0]);
    }

    public String[] getEntityAttributeNames() {
        return this.entityAttributeNames;
    }

    public String getLdapIdAttribute() {
        return this.ldapIdAttribute;
    }

    public void setLdapIdAttribute(String ldapIdAttribute) {
        this.ldapIdAttribute = ldapIdAttribute;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String[] getObjectClassesArray() {
        return this.objectClassesArr;
    }

    public void setObjectClasses(String objectClasses) {
        if (objectClasses != null) {
            this.objectClassesArr = objectClasses.split(",");
        }
    }
}

