/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.jetspeed.security.AlgorithmUpgradePasswordEncodingService;
import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.CredentialPasswordValidator;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.impl.AbstractPasswordCredentialInterceptorImpl;

public class EncodePasswordOnFirstLoadInterceptor
extends AbstractPasswordCredentialInterceptorImpl {
    @Override
    public boolean afterLoad(String userName, PasswordCredential credential, CredentialPasswordEncoder encoder, CredentialPasswordValidator validator) throws SecurityException {
        boolean updated = false;
        if (credential.getPassword() != null && !credential.isEncoded() && encoder != null) {
            credential.setPassword(encoder.encode(userName, credential.getPassword()), true);
            credential.clearNewPasswordSet();
            if (encoder instanceof AlgorithmUpgradePasswordEncodingService) {
                credential.setPreviousAuthenticationDate(new Timestamp(new Date().getTime()));
                credential.setLastAuthenticationDate(null);
            }
            updated = true;
        }
        return updated;
    }
}

