/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.ldap.dao.LDAPEntityDAOConfiguration;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.mapping.model.impl.AttributeImpl;
import org.apache.jetspeed.security.mapping.model.impl.EntityImpl;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapRdn;
import org.springframework.ldap.support.LdapUtils;

public class EntityFactoryImpl
implements EntityFactory {
    private LDAPEntityDAOConfiguration searchConfiguration;
    private boolean createAllowed = true;
    private boolean updateAllowed = true;
    private boolean removeAllowed = true;

    public EntityFactoryImpl(LDAPEntityDAOConfiguration searchConfiguration) {
        this.searchConfiguration = searchConfiguration;
    }

    @Override
    public String getEntityType() {
        return this.searchConfiguration.getEntityType();
    }

    @Override
    public boolean isCreateAllowed() {
        return this.createAllowed;
    }

    public void setCreateAllowed(boolean createAllowed) {
        this.createAllowed = createAllowed;
    }

    @Override
    public boolean isUpdateAllowed() {
        return this.updateAllowed;
    }

    public void setUpdateAllowed(boolean updateAllowed) {
        this.updateAllowed = updateAllowed;
    }

    @Override
    public boolean isRemoveAllowed() {
        return this.removeAllowed;
    }

    public void setRemoveAllowed(boolean removeAllowed) {
        this.removeAllowed = removeAllowed;
    }

    protected EntityImpl internalCreateEntity(String entityId, String internalId, Set<org.apache.jetspeed.security.mapping.model.Attribute> attributes) {
        EntityImpl entity = new EntityImpl(this.searchConfiguration.getEntityType(), entityId, this.searchConfiguration.getAttributeDefinitionsMap());
        entity.setAttributes(attributes);
        if (internalId != null) {
            entity.setInternalId(internalId);
        }
        return entity;
    }

    @Override
    public Entity createEntity(JetspeedPrincipal principal) {
        HashSet<org.apache.jetspeed.security.mapping.model.Attribute> ldapAttrValues = new HashSet<org.apache.jetspeed.security.mapping.model.Attribute>();
        SecurityAttributes sas = principal.getSecurityAttributes();
        for (AttributeDef attrDef : this.searchConfiguration.getEntityAttributeDefinitionsMap().values()) {
            SecurityAttribute sa;
            if (!attrDef.isMapped() || (sa = sas.getAttribute(attrDef.getMappedName())) == null) continue;
            AttributeImpl attr = new AttributeImpl(attrDef);
            attr.setValue(sa.getStringValue());
            ldapAttrValues.add(attr);
        }
        return this.internalCreateEntity(principal.getName(), null, ldapAttrValues);
    }

    protected List<String> getStringAttributes(Attributes originalAttrs, String name, boolean containsDN) {
        int size;
        ArrayList<String> attributes = null;
        Attribute attribute = originalAttrs.get(name);
        if (attribute != null && (size = attribute.size()) > 0) {
            attributes = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                try {
                    String value = (String)attribute.get(i);
                    if (containsDN && !StringUtils.isEmpty((String)value)) {
                        value = new DistinguishedName(value).toCompactString();
                    }
                    attributes.add(value);
                    continue;
                }
                catch (NamingException e) {
                    throw LdapUtils.convertLdapException((NamingException)e);
                }
            }
        }
        return attributes;
    }

    @Override
    public Entity loadEntity(Object providerContext) {
        EntityImpl entity = null;
        DirContextOperations ctx = null;
        if (providerContext instanceof SearchResult) {
            ctx = (DirContextOperations)((SearchResult)providerContext).getObject();
        } else if (providerContext instanceof DirContextAdapter) {
            ctx = (DirContextOperations)providerContext;
        }
        if (ctx != null) {
            String entityId = null;
            String dn = ctx.getNameInNamespace();
            HashSet<org.apache.jetspeed.security.mapping.model.Attribute> attributes = new HashSet<org.apache.jetspeed.security.mapping.model.Attribute>();
            Attributes attrs = ctx.getAttributes();
            for (AttributeDef attrDef : this.searchConfiguration.getEntityAttributeDefinitionsMap().values()) {
                List<String> values = null;
                values = this.getStringAttributes(attrs, attrDef.getName(), attrDef.requiresDnDefaultValue());
                if (values == null) continue;
                AttributeImpl a = new AttributeImpl(attrDef);
                if (attrDef.isMultiValue()) {
                    if (attrDef.isRequired()) {
                        String defaultValue = attrDef.requiresDnDefaultValue() ? dn : attrDef.getRequiredDefaultValue();
                        values.remove(defaultValue);
                    }
                    if (values.size() != 0) {
                        a.setValues(values);
                    } else {
                        attributes.add(a);
                    }
                } else {
                    String value = values.get(0);
                    if (attrDef.isEntityIdAttribute()) {
                        entityId = value;
                    }
                    a.setValue(value);
                }
                attributes.add(a);
            }
            if (entityId == null) {
                DistinguishedName name = new DistinguishedName(dn);
                LdapRdn rdn = name.getLdapRdn(name.size() - 1);
                if (rdn.getKey().equals(this.searchConfiguration.getLdapIdAttribute())) {
                    entityId = rdn.getValue();
                } else {
                    return null;
                }
            }
            entity = this.internalCreateEntity(entityId, dn, attributes);
            entity.setLive(true);
        }
        return entity;
    }
}

