/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.util.List;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.BaseJetspeedPrincipalManager;
import org.apache.jetspeed.security.impl.RoleImpl;
import org.apache.jetspeed.security.impl.TransientRole;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalStorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleManagerImpl
extends BaseJetspeedPrincipalManager
implements RoleManager {
    private static final Logger log = LoggerFactory.getLogger(RoleManagerImpl.class);
    private JetspeedPrincipalType userType;
    private JetspeedPrincipalType groupType;
    private UserManager userManager;
    private GroupManager groupManager;

    public RoleManagerImpl(JetspeedPrincipalType principalType, JetspeedPrincipalType userType, JetspeedPrincipalType groupType, JetspeedPrincipalAccessManager jpam, JetspeedPrincipalStorageManager jpsm) {
        super(principalType, jpam, jpsm);
        this.userType = userType;
        this.groupType = groupType;
    }

    public void checkInitialized() {
        if (this.userManager == null) {
            this.userManager = (UserManager)this.getPrincipalManagerProvider().getManager(this.userType);
        }
        if (this.groupManager == null) {
            this.groupManager = (GroupManager)this.getPrincipalManagerProvider().getManager(this.groupType);
        }
    }

    public Role newRole(String name, boolean mapped) {
        RoleImpl role = new RoleImpl(name);
        role.setMapped(mapped);
        return role;
    }

    public Role newTransientRole(String name) {
        TransientRole role = new TransientRole(name);
        return role;
    }

    public Role addRole(String roleName) throws SecurityException {
        return this.addRole(roleName, true);
    }

    public Role addRole(String roleName, boolean mapped) throws SecurityException {
        Role role = this.newRole(roleName, mapped);
        super.addPrincipal((JetspeedPrincipal)role, null);
        if (log.isDebugEnabled()) {
            log.debug("Added role: " + roleName);
        }
        return role;
    }

    public void removeRole(String roleName) throws SecurityException {
        super.removePrincipal(roleName);
    }

    public boolean roleExists(String roleName) {
        return super.principalExists(roleName);
    }

    public Role getRole(String roleName) throws SecurityException {
        Role role = (Role)super.getPrincipal(roleName);
        if (null == role) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("role", (Object)roleName));
        }
        return role;
    }

    public List<Role> getRolesForUser(String username) throws SecurityException {
        return super.getAssociatedFrom(username, this.userType, "isMemberOf");
    }

    public List<Role> getRolesInGroup(String groupName) throws SecurityException {
        return super.getAssociatedFrom(groupName, this.groupType, "isMemberOf");
    }

    public void addRoleToUser(String username, String roleName) throws SecurityException {
        this.checkInitialized();
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)username));
        }
        Role role = this.getRole(roleName);
        if (role == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("role", (Object)roleName));
        }
        super.addAssociation((JetspeedPrincipal)user, (JetspeedPrincipal)role, "isMemberOf");
    }

    public void removeRoleFromUser(String username, String roleName) throws SecurityException {
        this.checkInitialized();
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)username));
        }
        Role role = this.getRole(roleName);
        if (role == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("role", (Object)roleName));
        }
        super.removeAssociation((JetspeedPrincipal)user, (JetspeedPrincipal)role, "isMemberOf");
    }

    public boolean isUserInRole(String username, String roleName) throws SecurityException {
        return this.getAssociatedNamesFrom(username, this.userType, "isMemberOf").contains(roleName);
    }

    public void addRoleToGroup(String roleName, String groupName) throws SecurityException {
        this.checkInitialized();
        Group group = this.groupManager.getGroup(groupName);
        if (group == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("group", (Object)groupName));
        }
        Role role = this.getRole(roleName);
        if (role == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("role", (Object)roleName));
        }
        super.addAssociation((JetspeedPrincipal)group, (JetspeedPrincipal)role, "isMemberOf");
    }

    public void removeRoleFromGroup(String roleName, String groupName) throws SecurityException {
        this.checkInitialized();
        Group group = this.groupManager.getGroup(groupName);
        if (group == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("group", (Object)groupName));
        }
        Role role = this.getRole(roleName);
        if (role == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("role", (Object)roleName));
        }
        super.removeAssociation((JetspeedPrincipal)group, (JetspeedPrincipal)role, "isMemberOf");
    }

    public boolean isGroupInRole(String groupName, String roleName) throws SecurityException {
        return this.getAssociatedNamesFrom(groupName, this.groupType, "isMemberOf").contains(roleName);
    }

    public List<Role> getRoles(String nameFilter) throws SecurityException {
        return super.getPrincipals(nameFilter);
    }

    public List<String> getRoleNames(String nameFilter) throws SecurityException {
        return this.getPrincipalNames(nameFilter);
    }

    public void updateRole(Role role) throws SecurityException {
        super.updatePrincipal((JetspeedPrincipal)role);
    }

    public void addRoleToRole(Role from, Role to, String associationName) throws SecurityException {
        this.addAssociation((JetspeedPrincipal)from, (JetspeedPrincipal)to, associationName);
    }

    public void removeRoleFromRole(Role from, Role to, String associationName) throws SecurityException {
        this.removeAssociation((JetspeedPrincipal)from, (JetspeedPrincipal)to, associationName);
    }

    public List<Role> getRolesAssociatedFrom(Role from, String associationName) {
        return this.getAssociatedFrom(from.getName(), from.getType(), associationName);
    }

    public List<Role> getRolesAssociatedTo(Role to, String associationName) {
        return this.getAssociatedTo(to.getName(), to.getType(), associationName);
    }

    public JetspeedPrincipal newPrincipal(String name, boolean mapped) {
        return this.newRole(name, mapped);
    }

    public JetspeedPrincipal newTransientPrincipal(String name) {
        return this.newTransientRole(name);
    }
}

