/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jetspeed.security.AuthenticatedUser;
import org.apache.jetspeed.security.AuthenticationProvider;
import org.apache.jetspeed.security.LoginModuleProxy;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserSubjectPrincipal;
import org.apache.jetspeed.security.impl.LoginModuleProxyImpl;
import org.apache.jetspeed.security.impl.PassiveCallbackHandler;
import org.apache.jetspeed.security.impl.RoleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(DefaultLoginModule.class);
    protected boolean debug;
    protected boolean success;
    protected boolean commitSuccess;
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map<String, ?> sharedState;
    protected Map<String, ?> options;
    protected AuthenticationProvider authProvider;
    protected UserManager ums;
    protected String portalUserRole;
    protected String username;
    protected AuthenticatedUser user;

    public DefaultLoginModule() {
        LoginModuleProxy loginModuleProxy = LoginModuleProxyImpl.loginModuleProxy;
        if (loginModuleProxy != null) {
            this.authProvider = loginModuleProxy.getAuthenticationProvider();
            this.ums = loginModuleProxy.getUserManager();
            this.portalUserRole = loginModuleProxy.getPortalUserRole();
        }
        this.debug = false;
        this.success = false;
        this.commitSuccess = false;
        this.username = null;
    }

    protected DefaultLoginModule(AuthenticationProvider authProvider, UserManager userManager, String portalUserRole) {
        this.authProvider = authProvider;
        this.ums = userManager;
        this.portalUserRole = portalUserRole;
        this.debug = false;
        this.success = false;
        this.commitSuccess = false;
        this.username = null;
    }

    protected DefaultLoginModule(AuthenticationProvider authProvider, UserManager userManager) {
        this(authProvider, userManager, "portal-user");
    }

    @Override
    public boolean abort() throws LoginException {
        this.success = false;
        this.commitSuccess = false;
        this.username = null;
        if (this.callbackHandler instanceof PassiveCallbackHandler) {
            ((PassiveCallbackHandler)this.callbackHandler).clearPassword();
        }
        this.logout();
        return true;
    }

    protected void refreshProxy() {
        LoginModuleProxy loginModuleProxy;
        if (this.ums == null && (loginModuleProxy = LoginModuleProxyImpl.loginModuleProxy) != null) {
            this.authProvider = loginModuleProxy.getAuthenticationProvider();
            this.ums = loginModuleProxy.getUserManager();
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.success) {
            if (this.subject.isReadOnly()) {
                throw new LoginException("Subject is Readonly");
            }
            try {
                this.refreshProxy();
                this.commitSubject(this.subject, this.ums.getSubject(this.user), this.user);
                this.username = null;
                this.user = null;
                this.commitSuccess = true;
                if (this.callbackHandler instanceof PassiveCallbackHandler) {
                    ((PassiveCallbackHandler)this.callbackHandler).clearPassword();
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new LoginException(ex.getMessage());
            }
        }
        return this.commitSuccess;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.refreshProxy();
            this.success = false;
            try {
                this.user = this.authProvider.authenticate(this.username, password);
            }
            catch (SecurityException se) {
                if (se.getCause() != null) {
                    log.error(se.getLocalizedMessage(), se.getCause());
                } else {
                    log.warn(se.getLocalizedMessage());
                }
                throw new FailedLoginException("Authentication failed");
            }
            this.success = true;
            callbacks[0] = null;
            callbacks[1] = null;
            return true;
        }
        catch (LoginException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.success = false;
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.user = null;
        this.subject.getPrincipals().clear();
        this.subject.getPrivateCredentials().clear();
        this.subject.getPublicCredentials().clear();
        this.success = false;
        this.commitSuccess = false;
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        if (options.containsKey("debug")) {
            this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        }
    }

    protected void commitSubject(Subject containerSubject, Subject jetspeedSubject, AuthenticatedUser user) {
        this.subject.getPrincipals().add(SubjectHelper.getPrincipal((Subject)jetspeedSubject, UserSubjectPrincipal.class));
        this.subject.getPrincipals().add(SubjectHelper.getPrincipal((Subject)jetspeedSubject, User.class));
        boolean hasPortalUserRole = false;
        for (Principal role : SubjectHelper.getPrincipals((Subject)jetspeedSubject, Role.class)) {
            this.subject.getPrincipals().add(role);
            if (!role.getName().equals(this.portalUserRole)) continue;
            hasPortalUserRole = true;
        }
        if (!hasPortalUserRole) {
            this.subject.getPrincipals().add((Principal)((Object)new RoleImpl(this.portalUserRole)));
        }
    }
}

