/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.Set;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationReference;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.SecurityEntityManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalStorageManager;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedPrincipalLdapStorageManager
implements JetspeedPrincipalStorageManager {
    private SecurityEntityManager ldapEntityManager;
    private JetspeedPrincipalStorageManager delegateJpsm;

    public JetspeedPrincipalLdapStorageManager(JetspeedPrincipalStorageManager databaseStorage, SecurityEntityManager ldapEntityManager) {
        this.delegateJpsm = databaseStorage;
        this.ldapEntityManager = ldapEntityManager;
    }

    @Override
    public void addPrincipal(JetspeedPrincipal principal, Set<JetspeedPrincipalAssociationReference> associations) throws SecurityException {
        EntityFactory entityFactory;
        if (!SynchronizationStateAccess.isSynchronizing() && !this.ldapEntityManager.isReadOnly() && (entityFactory = this.ldapEntityManager.getEntityFactory(principal.getType().getName())).isCreateAllowed()) {
            this.ldapEntityManager.addEntity(entityFactory.createEntity(principal));
        }
        this.delegateJpsm.addPrincipal(principal, associations);
    }

    @Override
    public boolean isMapped() {
        return false;
    }

    @Override
    public void removePrincipal(JetspeedPrincipal principal) throws SecurityException {
        EntityFactory entityFactory;
        if (!SynchronizationStateAccess.isSynchronizing() && !this.ldapEntityManager.isReadOnly() && (entityFactory = this.ldapEntityManager.getEntityFactory(principal.getType().getName())).isRemoveAllowed()) {
            this.ldapEntityManager.removeEntity(entityFactory.createEntity(principal));
        }
        this.delegateJpsm.removePrincipal(principal);
    }

    @Override
    public void updatePrincipal(JetspeedPrincipal principal) throws SecurityException {
        EntityFactory entityFactory;
        if (!SynchronizationStateAccess.isSynchronizing() && !this.ldapEntityManager.isReadOnly() && (entityFactory = this.ldapEntityManager.getEntityFactory(principal.getType().getName())).isUpdateAllowed()) {
            this.ldapEntityManager.updateEntity(entityFactory.createEntity(principal));
        }
        this.delegateJpsm.updatePrincipal(principal);
    }
}

