/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.EntitySearchResultHandler;
import org.apache.jetspeed.security.mapping.SearchResultCallbackHandler;
import org.apache.jetspeed.security.mapping.impl.CollectingEntitySearchResultHandler;
import org.apache.jetspeed.security.mapping.impl.CollectingSearchResultHandler;
import org.apache.jetspeed.security.mapping.ldap.EntityFactoryImpl;
import org.apache.jetspeed.security.mapping.ldap.dao.EntityDAO;
import org.apache.jetspeed.security.mapping.ldap.dao.LDAPEntityDAOConfiguration;
import org.apache.jetspeed.security.mapping.ldap.dao.impl.PagedSearchExecutor;
import org.apache.jetspeed.security.mapping.model.Attribute;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.springframework.ldap.AttributeInUseException;
import org.springframework.ldap.NameAlreadyBoundException;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.SchemaViolationException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.SearchExecutor;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringLDAPEntityDAO
implements EntityDAO {
    private final LDAPEntityDAOConfiguration configuration;
    private final EntityFactory entityFactory;
    private LdapTemplate ldapTemplate;
    private String defaultSearchFilterStr;
    private int searchPageSize;

    public SpringLDAPEntityDAO(LDAPEntityDAOConfiguration configuration) {
        this.configuration = configuration;
        this.entityFactory = new EntityFactoryImpl(configuration);
        this.defaultSearchFilterStr = this.createSearchFilter(null);
        this.searchPageSize = configuration.getSearchPageSize();
    }

    public LDAPEntityDAOConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getEntityType() {
        return this.entityFactory.getEntityType();
    }

    @Override
    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    @Override
    public void getAllEntities(EntitySearchResultHandler handler) throws SecurityException {
        this.getEntities(null, handler);
    }

    @Override
    public void getEntities(Filter filter, EntitySearchResultHandler handler) throws SecurityException {
        Validate.notNull((Object)handler, (String)"EntitySearchResultHandler parameter must not be null");
        String sf = this.createSearchFilter(filter);
        SearchControls sc = this.getSearchControls(2, true, this.configuration.getEntityAttributeNames());
        handler.setEntityFactory(this.getEntityFactory());
        PagedSearchExecutor pse = new PagedSearchExecutor((Name)this.configuration.getSearchDN(), sf, sc, (SearchResultCallbackHandler)handler, this.searchPageSize);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.ldapTemplate.search((SearchExecutor)pse, (NameClassPairCallbackHandler)pse);
        }
        catch (NamingException e) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"getEntities", (Object)e.getMessage()), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            handler.setEntityFactory(null);
        }
    }

    @Override
    public void getEntities(Entity parent, Filter filter, EntitySearchResultHandler handler) throws SecurityException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        DistinguishedName parentDN = this.getRelativeDN(parent.getInternalId());
        if (this.configuration.getSearchDN().size() == 0 || parentDN.startsWith((Name)this.configuration.getSearchDN())) {
            String sf = this.createSearchFilter(filter);
            SearchControls sc = this.getSearchControls(1, true, this.configuration.getEntityAttributeNames());
            handler.setEntityFactory(this.getEntityFactory());
            PagedSearchExecutor pse = new PagedSearchExecutor((Name)parentDN, sf, sc, (SearchResultCallbackHandler)handler, this.searchPageSize);
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.ldapTemplate.search((SearchExecutor)pse, (NameClassPairCallbackHandler)pse);
            }
            catch (NamingException e) {
                throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"getEntities", (Object)e.getMessage()), (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                handler.setEntityFactory(null);
            }
        }
    }

    @Override
    public Entity getEntity(String entityId) throws SecurityException {
        CollectingEntitySearchResultHandler handler = new CollectingEntitySearchResultHandler(1);
        this.getEntities((Filter)new EqualsFilter(this.configuration.getLdapIdAttribute(), entityId), handler);
        return handler.getCount() == 1 ? (Entity)handler.getSingleResult() : null;
    }

    @Override
    public void getEntitiesById(Collection<String> entityIds, EntitySearchResultHandler handler) throws SecurityException {
        OrFilter filter = new OrFilter();
        String idAttr = this.configuration.getLdapIdAttribute();
        for (String id : entityIds) {
            filter.or((Filter)new EqualsFilter(idAttr, id));
        }
        this.getEntities((Filter)filter, handler);
    }

    @Override
    public Entity getEntityByInternalId(String internalId) throws SecurityException {
        CollectingEntitySearchResultHandler handler = new CollectingEntitySearchResultHandler(1);
        this.getEntityByInternalId(internalId, handler);
        return (Entity)handler.getSingleResult();
    }

    protected void getEntityByInternalId(String internalId, EntitySearchResultHandler handler) throws SecurityException {
        DistinguishedName principalDN = this.getRelativeDN(internalId);
        if (this.configuration.getSearchDN().size() == 0 || principalDN.startsWith((Name)this.configuration.getSearchDN())) {
            SearchControls sc = this.getSearchControls(0, true, this.configuration.getEntityAttributeNames());
            PagedSearchExecutor pse = new PagedSearchExecutor((Name)principalDN, this.defaultSearchFilterStr, sc, (SearchResultCallbackHandler)handler);
            handler.setEntityFactory(this.getEntityFactory());
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.ldapTemplate.search((SearchExecutor)pse, (NameClassPairCallbackHandler)pse);
            }
            catch (NamingException e) {
                throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"getEntityByInternalId", (Object)e.getMessage()), (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                handler.setEntityFactory(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getEntitiesByInternalId(Collection<String> internalIds, EntitySearchResultHandler handler) throws SecurityException {
        try {
            handler.setEntityFactory(this.getEntityFactory());
            DelegatingEntitySearchResultHandler delegatingHandler = new DelegatingEntitySearchResultHandler(handler);
            Iterator<String> iterator = internalIds.iterator();
            while (iterator.hasNext()) {
                this.getEntityByInternalId(iterator.next(), delegatingHandler);
            }
        }
        finally {
            handler.setEntityFactory(null);
        }
    }

    @Override
    public Entity getParentEntity(Entity childEntity) throws SecurityException {
        DistinguishedName parentDN = new DistinguishedName(childEntity.getInternalId());
        parentDN.removeLast();
        return this.getEntityByInternalId(parentDN.toCompactString());
    }

    protected String getInternalId(Entity entity, boolean required) throws SecurityException {
        if (entity.getInternalId() != null) {
            return entity.getInternalId();
        }
        return this.getInternalId(entity.getId(), required);
    }

    @Override
    public String getInternalId(String entityId, boolean required) throws SecurityException {
        String sf = this.createSearchFilter((Filter)new EqualsFilter(this.configuration.getLdapIdAttribute(), entityId));
        SearchControls sc = this.getSearchControls(2, false, new String[0]);
        CollectingSearchResultHandler<String, SearchResult> cbh = new CollectingSearchResultHandler<String, SearchResult>(1){

            @Override
            protected String mapResult(SearchResult result, int pageSize, int pageIndex, int index) {
                return result.getNameInNamespace();
            }
        };
        PagedSearchExecutor pse = new PagedSearchExecutor((Name)this.configuration.getSearchDN(), sf, sc, (SearchResultCallbackHandler)cbh);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.ldapTemplate.search((SearchExecutor)pse, (NameClassPairCallbackHandler)pse);
            if (cbh.getCount() != 1) {
                if (required) {
                    throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(this.configuration.getEntityType(), (Object)entityId));
                }
                String string = null;
                return string;
            }
            String string = (String)cbh.getSingleResult();
            return string;
        }
        catch (NamingException e) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"getInternalId", (Object)e.getMessage()), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected DirContextOperations getEntityContext(Entity entity, boolean withAttributes) throws SecurityException {
        if (entity.getInternalId() != null) {
            return this.getEntityContextByInternalId(entity.getInternalId(), withAttributes);
        }
        return this.getEntityContextById(entity.getId(), withAttributes);
    }

    protected DirContextOperations getEntityContextById(String entityId, boolean withAttributes) throws SecurityException {
        String sf = this.createSearchFilter((Filter)new EqualsFilter(this.configuration.getLdapIdAttribute(), entityId));
        SearchControls sc = this.getSearchControls(2, true, withAttributes ? this.configuration.getEntityAttributeNames() : new String[]{});
        CollectingSearchResultHandler<DirContextOperations, SearchResult> cbh = new CollectingSearchResultHandler<DirContextOperations, SearchResult>(1){

            @Override
            protected DirContextOperations mapResult(SearchResult result, int pageSize, int pageIndex, int index) {
                return (DirContextOperations)result.getObject();
            }
        };
        PagedSearchExecutor pse = new PagedSearchExecutor((Name)this.configuration.getSearchDN(), sf, sc, (SearchResultCallbackHandler)cbh);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.ldapTemplate.search((SearchExecutor)pse, (NameClassPairCallbackHandler)pse);
            if (cbh.getCount() == 1) {
                DirContextOperations dirContextOperations = (DirContextOperations)cbh.getSingleResult();
                return dirContextOperations;
            }
            DirContextOperations dirContextOperations = null;
            return dirContextOperations;
        }
        catch (NamingException e) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"getEntityContext", (Object)e.getMessage()), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected DirContextOperations getEntityContextByInternalId(String internalId, boolean withAttributes) throws SecurityException {
        DistinguishedName principalDN = this.getRelativeDN(internalId);
        if (this.configuration.getSearchDN().size() == 0 || principalDN.startsWith((Name)this.configuration.getSearchDN())) {
            String sf = this.createSearchFilter(null);
            SearchControls sc = this.getSearchControls(0, true, withAttributes ? this.configuration.getEntityAttributeNames() : new String[]{});
            CollectingSearchResultHandler<DirContextOperations, SearchResult> cbh = new CollectingSearchResultHandler<DirContextOperations, SearchResult>(1){

                @Override
                protected DirContextOperations mapResult(SearchResult result, int pageSize, int pageIndex, int index) {
                    return (DirContextOperations)result.getObject();
                }
            };
            PagedSearchExecutor pse = new PagedSearchExecutor((Name)principalDN, sf, sc, (SearchResultCallbackHandler)cbh);
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.ldapTemplate.search((SearchExecutor)pse, (NameClassPairCallbackHandler)pse);
                DirContextOperations dirContextOperations = (DirContextOperations)cbh.getSingleResult();
                return dirContextOperations;
            }
            catch (NamingException e) {
                throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"getEntityContext", (Object)e.getMessage()), (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return null;
    }

    @Override
    public void add(Entity entity, Entity parentEntity) throws SecurityException {
        if (parentEntity == null || parentEntity.getInternalId() == null) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"add(Entity entity, Entity parentEntity)", (Object)"Provided parent entity is null or has no internal ID."));
        }
        DistinguishedName parentDn = new DistinguishedName(parentEntity.getInternalId());
        parentDn.removeFirst((Name)new DistinguishedName((Name)this.configuration.getBaseDN()));
        this.internalAdd(entity, parentDn);
    }

    @Override
    public void add(Entity entity) throws SecurityException {
        this.internalAdd(entity, new DistinguishedName((Name)this.configuration.getSearchDN()));
    }

    protected void internalAdd(Entity entity, DistinguishedName dn) throws SecurityException {
        if (dn != null) {
            dn.add(this.configuration.getLdapIdAttribute(), entity.getId());
            String internalId = this.getFullDN(dn).toCompactString();
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute basicAttr = new BasicAttribute("objectClass");
            for (String objClass : this.configuration.getObjectClassesArray()) {
                basicAttr.add(objClass);
            }
            attributes.put(basicAttr);
            for (AttributeDef attrDef : this.configuration.getAttributeDefinitionsMap().values()) {
                basicAttr = null;
                if (attrDef.isIdAttribute()) {
                    basicAttr = new BasicAttribute(attrDef.getName());
                    basicAttr.add(entity.getId());
                } else if (attrDef.isRelationOnly() || !attrDef.isMapped()) {
                    if (attrDef.isMultiValue() && attrDef.isRequired()) {
                        basicAttr = new BasicAttribute(attrDef.getName());
                        basicAttr.add(attrDef.requiresDnDefaultValue() ? internalId : attrDef.getRequiredDefaultValue());
                    }
                } else if (attrDef.isMapped()) {
                    Attribute entityAttr;
                    if (attrDef.isMultiValue() && attrDef.isRequired()) {
                        basicAttr = new BasicAttribute(attrDef.getName());
                        basicAttr.add(attrDef.requiresDnDefaultValue() ? internalId : attrDef.getRequiredDefaultValue());
                    }
                    if ((entityAttr = entity.getAttribute(attrDef.getName())) != null) {
                        if (attrDef.isMultiValue()) {
                            Collection<String> entityAttrValues = entityAttr.getValues();
                            if (entityAttrValues != null && entityAttrValues.size() > 0) {
                                if (basicAttr == null) {
                                    basicAttr = new BasicAttribute(attrDef.getName());
                                }
                                for (String val : entityAttrValues) {
                                    basicAttr.add(val);
                                }
                            }
                        } else if (entityAttr.getValue() != null) {
                            basicAttr = new BasicAttribute(attrDef.getName());
                            basicAttr.add(entityAttr.getValue());
                        }
                    }
                }
                if (basicAttr == null) continue;
                attributes.put(basicAttr);
            }
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.ldapTemplate.bind((Name)dn, null, (Attributes)attributes);
            }
            catch (NameAlreadyBoundException e) {
                throw new SecurityException(SecurityException.PRINCIPAL_ALREADY_EXISTS.createScoped(entity.getType(), (Object)entity.getId()));
            }
            catch (NamingException e) {
                throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"add", (Object)e.getMessage()), (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    @Override
    public void update(Entity entity) throws SecurityException {
        String internalId = this.getInternalId(entity, true);
        ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>();
        for (AttributeDef attrDef : this.configuration.getEntityAttributeDefinitionsMap().values()) {
            if (!attrDef.isMapped() || attrDef.isIdAttribute() || attrDef.isEntityIdAttribute()) continue;
            Attribute entityAttr = entity.getAttribute(attrDef.getName());
            BasicAttribute namingAttr = new BasicAttribute(attrDef.getName());
            boolean attrAdded = false;
            if (entityAttr != null) {
                if (attrDef.isMultiValue()) {
                    Collection<String> values;
                    if (attrDef.isRequired()) {
                        namingAttr.add(attrDef.requiresDnDefaultValue() ? internalId : attrDef.getRequiredDefaultValue());
                        attrAdded = true;
                    }
                    if ((values = entityAttr.getValues()) != null && values.size() > 0) {
                        for (String val : values) {
                            namingAttr.add(val);
                        }
                        attrAdded = true;
                    }
                } else {
                    String value = entityAttr.getValue();
                    if (value != null) {
                        namingAttr.add(value);
                        attrAdded = true;
                    }
                }
            }
            if (!attrAdded && attrDef.isMultiValue() && attrDef.isRequired()) {
                namingAttr.add(attrDef.requiresDnDefaultValue() ? internalId : attrDef.getRequiredDefaultValue());
            }
            modItems.add(new ModificationItem(2, namingAttr));
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.ldapTemplate.modifyAttributes((Name)this.getRelativeDN(internalId), modItems.toArray(new ModificationItem[0]));
        }
        catch (NamingException e) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"update", (Object)e.getMessage()), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public void remove(Entity entity) throws SecurityException {
        String internalId = this.getInternalId(entity, false);
        if (internalId == null) {
            return;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.ldapTemplate.unbind((Name)this.getRelativeDN(internalId));
        }
        catch (NameNotFoundException e) {
        }
        catch (NamingException e) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"remove", (Object)e.getMessage()), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public void addRelation(String entityId, String relatedEntityInternalId, String attributeName) throws SecurityException {
        AttributeDef attrDef = this.configuration.getAttributeDef(attributeName);
        if (attrDef == null) {
            throw new SecurityException(SecurityException.ENTITY_ATTRIBUTE_UNDEFINED.createScoped(this.configuration.getEntityType(), (Object)attributeName));
        }
        DirContextOperations dirCtxOps = this.getEntityContextById(entityId, false);
        if (dirCtxOps == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(this.configuration.getEntityType(), (Object)entityId));
        }
        ModificationItem[] modItems = new ModificationItem[]{new ModificationItem(attrDef.isMultiValue() ? 1 : 2, new BasicAttribute(attributeName))};
        modItems[0].getAttribute().add(relatedEntityInternalId);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.ldapTemplate.modifyAttributes((Name)this.getRelativeDN(dirCtxOps.getNameInNamespace()), modItems);
        }
        catch (AttributeInUseException e) {
        }
        catch (NamingException e) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"addRelation", (Object)e.getMessage()), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public void removeRelation(String entityId, String relatedEntityInternalId, String attributeName) throws SecurityException {
        AttributeDef attrDef = this.configuration.getAttributeDef(attributeName);
        if (attrDef == null) {
            throw new SecurityException(SecurityException.ENTITY_ATTRIBUTE_UNDEFINED.createScoped(this.configuration.getEntityType(), (Object)attributeName));
        }
        DirContextOperations dirCtxOps = this.getEntityContextById(entityId, false);
        if (dirCtxOps == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(this.configuration.getEntityType(), (Object)entityId));
        }
        ModificationItem[] modItems = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(attributeName))};
        if (attrDef.isMultiValue()) {
            modItems[0].getAttribute().add(relatedEntityInternalId);
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                this.ldapTemplate.modifyAttributes((Name)this.getRelativeDN(dirCtxOps.getNameInNamespace()), modItems);
            }
            catch (SchemaViolationException e) {
                if (!attrDef.isMultiValue() || !attrDef.isRequired()) {
                    throw e;
                }
                modItems[0] = new ModificationItem(2, new BasicAttribute(attributeName));
                modItems[0].getAttribute().add(attrDef.requiresDnDefaultValue() ? dirCtxOps.getNameInNamespace() : attrDef.getRequiredDefaultValue());
                this.ldapTemplate.modifyAttributes((Name)this.getRelativeDN(dirCtxOps.getNameInNamespace()), modItems);
            }
        }
        catch (NamingException e) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"removeRelation", (Object)e.getMessage()), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected SearchControls getSearchControls(int searchScope, boolean returningObjFlag, String[] attrs) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(searchScope);
        controls.setReturningObjFlag(returningObjFlag);
        controls.setReturningAttributes(attrs);
        return controls;
    }

    protected DistinguishedName getRelativeDN(String fullDN) {
        DistinguishedName principalDN = new DistinguishedName(fullDN);
        if (this.configuration.getBaseDN().size() > 0) {
            principalDN.removeFirst((Name)this.configuration.getBaseDN());
        }
        return principalDN;
    }

    protected DistinguishedName getFullDN(DistinguishedName relativeDN) {
        DistinguishedName fullDN = new DistinguishedName((Name)relativeDN);
        if (this.configuration.getBaseDN().size() > 0 && !fullDN.startsWith((Name)this.configuration.getBaseDN())) {
            fullDN.prepend(this.configuration.getBaseDN());
        }
        return fullDN;
    }

    protected String createSearchFilter(Filter filter) {
        String filterStr;
        if (this.configuration.getSearchFilter() != null) {
            filter = filter == null ? this.configuration.getSearchFilter() : new AndFilter().and(this.configuration.getSearchFilter()).and(filter);
        }
        String string = filterStr = filter != null ? filter.encode() : "";
        if (StringUtils.isEmpty((String)filterStr)) {
            filterStr = "(objectClass=*)";
        }
        return filterStr;
    }

    private static final class DelegatingEntitySearchResultHandler
    implements EntitySearchResultHandler {
        private int delegatedIndex;
        private EntitySearchResultHandler handler;

        public DelegatingEntitySearchResultHandler(EntitySearchResultHandler handler) {
            this.handler = handler;
        }

        public int getMaxCount() {
            return this.handler.getMaxCount();
        }

        public int getSearchPageSize() {
            return this.handler.getSearchPageSize();
        }

        public void setFeedback(Object feedback) {
        }

        public Object getFeedback() {
            return null;
        }

        public void setEntityFactory(EntityFactory factory) {
        }

        public boolean handleSearchResult(Object result, int pageSize, int pageIndex, int index) {
            ++this.delegatedIndex;
            return this.handler.handleSearchResult(result, 0, this.delegatedIndex, this.delegatedIndex);
        }
    }
}

