/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.security.JetspeedPermission;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.PersistentJetspeedPrincipal;
import org.apache.jetspeed.security.spi.JetspeedPermissionAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPermissionStorageManager;
import org.apache.jetspeed.security.spi.PersistentJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.BaseJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.JetspeedPermissionFactory;
import org.apache.jetspeed.util.ServletRequestThreadLocalCleanupCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionManagerImpl
implements PermissionManager {
    private HashMap<String, JetspeedPermissionFactory> factoryMap = new HashMap();
    private JetspeedPermissionAccessManager jpam;
    private JetspeedPermissionStorageManager jpsm;
    private static ThreadLocal<HashMap<Long, Permissions>> permissionsCache = new ThreadLocal();

    public PermissionManagerImpl(List<JetspeedPermissionFactory> factories, JetspeedPermissionAccessManager jpam, JetspeedPermissionStorageManager jpsm) {
        for (JetspeedPermissionFactory pf : factories) {
            this.factoryMap.put(pf.getType(), pf);
        }
        this.jpam = jpam;
        this.jpsm = jpsm;
    }

    private HashMap<Long, Permissions> getPermissionsMap() {
        HashMap<Long, Permissions> map = permissionsCache.get();
        if (map == null) {
            map = new HashMap();
            permissionsCache.set(map);
            new ServletRequestThreadLocalCleanupCallback(permissionsCache);
        }
        return map;
    }

    protected PersistentJetspeedPermission getPersistentJetspeedPermission(JetspeedPermission permission) {
        if (permission instanceof PersistentJetspeedPermission) {
            return (PersistentJetspeedPermission)permission;
        }
        return ((BaseJetspeedPermission)permission).getPermission();
    }

    public JetspeedPermission newPermission(String type, String name, String actions) {
        return this.factoryMap.get(type).newPermission(name, actions);
    }

    public JetspeedPermission newPermission(String type, String name, int mask) {
        return this.factoryMap.get(type).newPermission(name, mask);
    }

    public int parseActions(String actions) {
        return JetspeedActions.getContainerActionsMask((String)actions);
    }

    public Permissions getPermissions(JetspeedPrincipal principal) {
        Permissions permissions = null;
        if (principal instanceof PersistentJetspeedPrincipal && ((PersistentJetspeedPrincipal)principal).getId() != null) {
            Long id;
            HashMap<Long, Permissions> permissionsMap = this.getPermissionsMap();
            permissions = permissionsMap.get(id = ((PersistentJetspeedPrincipal)principal).getId());
            if (permissions == null) {
                permissions = new Permissions();
                List<? extends JetspeedPermission> permList = this.jpam.getPermissions((PersistentJetspeedPrincipal)principal);
                for (PersistentJetspeedPermission persistentJetspeedPermission : permList) {
                    permissions.add(this.factoryMap.get(persistentJetspeedPermission.getType()).newPermission(persistentJetspeedPermission));
                }
                permissionsMap.put(id, permissions);
            }
        } else {
            permissions = new Permissions();
        }
        return permissions;
    }

    public Permissions getPermissions(Principal[] principals) {
        Permissions allPermissions = new Permissions();
        HashMap<Long, Permissions> permissionsMap = null;
        for (Principal principal : principals) {
            Long id;
            Permissions permissions;
            if (!(principal instanceof PersistentJetspeedPrincipal) || ((PersistentJetspeedPrincipal)((Object)principal)).getId() == null) continue;
            if (permissionsMap == null) {
                permissionsMap = this.getPermissionsMap();
            }
            if ((permissions = permissionsMap.get(id = ((PersistentJetspeedPrincipal)((Object)principal)).getId())) == null) {
                permissions = new Permissions();
                List<? extends JetspeedPermission> permList = this.jpam.getPermissions((PersistentJetspeedPrincipal)((Object)principal));
                for (PersistentJetspeedPermission persistentJetspeedPermission : permList) {
                    permissions.add(this.factoryMap.get(persistentJetspeedPermission.getType()).newPermission(persistentJetspeedPermission));
                }
                permissionsMap.put(id, permissions);
            }
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                allPermissions.add(e.nextElement());
            }
        }
        return allPermissions;
    }

    public List<JetspeedPermission> getPermissions() {
        return this.jpam.getPermissions();
    }

    public List<JetspeedPermission> getPermissions(String typeName) {
        return this.jpam.getPermissions(typeName);
    }

    public List<JetspeedPermission> getPermissions(String typeName, String nameFilter) {
        return this.jpam.getPermissions(typeName, nameFilter);
    }

    public List<JetspeedPrincipal> getPrincipals(JetspeedPermission permission) {
        return this.jpam.getPrincipals(this.getPersistentJetspeedPermission(permission), null);
    }

    public List<JetspeedPrincipal> getPrincipals(JetspeedPermission permission, String principalType) {
        return this.jpam.getPrincipals(this.getPersistentJetspeedPermission(permission), principalType);
    }

    public boolean permissionExists(JetspeedPermission permission) {
        return this.jpam.permissionExists(permission);
    }

    public void addPermission(JetspeedPermission permission) throws SecurityException {
        this.jpsm.addPermission(this.getPersistentJetspeedPermission(permission));
    }

    public void updatePermission(JetspeedPermission permission) throws SecurityException {
        this.jpsm.updatePermission(this.getPersistentJetspeedPermission(permission));
        permissionsCache.remove();
    }

    public void removePermission(JetspeedPermission permission) throws SecurityException {
        this.jpsm.removePermission(this.getPersistentJetspeedPermission(permission));
        permissionsCache.remove();
    }

    public void grantPermission(JetspeedPermission permission, JetspeedPrincipal principal) throws SecurityException {
        this.jpsm.grantPermission(this.getPersistentJetspeedPermission(permission), principal);
        permissionsCache.remove();
    }

    public void grantPermissionOnlyTo(JetspeedPermission permission, List<JetspeedPrincipal> principals) throws SecurityException {
        this.jpsm.grantPermissionOnlyTo(this.getPersistentJetspeedPermission(permission), null, principals);
        permissionsCache.remove();
    }

    public void grantPermissionOnlyTo(JetspeedPermission permission, String principalType, List<JetspeedPrincipal> principals) throws SecurityException {
        this.jpsm.grantPermissionOnlyTo(this.getPersistentJetspeedPermission(permission), principalType, principals);
        permissionsCache.remove();
    }

    public void revokePermission(JetspeedPermission permission, JetspeedPrincipal principal) throws SecurityException {
        this.jpsm.revokePermission(this.getPersistentJetspeedPermission(permission), principal);
        permissionsCache.remove();
    }

    public void revokeAllPermissions(JetspeedPrincipal principal) throws SecurityException {
        this.jpsm.revokeAllPermissions(principal);
        permissionsCache.remove();
    }
}

