/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.security.Principal;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapBindingConfig;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDaoImpl;

public class LdapGroupDaoImpl
extends LdapPrincipalDaoImpl {
    public LdapGroupDaoImpl() throws SecurityException {
    }

    public LdapGroupDaoImpl(LdapBindingConfig ldapConfig) throws SecurityException {
        super(ldapConfig);
    }

    protected Attributes defineLdapAttributes(String principalUid) {
        int i;
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute classes = new BasicAttribute("objectclass");
        for (i = 0; i < this.getObjectClasses().length; ++i) {
            classes.add(this.getObjectClasses()[i]);
        }
        attrs.put(classes);
        attrs.put(this.getEntryPrefix(), principalUid);
        if (!StringUtils.isEmpty((String)this.getGroupObjectRequiredAttributeClasses())) {
            String[] required = this.getGroupObjectRequiredAttributeClasses().split(",");
            for (int i2 = 0; i2 < required.length; ++i2) {
                attrs.put(required[i2], "");
            }
        }
        for (i = 0; i < this.getAttributes().length; ++i) {
            attrs.put(this.parseAttr(this.getAttributes()[i], principalUid)[0], this.parseAttr(this.getAttributes()[i], principalUid)[1]);
        }
        return attrs;
    }

    protected String getDnSuffix() {
        return this.getGroupFilterBase();
    }

    protected Principal makePrincipal(String principalUid) {
        return new GroupPrincipalImpl(principalUid);
    }

    protected String getEntryPrefix() {
        return this.getGroupIdAttribute();
    }

    protected String getSearchSuffix() {
        return this.getGroupFilter();
    }

    protected String getSearchDomain() {
        return this.getGroupFilterBase();
    }

    protected String[] getObjectClasses() {
        return this.getGroupObjectClasses();
    }

    protected String getUidAttributeForPrincipal() {
        return this.getGroupUidAttribute();
    }

    protected String[] getAttributes() {
        return this.getGroupAttributes();
    }
}

