/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.spi.impl.ldap.LdapBindingConfig;

public class LdapContextProxy
implements InvocationHandler {
    private Properties env = new Properties();
    private LdapContext ctx;

    public static LdapContext createProxy(LdapBindingConfig config) {
        LdapContext proxy = config.getContext();
        if (proxy == null || !(Proxy.getInvocationHandler(proxy) instanceof LdapContextProxy)) {
            proxy = (LdapContext)Proxy.newProxyInstance(LdapContext.class.getClassLoader(), new Class[]{LdapContext.class}, (InvocationHandler)new LdapContextProxy(config));
            config.setContext(proxy);
        }
        return proxy;
    }

    private LdapContextProxy(LdapBindingConfig ldapBindingConfig) {
        this.env.put("java.naming.factory.initial", ldapBindingConfig.getInitialContextFactory());
        this.env.put("java.naming.provider.url", ldapBindingConfig.getLdapScheme() + "://" + ldapBindingConfig.getLdapServerName() + ":" + ldapBindingConfig.getLdapServerPort() + "/" + ldapBindingConfig.getRootContext());
        this.env.put("java.naming.security.principal", ldapBindingConfig.getRootDn());
        this.env.put("java.naming.security.credentials", ldapBindingConfig.getRootPassword());
        this.env.put("java.naming.security.authentication", ldapBindingConfig.getLdapSecurityLevel());
        if (!StringUtils.isEmpty((String)ldapBindingConfig.getLdapSecurityProtocol())) {
            this.env.put("java.naming.security.protocol", ldapBindingConfig.getLdapSecurityProtocol());
        }
        if (!StringUtils.isEmpty((String)ldapBindingConfig.getLdapSocketFactory())) {
            this.env.put("java.naming.ldap.factory.socket", ldapBindingConfig.getLdapSocketFactory());
        }
    }

    private LdapContext getCtx() throws NamingException {
        if (this.ctx == null) {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        return this.ctx;
    }

    private void closeCtx() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ctx = null;
        }
    }

    public synchronized Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        boolean close;
        Object result = null;
        boolean bl = close = "close".equals(m.getName()) && args.length == 0;
        if (!close || this.ctx != null) {
            LdapContext ctx = this.getCtx();
            try {
                result = m.invoke((Object)ctx, args);
                if (close) {
                    this.closeCtx();
                }
            }
            catch (Throwable t) {
                this.closeCtx();
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof ServiceUnavailableException || t instanceof CommunicationException) {
                    try {
                        ctx = this.getCtx();
                        result = m.invoke((Object)ctx, args);
                    }
                    catch (Throwable t2) {
                        this.closeCtx();
                        if (t2 instanceof InvocationTargetException) {
                            t2 = ((InvocationTargetException)t2).getTargetException();
                        }
                        throw t2;
                    }
                }
                throw t;
            }
        }
        return result;
    }
}

