/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import javax.naming.ldap.LdapContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapBindingConfig {
    private static final Log logger = LogFactory.getLog((Class)LdapBindingConfig.class);
    private LdapContext context;
    private String initialContextFactory;
    private String ldapSocketFactory;
    private String ldapScheme = "ldap";
    private String ldapServerName;
    private String ldapServerPort;
    private String ldapSecurityLevel = "simple";
    private String ldapSecurityProtocol;
    private String rootDn;
    private String rootPassword;
    private String rootContext;
    private PropertiesConfiguration props = null;
    private String groupFilter;
    private String userFilter;
    private String userRoleMembershipAttributes;
    private String groupMembershipAttributes;
    private String userGroupMembershipAttributes;
    private String defaultSearchBase;
    private String groupFilterBase;
    private String userFilterBase;
    private String groupIdAttribute;
    private String userIdAttribute;
    private String uidAttribute;
    private String memberShipSearchScope;
    private String[] groupObjectClasses;
    private String[] userObjectClasses;
    private String groupMembershipForRoleAttributes;
    private String groupUidAttribute;
    private String userUidAttribute;
    private String[] groupAttributes;
    private String[] userAttributes;
    private String groupObjectRequiredAttributeClasses;
    private String[] roleObjectClasses;
    private String roleGroupMembershipForRoleAttributes;
    private String[] roleAttributes;
    private String roleObjectRequiredAttributeClasses;
    private String roleFilter;
    private String roleFilterBase;
    private String roleIdAttribute;
    private String roleUidAttribute;
    private String roleMembershipAttributes;
    private String userPasswordAttribute;
    private String[] knownAttributes;

    public LdapBindingConfig() {
    }

    public LdapBindingConfig(String factory, String name, String port, String context, String dn, String password, String roleFilter, String groupFilter, String userFilter, String roleMembershipAttributes, String userRoleMembershipAttributes, String groupMembershipAttributes, String userGroupMembershipAttributes, String groupMembershipForRoleAttributes, String roleGroupMembershipForRoleAttributes, String defaultSearchBase, String roleFilterBase, String groupFilterBase, String userFilterBase, String roleObjectClasses, String groupObjectClasses, String userObjectClasses, String roleIdAttribute, String groupIdAttribute, String userIdAttribute, String uidAttribute, String memberShipSearchScope, String roleUidAttribute, String groupUidAttribute, String userUidAttribute, String roleObjectRequiredAttributeClasses, String groupObjectRequiredAttributeClasses, String userAttributes, String roleAttributes, String groupAttributes, String userPasswordAttribute, String knownAttributes) {
        this.initialContextFactory = factory;
        this.ldapServerName = name;
        this.ldapServerPort = port;
        this.rootContext = context;
        this.rootDn = dn;
        this.rootPassword = password;
        this.roleFilter = roleFilter;
        this.groupFilter = groupFilter;
        this.userFilter = userFilter;
        this.roleMembershipAttributes = roleMembershipAttributes;
        this.userRoleMembershipAttributes = userRoleMembershipAttributes;
        this.groupMembershipAttributes = groupMembershipAttributes;
        this.userGroupMembershipAttributes = userGroupMembershipAttributes;
        this.groupMembershipForRoleAttributes = groupMembershipForRoleAttributes;
        this.roleGroupMembershipForRoleAttributes = roleGroupMembershipForRoleAttributes;
        this.defaultSearchBase = defaultSearchBase;
        this.roleFilterBase = roleFilterBase;
        this.groupFilterBase = groupFilterBase;
        this.userFilterBase = userFilterBase;
        this.roleObjectClasses = StringUtils.split((String)roleObjectClasses, (String)",");
        this.groupObjectClasses = StringUtils.split((String)groupObjectClasses, (String)",");
        this.userObjectClasses = StringUtils.split((String)userObjectClasses, (String)",");
        this.roleIdAttribute = roleIdAttribute;
        this.groupIdAttribute = groupIdAttribute;
        this.userIdAttribute = userIdAttribute;
        this.uidAttribute = uidAttribute;
        this.memberShipSearchScope = memberShipSearchScope;
        this.roleUidAttribute = roleUidAttribute;
        this.groupUidAttribute = groupUidAttribute;
        this.userUidAttribute = userUidAttribute;
        this.roleObjectRequiredAttributeClasses = roleObjectRequiredAttributeClasses;
        this.groupObjectRequiredAttributeClasses = groupObjectRequiredAttributeClasses;
        this.roleAttributes = StringUtils.split((String)roleAttributes, (String)",");
        this.groupAttributes = StringUtils.split((String)groupAttributes, (String)",");
        this.userAttributes = StringUtils.split((String)userAttributes, (String)",");
        this.userPasswordAttribute = userPasswordAttribute;
        this.knownAttributes = StringUtils.split((String)knownAttributes, (String)",");
    }

    public LdapBindingConfig(String ldapType) {
        try {
            this.props = new PropertiesConfiguration("JETSPEED-INF/directory/config/" + ldapType + "/ldap.properties");
            this.initialContextFactory = this.props.getString("org.apache.jetspeed.ldap.initialContextFactory");
            this.ldapServerName = this.props.getString("org.apache.jetspeed.ldap.ldapServerName");
            this.ldapServerPort = this.props.getString("org.apache.jetspeed.ldap.ldapServerPort");
            this.rootContext = this.props.getString("org.apache.jetspeed.ldap.rootContext");
            this.rootDn = this.props.getString("org.apache.jetspeed.ldap.rootDn");
            this.rootPassword = this.props.getString("org.apache.jetspeed.ldap.rootPassword");
            this.roleFilter = this.props.getString("org.apache.jetspeed.ldap.RoleFilter");
            this.groupFilter = this.props.getString("org.apache.jetspeed.ldap.GroupFilter");
            this.userFilter = this.props.getString("org.apache.jetspeed.ldap.UserFilter");
            this.roleMembershipAttributes = this.props.getString("org.apache.jetspeed.ldap.RoleMembershipAttributes");
            this.userRoleMembershipAttributes = this.props.getString("org.apache.jetspeed.ldap.UserRoleMembershipAttributes");
            this.groupMembershipAttributes = this.props.getString("org.apache.jetspeed.ldap.GroupMembershipAttributes");
            this.userGroupMembershipAttributes = this.props.getString("org.apache.jetspeed.ldap.UserGroupMembershipAttributes");
            this.groupMembershipForRoleAttributes = this.props.getString("org.apache.jetspeed.ldap.GroupMembershipForRoleAttributes");
            this.roleGroupMembershipForRoleAttributes = this.props.getString("org.apache.jetspeed.ldap.RoleGroupMembershipForRoleAttributes");
            this.defaultSearchBase = this.props.getString("org.apache.jetspeed.ldap.DefaultSearchBase");
            this.roleFilterBase = this.props.getString("org.apache.jetspeed.ldap.RoleFilterBase");
            this.groupFilterBase = this.props.getString("org.apache.jetspeed.ldap.GroupFilterBase");
            this.userFilterBase = this.props.getString("org.apache.jetspeed.ldap.UserFilterBase");
            this.roleObjectClasses = StringUtils.split((String)this.props.getString("org.apache.jetspeed.ldap.RoleObjectClasses"), (String)",");
            this.groupObjectClasses = StringUtils.split((String)this.props.getString("org.apache.jetspeed.ldap.GroupObjectClasses"), (String)",");
            this.userObjectClasses = StringUtils.split((String)this.props.getString("org.apache.jetspeed.ldap.UserObjectClasses"), (String)",");
            this.roleIdAttribute = this.props.getString("org.apache.jetspeed.ldap.RoleIdAttribute");
            this.groupIdAttribute = this.props.getString("org.apache.jetspeed.ldap.GroupIdAttribute");
            this.userIdAttribute = this.props.getString("org.apache.jetspeed.ldap.UserIdAttribute");
            this.uidAttribute = this.props.getString("org.apache.jetspeed.ldap.UidAttribute");
            this.memberShipSearchScope = this.props.getString("org.apache.jetspeed.ldap.MemberShipSearchScope");
            this.roleUidAttribute = this.props.getString("org.apache.jetspeed.ldap.roleUidAttribute");
            this.groupUidAttribute = this.props.getString("org.apache.jetspeed.ldap.groupUidAttribute");
            this.userUidAttribute = this.props.getString("org.apache.jetspeed.ldap.userUidAttribute");
            this.roleObjectRequiredAttributeClasses = this.props.getString("org.apache.jetspeed.ldap.roleObjectRequiredAttributeClasses");
            this.groupObjectRequiredAttributeClasses = this.props.getString("org.apache.jetspeed.ldap.groupObjectRequiredAttributeClasses");
            this.roleAttributes = StringUtils.split((String)this.props.getString("org.apache.jetspeed.ldap.roleAttributes"), (String)",");
            this.groupAttributes = StringUtils.split((String)this.props.getString("org.apache.jetspeed.ldap.groupAttributes"), (String)",");
            this.userAttributes = StringUtils.split((String)this.props.getString("org.apache.jetspeed.ldap.userAttributes"), (String)",");
            this.userPasswordAttribute = this.props.getString("org.apache.jetspeed.ldap.userPasswordAttribute");
            this.knownAttributes = StringUtils.split((String)this.props.getString("org.apache.jetspeed.ldap.knownAttributes"), (String)",");
        }
        catch (ConfigurationException ce) {
            logger.error((Object)("Could not configure LdapBindingConfig: " + (Object)((Object)ce)));
        }
    }

    LdapContext getContext() {
        return this.context;
    }

    void setContext(LdapContext context) {
        this.context = context;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public String getLdapScheme() {
        return this.ldapScheme;
    }

    public void setLdapScheme(String ldapScheme) {
        this.ldapScheme = ldapScheme;
    }

    public String getLdapSocketFactory() {
        return this.ldapSocketFactory;
    }

    public void setLdapSocketFactory(String ldapSocketFactory) {
        this.ldapSocketFactory = ldapSocketFactory;
    }

    public String getLdapServerName() {
        return this.ldapServerName;
    }

    public void setLdapServerName(String ldapServerName) {
        this.ldapServerName = ldapServerName;
    }

    public String getLdapServerPort() {
        return this.ldapServerPort;
    }

    public void setLdapServerPort(String ldapServerPort) {
        this.ldapServerPort = ldapServerPort;
    }

    public String getLdapSecurityLevel() {
        return this.ldapSecurityLevel;
    }

    public void setLdapSecurityLevel(String ldapSecurityLevel) {
        this.ldapSecurityLevel = ldapSecurityLevel;
    }

    public String getLdapSecurityProtocol() {
        return this.ldapSecurityProtocol;
    }

    public void setLdapSecurityProtocol(String ldapSecurityProtocol) {
        this.ldapSecurityProtocol = ldapSecurityProtocol;
    }

    public String getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(String rootContext) {
        this.rootContext = rootContext;
    }

    public String getRootDn() {
        return this.rootDn;
    }

    public void setRootDn(String rootDn) {
        this.rootDn = rootDn;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public String getUserFilterBase() {
        return this.userFilterBase;
    }

    public void setUserFilterBase(String userFilterBase) {
        this.userFilterBase = userFilterBase;
    }

    public String getUserGroupMembershipAttributes() {
        return this.userGroupMembershipAttributes;
    }

    public void setUserGroupMembershipAttributes(String userGroupMembershipAttributes) {
        this.userGroupMembershipAttributes = userGroupMembershipAttributes;
    }

    public String getUserRoleMembershipAttributes() {
        return this.userRoleMembershipAttributes;
    }

    public void setUserRoleMembershipAttributes(String userRoleMembershipAttributes) {
        this.userRoleMembershipAttributes = userRoleMembershipAttributes;
    }

    public String getDefaultSearchBase() {
        return this.defaultSearchBase;
    }

    public void setDefaultSearchBase(String defaultSearchBase) {
        this.defaultSearchBase = defaultSearchBase;
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public void setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
    }

    public String getGroupFilterBase() {
        return this.groupFilterBase;
    }

    public void setGroupFilterBase(String groupFilterBase) {
        this.groupFilterBase = groupFilterBase;
    }

    public String getGroupMembershipAttributes() {
        return this.groupMembershipAttributes;
    }

    public void setGroupMembershipAttributes(String groupMembershipAttributes) {
        this.groupMembershipAttributes = groupMembershipAttributes;
    }

    public String getGroupIdAttribute() {
        return this.groupIdAttribute;
    }

    public void setGroupIdAttribute(String groupIdAttribute) {
        this.groupIdAttribute = groupIdAttribute;
    }

    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public void setUserIdAttribute(String userIdAttribute) {
        this.userIdAttribute = userIdAttribute;
    }

    public String[] getGroupObjectClasses() {
        return this.groupObjectClasses;
    }

    public void setGroupObjectClasses(String[] groupObjectClasses) {
        this.groupObjectClasses = groupObjectClasses;
    }

    public String[] getUserObjectClasses() {
        return this.userObjectClasses;
    }

    public void setUserObjectClasses(String[] userObjectClasses) {
        this.userObjectClasses = userObjectClasses;
    }

    public String getGroupMembershipForRoleAttributes() {
        return this.groupMembershipForRoleAttributes;
    }

    public void setGroupMembershipForRoleAttributes(String groupMembershipForRoleAttributes) {
        this.groupMembershipForRoleAttributes = groupMembershipForRoleAttributes;
    }

    public String getUidAttribute() {
        return this.uidAttribute;
    }

    public void setUidAttribute(String uidAttribute) {
        this.uidAttribute = uidAttribute;
    }

    public String getMemberShipSearchScope() {
        return this.memberShipSearchScope;
    }

    public void setMemberShipSearchScope(String memberShipSearchScope) {
        this.memberShipSearchScope = memberShipSearchScope;
    }

    public String getGroupUidAttribute() {
        return this.groupUidAttribute;
    }

    public void setGroupUidAttribute(String groupUidAttribute) {
        this.groupUidAttribute = groupUidAttribute;
    }

    public String getUserUidAttribute() {
        return this.userUidAttribute;
    }

    public void setUserUidAttribute(String userUidAttribute) {
        this.userUidAttribute = userUidAttribute;
    }

    public String getGroupObjectRequiredAttributeClasses() {
        return this.groupObjectRequiredAttributeClasses;
    }

    public void setGroupObjectRequiredAttributeClasses(String groupObjectRequiredAttributeClasses) {
        this.groupObjectRequiredAttributeClasses = groupObjectRequiredAttributeClasses;
    }

    public String[] getGroupAttributes() {
        return this.groupAttributes;
    }

    public void setGroupAttributes(String[] groupAttributes) {
        this.groupAttributes = groupAttributes;
    }

    public String[] getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(String[] userAttributes) {
        this.userAttributes = userAttributes;
    }

    public String getRoleObjectRequiredAttributeClasses() {
        return this.roleObjectRequiredAttributeClasses;
    }

    public void setRoleObjectRequiredAttributeClasses(String roleObjectRequiredAttributeClasses) {
        this.roleObjectRequiredAttributeClasses = roleObjectRequiredAttributeClasses;
    }

    public String[] getRoleAttributes() {
        return this.roleAttributes;
    }

    public void setRoleAttributes(String[] roleAttributes) {
        this.roleAttributes = roleAttributes;
    }

    public String[] getRoleObjectClasses() {
        return this.roleObjectClasses;
    }

    public void setRoleObjectClasses(String[] roleObjectClasses) {
        this.roleObjectClasses = roleObjectClasses;
    }

    public String getRoleGroupMembershipForRoleAttributes() {
        return this.roleGroupMembershipForRoleAttributes;
    }

    public void setRoleGroupMembershipForRoleAttributes(String roleGroupMembershipForRoleAttributes) {
        this.roleGroupMembershipForRoleAttributes = roleGroupMembershipForRoleAttributes;
    }

    public String getRoleFilter() {
        return this.roleFilter;
    }

    public void setRoleFilter(String roleFilter) {
        this.roleFilter = roleFilter;
    }

    public String getRoleFilterBase() {
        return this.roleFilterBase;
    }

    public void setRoleFilterBase(String roleFilterBase) {
        this.roleFilterBase = roleFilterBase;
    }

    public String getRoleMembershipAttributes() {
        return this.roleMembershipAttributes;
    }

    public void setRoleMembershipAttributes(String roleMembershipAttributes) {
        this.roleMembershipAttributes = roleMembershipAttributes;
    }

    public String getRoleUidAttribute() {
        return this.roleUidAttribute;
    }

    public void setRoleUidAttribute(String roleUidAttribute) {
        this.roleUidAttribute = roleUidAttribute;
    }

    public String getRoleIdAttribute() {
        return this.roleIdAttribute;
    }

    public void setRoleIdAttribute(String roleIdAttribute) {
        this.roleIdAttribute = roleIdAttribute;
    }

    public String getUserPasswordAttribute() {
        return this.userPasswordAttribute;
    }

    public void setUserPasswordAttribute(String userPasswordAttribute) {
        this.userPasswordAttribute = userPasswordAttribute;
    }

    public String[] getKnownAttributes() {
        return this.knownAttributes;
    }

    public void setKnownAttributes(String[] knownAttributes) {
        this.knownAttributes = knownAttributes;
    }
}

