/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.Collection;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.spi.impl.AbstractInternalPasswordCredentialInterceptorImpl;

public class MaxPasswordAuthenticationFailuresInterceptor
extends AbstractInternalPasswordCredentialInterceptorImpl {
    private int maxNumberOfAuthenticationFailures;

    public MaxPasswordAuthenticationFailuresInterceptor(int maxNumberOfAuthenticationFailures) {
        this.maxNumberOfAuthenticationFailures = maxNumberOfAuthenticationFailures;
    }

    public boolean afterAuthenticated(InternalUserPrincipal internalUser, String userName, InternalCredential credential, boolean authenticated) throws SecurityException {
        boolean update = false;
        if (!credential.isExpired() && !authenticated && this.maxNumberOfAuthenticationFailures > 0) {
            int authenticationFailures = credential.getAuthenticationFailures() + 1;
            credential.setAuthenticationFailures(authenticationFailures);
            if (authenticationFailures >= this.maxNumberOfAuthenticationFailures) {
                credential.setEnabled(false);
            }
            update = true;
        }
        return update;
    }

    public void beforeCreate(InternalUserPrincipal internalUser, Collection credentials, String userName, InternalCredential credential, String password) throws SecurityException {
        credential.setAuthenticationFailures(0);
    }

    public void beforeSetPassword(InternalUserPrincipal internalUser, Collection credentials, String userName, InternalCredential credential, String password, boolean authenticated) throws SecurityException {
        credential.setAuthenticationFailures(0);
    }
}

