/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.GroupPrincipal;
import org.apache.jetspeed.security.HierarchyResolver;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.impl.GeneralizationHierarchyResolver;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.spi.SecurityMappingHandler;
import org.apache.jetspeed.security.spi.impl.ldap.LdapGroupDaoImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapRoleDaoImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserPrincipalDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserPrincipalDaoImpl;

public class LdapSecurityMappingHandler
implements SecurityMappingHandler {
    private LdapUserPrincipalDao userDao;
    private LdapPrincipalDao groupDao;
    private LdapPrincipalDao roleDao;
    private static final Log LOG = LogFactory.getLog((Class)LdapSecurityMappingHandler.class);
    private HierarchyResolver roleHierarchyResolver = new GeneralizationHierarchyResolver();
    private HierarchyResolver groupHierarchyResolver = new GeneralizationHierarchyResolver();

    public LdapSecurityMappingHandler(LdapUserPrincipalDao userDao, LdapPrincipalDao groupDao, LdapPrincipalDao roleDao) {
        this.userDao = userDao;
        this.groupDao = groupDao;
        this.roleDao = roleDao;
    }

    public LdapSecurityMappingHandler() throws SecurityException, NamingException {
        this.userDao = new LdapUserPrincipalDaoImpl();
        this.groupDao = new LdapGroupDaoImpl();
        this.roleDao = new LdapRoleDaoImpl();
    }

    public HierarchyResolver getRoleHierarchyResolver() {
        return this.roleHierarchyResolver;
    }

    public void setRoleHierarchyResolver(HierarchyResolver roleHierarchyResolver) {
        this.roleHierarchyResolver = roleHierarchyResolver;
    }

    public HierarchyResolver getGroupHierarchyResolver() {
        return this.groupHierarchyResolver;
    }

    public void setGroupHierarchyResolver(HierarchyResolver groupHierarchyResolver) {
        this.groupHierarchyResolver = groupHierarchyResolver;
    }

    public Set getRolePrincipals(String username) {
        HashSet rolePrincipals = new HashSet();
        try {
            String[] roles = this.userDao.getRoleUidsForUser(username);
            for (int i = 0; i < roles.length; ++i) {
                this.createResolvedRolePrincipalSet(username, rolePrincipals, roles, i);
            }
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        return rolePrincipals;
    }

    public void setUserPrincipalInRole(String username, String roleFullPathName) throws SecurityException {
        this.verifyUserAndRoleExist(username, roleFullPathName);
        this.addRoleToUser(username, roleFullPathName);
    }

    public void removeUserPrincipalInRole(String username, String roleFullPathName) throws SecurityException {
        this.verifyUserAndRoleExist(username, roleFullPathName);
        this.removeUserFromRole(username, roleFullPathName);
    }

    public Set getRolePrincipalsInGroup(String groupFullPathName) {
        HashSet rolePrincipalsInGroup = new HashSet();
        try {
            String[] roles = this.userDao.getRolesForGroup(groupFullPathName);
            for (int i = 0; i < roles.length; ++i) {
                this.createResolvedRolePrincipalSet(groupFullPathName, rolePrincipalsInGroup, roles, i);
            }
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        return rolePrincipalsInGroup;
    }

    public void setRolePrincipalInGroup(String groupFullPathName, String roleFullPathName) throws SecurityException {
        this.verifyGroupAndRoleExist(groupFullPathName, roleFullPathName);
        this.addRoleToGroup(groupFullPathName, roleFullPathName);
    }

    public void removeRolePrincipalInGroup(String groupFullPathName, String roleFullPathName) throws SecurityException {
        this.verifyGroupAndRoleExist(groupFullPathName, roleFullPathName);
        this.removeRoleFromGroup(groupFullPathName, roleFullPathName);
    }

    public Set getGroupPrincipals(String userPrincipalUid) {
        HashSet groupPrincipals = new HashSet();
        try {
            String[] groups = this.userDao.getGroupUidsForUser(userPrincipalUid);
            for (int i = 0; i < groups.length; ++i) {
                this.createResolvedGroupPrincipalSet(userPrincipalUid, groupPrincipals, groups, i);
            }
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        return groupPrincipals;
    }

    public Set getGroupPrincipalsInRole(String roleFullPathName) {
        HashSet groupPrincipals = new HashSet();
        return groupPrincipals;
    }

    public Set getUserPrincipalsInRole(String roleFullPathName) {
        HashSet userPrincipals = new HashSet();
        String[] fullPaths = new String[]{roleFullPathName};
        try {
            this.getUserPrincipalsInRole(userPrincipals, fullPaths);
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        return userPrincipals;
    }

    public Set getUserPrincipalsInGroup(String groupFullPathName) {
        HashSet userPrincipals = new HashSet();
        String[] fullPaths = new String[]{groupFullPathName};
        try {
            this.getUserPrincipalsInGroup(userPrincipals, fullPaths);
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        return userPrincipals;
    }

    private void getUserPrincipalsInGroup(Set userPrincipals, String[] fullPaths) throws SecurityException {
        for (int i = 0; i < fullPaths.length; ++i) {
            String[] usersInGroup = this.userDao.getUserUidsForGroup(fullPaths[i]);
            for (int y = 0; y < usersInGroup.length; ++y) {
                UserPrincipalImpl userPrincipal = new UserPrincipalImpl(usersInGroup[y]);
                userPrincipals.add(userPrincipal);
            }
        }
    }

    private void getUserPrincipalsInRole(Set userPrincipals, String[] fullPaths) throws SecurityException {
        for (int i = 0; i < fullPaths.length; ++i) {
            String[] usersInRole = this.userDao.getUserUidsForRole(fullPaths[i]);
            for (int y = 0; y < usersInRole.length; ++y) {
                UserPrincipalImpl userPrincipal = new UserPrincipalImpl(usersInRole[y]);
                userPrincipals.add(userPrincipal);
            }
        }
    }

    public void setUserPrincipalInGroup(String username, String groupFullPathName) throws SecurityException {
        this.verifyUserAndGroupExist(username, groupFullPathName);
        this.addGroupToUser(username, groupFullPathName);
    }

    public void removeUserPrincipalInGroup(String username, String groupFullPathName) throws SecurityException {
        this.verifyUserAndGroupExist(username, groupFullPathName);
        this.removeUserFromGroup(username, groupFullPathName);
    }

    private void verifyGroupAndRoleExist(String groupFullPathName, String roleFullPathName) throws SecurityException {
        GroupPrincipal group = this.getGroup(groupFullPathName);
        RolePrincipal role = this.getRole(roleFullPathName);
        if (null == group && null == role) {
            throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST);
        }
    }

    private void verifyUserAndGroupExist(String username, String groupFullPathName) throws SecurityException {
        UserPrincipal user = this.getUser(username);
        GroupPrincipal group = this.getGroup(groupFullPathName);
        if (null == user && null == group) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST);
        }
    }

    private void verifyUserAndRoleExist(String username, String roleFullPathName) throws SecurityException {
        UserPrincipal user = this.getUser(username);
        RolePrincipal role = this.getRole(roleFullPathName);
        if (null == user && null == role) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST);
        }
    }

    private void createResolvedGroupPrincipalSet(String username, Set groupPrincipals, String[] groups, int i) {
        LOG.debug((Object)("Group [" + i + "] for user[" + username + "] is [" + groups[i] + "]"));
        GroupPrincipalImpl group = new GroupPrincipalImpl(groups[i]);
        Preferences preferences = Preferences.userRoot().node(group.getFullPath());
        LOG.debug((Object)("Group name:" + group.getName()));
        String[] fullPaths = this.groupHierarchyResolver.resolve(preferences);
        for (int n = 0; n < fullPaths.length; ++n) {
            LOG.debug((Object)("Group [" + i + "] for user[" + username + "] is [" + GroupPrincipalImpl.getPrincipalNameFromFullPath(fullPaths[n]) + "]"));
            groupPrincipals.add(new GroupPrincipalImpl(GroupPrincipalImpl.getPrincipalNameFromFullPath(fullPaths[n])));
        }
    }

    private void createResolvedRolePrincipalSet(String username, Set rolePrincipals, String[] roles, int i) {
        LOG.debug((Object)("Group [" + i + "] for user[" + username + "] is [" + roles[i] + "]"));
        RolePrincipalImpl role = new RolePrincipalImpl(roles[i]);
        Preferences preferences = Preferences.userRoot().node(role.getFullPath());
        LOG.debug((Object)("Group name:" + role.getName()));
        String[] fullPaths = this.roleHierarchyResolver.resolve(preferences);
        for (int n = 0; n < fullPaths.length; ++n) {
            LOG.debug((Object)("Group [" + i + "] for user[" + username + "] is [" + RolePrincipalImpl.getPrincipalNameFromFullPath(fullPaths[n]) + "]"));
            rolePrincipals.add(new RolePrincipalImpl(RolePrincipalImpl.getPrincipalNameFromFullPath(fullPaths[n])));
        }
    }

    private void removeUserFromGroup(String username, String groupFullPathName) throws SecurityException {
        this.userDao.removeGroup(username, groupFullPathName);
    }

    private void removeUserFromRole(String username, String roleFullPathName) throws SecurityException {
        this.userDao.removeRole(username, roleFullPathName);
    }

    private void removeRoleFromGroup(String groupFullPathName, String roleFullPathName) throws SecurityException {
        this.userDao.removeRoleFromGroup(groupFullPathName, roleFullPathName);
    }

    private UserPrincipal getUser(String uid) throws SecurityException {
        Principal[] user = this.userDao.find(uid, "/user/");
        if (user.length == 1) {
            return (UserPrincipal)user[0];
        }
        throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)uid));
    }

    private GroupPrincipal getGroup(String uid) throws SecurityException {
        Principal[] group = this.groupDao.find(uid, "/group/");
        if (group.length == 1) {
            return (GroupPrincipal)group[0];
        }
        throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)uid));
    }

    private RolePrincipal getRole(String uid) throws SecurityException {
        Principal[] role = this.roleDao.find(uid, "/role/");
        if (role.length == 1) {
            return (RolePrincipal)role[0];
        }
        throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST.create((Object)uid));
    }

    private void addGroupToUser(String username, String groupFullPathName) throws SecurityException {
        this.userDao.addGroup(username, groupFullPathName);
    }

    private void addRoleToUser(String username, String roleFullPathName) throws SecurityException {
        this.userDao.addRole(username, roleFullPathName);
    }

    private void addRoleToGroup(String groupFullPathName, String roleFullPathName) throws SecurityException {
        this.userDao.addRoleToGroup(groupFullPathName, roleFullPathName);
    }
}

