/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.GroupPrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.spi.GroupSecurityHandler;
import org.apache.jetspeed.security.spi.impl.ldap.LdapGroupDaoImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDao;

public class LdapGroupSecurityHandler
implements GroupSecurityHandler {
    private static final Log logger = LogFactory.getLog((Class)LdapGroupSecurityHandler.class);
    private LdapPrincipalDao ldap;

    public LdapGroupSecurityHandler(LdapPrincipalDao ldap) {
        this.ldap = ldap;
    }

    public LdapGroupSecurityHandler() throws NamingException, SecurityException {
        this(new LdapGroupDaoImpl());
    }

    public GroupPrincipal getGroupPrincipal(String groupPrincipalUid) {
        String groupUidWithoutSlashes = this.ldap.convertUidToLdapAcceptableName(groupPrincipalUid);
        this.verifyGroupId(groupUidWithoutSlashes);
        try {
            String dn = this.ldap.lookupByUid(groupUidWithoutSlashes);
            if (!StringUtils.isEmpty((String)dn)) {
                return new GroupPrincipalImpl(groupPrincipalUid);
            }
        }
        catch (SecurityException e) {
            this.logSecurityException(e, groupPrincipalUid);
        }
        return null;
    }

    private void verifyGroupId(String groupPrincipalUid) {
        if (StringUtils.isEmpty((String)groupPrincipalUid)) {
            throw new IllegalArgumentException("The groupId cannot be null or empty.");
        }
    }

    private void logSecurityException(SecurityException e, String groupPrincipalUid) {
        if (logger.isErrorEnabled()) {
            logger.error((Object)("An LDAP error has occurred for groupId:" + groupPrincipalUid), (Throwable)e);
        }
    }

    public void setGroupPrincipal(GroupPrincipal groupPrincipal) throws SecurityException {
        this.verifyGroupPrincipal(groupPrincipal);
        String fullPath = groupPrincipal.getFullPath();
        String groupUidWithoutSlashes = this.ldap.convertUidToLdapAcceptableName(fullPath);
        if (this.getGroupPrincipal(groupUidWithoutSlashes) == null) {
            this.ldap.create(groupUidWithoutSlashes);
        }
    }

    private void verifyGroupPrincipal(GroupPrincipal groupPrincipal) {
        if (groupPrincipal == null) {
            throw new IllegalArgumentException("The GroupPrincipal cannot be null or empty.");
        }
    }

    public void removeGroupPrincipal(GroupPrincipal groupPrincipal) throws SecurityException {
        this.verifyGroupPrincipal(groupPrincipal);
        String fullPath = groupPrincipal.getFullPath();
        String groupUidWithoutSlashes = this.ldap.convertUidToLdapAcceptableName(fullPath);
        this.ldap.delete(groupUidWithoutSlashes);
    }

    public List getGroupPrincipals(String filter) {
        try {
            return Arrays.asList(this.ldap.find(filter, "/group/"));
        }
        catch (SecurityException e) {
            this.logSecurityException(e, filter);
            return new ArrayList();
        }
    }
}

