/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.jetspeed.security.AlgorithmUpgradePasswordEncodingService;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.spi.PasswordCredentialProvider;
import org.apache.jetspeed.security.spi.impl.AbstractInternalPasswordCredentialInterceptorImpl;

public class EncodePasswordOnFirstLoadInterceptor
extends AbstractInternalPasswordCredentialInterceptorImpl {
    public boolean afterLoad(PasswordCredentialProvider pcProvider, String userName, InternalCredential credential) throws SecurityException {
        boolean updated = false;
        if (!credential.isEncoded() && pcProvider.getEncoder() != null) {
            credential.setValue(pcProvider.getEncoder().encode(userName, credential.getValue()));
            credential.setEncoded(true);
            if (pcProvider.getEncoder() instanceof AlgorithmUpgradePasswordEncodingService) {
                credential.setPreviousAuthenticationDate(new Timestamp(new Date().getTime()));
                credential.setLastAuthenticationDate(null);
            }
            updated = true;
        }
        return updated;
    }
}

