/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.om.InternalCredential;

public class DefaultPasswordCredentialImpl
implements PasswordCredential,
Serializable {
    private static final long serialVersionUID = -4975305752376365096L;
    private String userName;
    private char[] password;
    private boolean updateRequired;
    private boolean enabled = true;
    private boolean expired;
    private Date expirationDate;
    private Timestamp previousAuthenticationDate;
    private Timestamp lastAuthenticationDate;
    private int authenticationFailures;

    public DefaultPasswordCredentialImpl(String userName, char[] password) {
        this.userName = userName;
        this.password = (char[])password.clone();
    }

    public DefaultPasswordCredentialImpl(String userName, InternalCredential credential) {
        this(userName, credential.getValue().toCharArray());
        this.updateRequired = credential.isUpdateRequired();
        this.enabled = credential.isEnabled();
        this.expired = credential.isExpired();
        this.expirationDate = credential.getExpirationDate();
        this.previousAuthenticationDate = credential.getPreviousAuthenticationDate();
        this.lastAuthenticationDate = credential.getLastAuthenticationDate();
        this.authenticationFailures = credential.getAuthenticationFailures();
    }

    public String getUserName() {
        return this.userName;
    }

    public char[] getPassword() {
        return (char[])this.password.clone();
    }

    public boolean isUpdateRequired() {
        return this.updateRequired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public Timestamp getPreviousAuthenticationDate() {
        return this.previousAuthenticationDate;
    }

    public Timestamp getLastAuthenticationDate() {
        return this.lastAuthenticationDate;
    }

    public int getAuthenticationFailures() {
        return this.authenticationFailures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPasswordCredentialImpl)) {
            return false;
        }
        DefaultPasswordCredentialImpl credential = (DefaultPasswordCredentialImpl)o;
        if (!Arrays.equals(this.password, credential.password)) {
            return false;
        }
        return this.userName.equals(credential.userName);
    }

    public int hashCode() {
        int result = this.userName.hashCode();
        for (int i = 0; i < this.password.length; ++i) {
            result *= this.password[i];
        }
        return result;
    }
}

