/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jetspeed.security.LoginModuleProxy;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.impl.LoginModuleProxyImpl;
import org.apache.jetspeed.security.impl.PassiveCallbackHandler;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;

public class DefaultLoginModule
implements LoginModule {
    protected boolean debug;
    protected boolean success;
    protected boolean commitSuccess;
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected Map options;
    protected UserManager ums;
    protected String portalUserRole;
    protected String username;

    public DefaultLoginModule() {
        LoginModuleProxy loginModuleProxy = LoginModuleProxyImpl.loginModuleProxy;
        if (loginModuleProxy != null) {
            this.ums = loginModuleProxy.getUserManager();
            this.portalUserRole = loginModuleProxy.getPortalUserRole();
        }
        this.debug = false;
        this.success = false;
        this.commitSuccess = false;
        this.username = null;
    }

    protected DefaultLoginModule(UserManager userManager, String portalUserRole) {
        this.ums = userManager;
        this.portalUserRole = portalUserRole;
        this.debug = false;
        this.success = false;
        this.commitSuccess = false;
        this.username = null;
    }

    protected DefaultLoginModule(UserManager userManager) {
        this(userManager, "portal-user");
    }

    public boolean abort() throws LoginException {
        this.success = false;
        this.commitSuccess = false;
        this.username = null;
        if (this.callbackHandler instanceof PassiveCallbackHandler) {
            ((PassiveCallbackHandler)this.callbackHandler).clearPassword();
        }
        this.logout();
        return true;
    }

    protected void refreshProxy() {
        LoginModuleProxy loginModuleProxy;
        if (this.ums == null && (loginModuleProxy = LoginModuleProxyImpl.loginModuleProxy) != null) {
            this.ums = loginModuleProxy.getUserManager();
        }
    }

    public boolean commit() throws LoginException {
        if (this.success) {
            if (this.subject.isReadOnly()) {
                throw new LoginException("Subject is Readonly");
            }
            try {
                this.refreshProxy();
                this.commitPrincipals(this.subject, this.ums.getUser(this.username));
                this.username = null;
                this.commitSuccess = true;
                if (this.callbackHandler instanceof PassiveCallbackHandler) {
                    ((PassiveCallbackHandler)this.callbackHandler).clearPassword();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                throw new LoginException(ex.getMessage());
            }
        }
        return this.commitSuccess;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.refreshProxy();
            this.success = this.ums.authenticate(this.username, password);
            callbacks[0] = null;
            callbacks[1] = null;
            if (!this.success) {
                throw new FailedLoginException("Authentication failed: Password does not match");
            }
            return true;
        }
        catch (LoginException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.success = false;
            throw new LoginException(ex.getMessage());
        }
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().clear();
        this.subject.getPrivateCredentials().clear();
        this.subject.getPublicCredentials().clear();
        this.success = false;
        this.commitSuccess = false;
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        if (options.containsKey("debug")) {
            this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        }
    }

    protected Principal getUserPrincipal(User user) {
        return SecurityHelper.getPrincipal(user.getSubject(), UserPrincipal.class);
    }

    protected List getUserRoles(User user) {
        return SecurityHelper.getPrincipals(user.getSubject(), RolePrincipal.class);
    }

    protected void commitPrincipals(Subject subject, User user) {
        subject.getPrincipals().add(this.getUserPrincipal(user));
        subject.getPrincipals().addAll(this.getUserRoles(user));
        subject.getPrincipals().add((Principal)((Object)new RolePrincipalImpl(this.portalUserRole)));
    }
}

