/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.search.solr;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.search.BaseParsedObject;
import org.apache.jetspeed.search.HandlerFactory;
import org.apache.jetspeed.search.ObjectHandler;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.search.SearchResults;
import org.apache.jetspeed.search.SearchResultsImpl;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSearchEngineImpl
implements SearchEngine {
    private static final Logger log = LoggerFactory.getLogger(SolrSearchEngineImpl.class);
    private SolrServer server;
    private boolean optimizeAfterUpdate = true;
    private HandlerFactory handlerFactory;
    private Set<String> searchableMetadataFieldNames = new HashSet<String>(Arrays.asList("ID", "url", "portlet", "portlet_application", "subject", "creator", "publisher", "title", "fieldname.title", "contributor", "description", "fieldname.description"));

    public SolrSearchEngineImpl(SolrServer server, boolean optimzeAfterUpdate, HandlerFactory handlerFactory) {
        this.server = server;
        this.optimizeAfterUpdate = optimzeAfterUpdate;
        this.handlerFactory = handlerFactory;
    }

    public Set<String> getSearchableMetadataFieldNames() {
        return this.searchableMetadataFieldNames;
    }

    public void setSearchableMetadataFieldNames(Set<String> searchableMetadataFieldNames) {
        this.searchableMetadataFieldNames = searchableMetadataFieldNames;
    }

    public boolean add(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.add(c);
    }

    public boolean add(Collection objects) {
        return this.removeIfExistsAndAdd(objects);
    }

    public boolean remove(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.remove(c);
    }

    public synchronized boolean remove(Collection objects) {
        int deleteCount = 0;
        try {
            for (Object o : objects) {
                UpdateResponse rsp;
                ObjectHandler handler = this.handlerFactory.getHandler(o);
                ParsedObject parsedObject = handler.parseObject(o);
                if (parsedObject.getKey() == null) continue;
                String queryString = new StringBuilder(40).append("fieldname.key").append(':').append(ClientUtils.escapeQueryChars((String)parsedObject.getKey())).toString();
                SolrQuery query = new SolrQuery();
                query.setQuery(queryString);
                QueryResponse qrsp = this.server.query((SolrParams)query);
                int count = qrsp.getResults().size();
                if (count <= 0 || (rsp = this.server.deleteByQuery(queryString)).getStatus() >= 300) continue;
                deleteCount += count;
            }
            if (deleteCount > 0) {
                this.server.commit();
                if (this.optimizeAfterUpdate) {
                    this.server.optimize();
                }
            }
        }
        catch (Exception e) {
            log.error("Exception during removing documents in the search index.", (Throwable)e);
        }
        return deleteCount > 0;
    }

    public boolean update(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.update(c);
    }

    public boolean update(Collection objects) {
        return this.removeIfExistsAndAdd(objects);
    }

    public SearchResults search(String queryString) {
        return this.search(queryString, "fieldname.synthetic");
    }

    public SearchResults search(String queryString, String defaultFieldName) {
        return this.search(queryString, defaultFieldName, 0);
    }

    public SearchResults search(String queryString, String defaultFieldName, int topHitsCount) {
        SearchResultsImpl results = null;
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery(queryString);
            QueryResponse rsp = this.server.query((SolrParams)query);
            SolrDocumentList docList = rsp.getResults();
            ArrayList<BaseParsedObject> resultList = new ArrayList<BaseParsedObject>();
            for (SolrDocument doc : docList) {
                Collection keywords;
                Object url;
                Object classname;
                Object language;
                Object content;
                Object title;
                Object description;
                Object key;
                BaseParsedObject result = new BaseParsedObject();
                this.addFieldsToParsedObject(doc, result);
                Object type = doc.getFirstValue("fieldname.type");
                if (type != null) {
                    result.setType(type.toString());
                }
                if ((key = doc.getFirstValue("fieldname.key")) != null) {
                    result.setKey(key.toString());
                }
                if ((description = doc.getFirstValue("fieldname.description")) != null) {
                    result.setDescription(description.toString());
                }
                if ((title = doc.getFirstValue("fieldname.title")) != null) {
                    result.setTitle(title.toString());
                }
                if ((content = doc.getFirstValue("fieldname.content")) != null) {
                    result.setContent(content.toString());
                }
                if ((language = doc.getFirstValue("fieldname.language")) != null) {
                    result.setLanguage(language.toString());
                }
                if ((classname = doc.getFirstValue("fieldname.className")) != null) {
                    result.setClassName(classname.toString());
                }
                if ((url = doc.getFirstValue("fieldname.url")) != null) {
                    result.setURL(new URL(url.toString()));
                }
                if ((keywords = doc.getFieldValues("fieldname.keywords")) != null) {
                    String[] keywordArray = new String[keywords.size()];
                    int index = 0;
                    for (Object keyword : keywords) {
                        keywordArray[index++] = keyword.toString();
                    }
                    result.setKeywords(keywordArray);
                }
                resultList.add(result);
            }
            results = new SearchResultsImpl(resultList);
        }
        catch (Exception e) {
            log.error("Failed to search. ", (Throwable)e);
        }
        return results != null ? results : new SearchResultsImpl(new ArrayList());
    }

    public boolean optimize() {
        try {
            this.server.optimize();
            return true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Error while trying to optimize index. " + e, (Throwable)e);
            } else {
                log.error("Error while trying to optimize index. {}", (Object)e.toString());
            }
            return false;
        }
    }

    private synchronized boolean removeIfExistsAndAdd(Collection objects) {
        try {
            ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
            for (Object o : objects) {
                String[] keywordArray;
                ObjectHandler handler = null;
                try {
                    handler = this.handlerFactory.getHandler(o);
                }
                catch (Exception e) {
                    log.error("Failed to create hanlder for object " + o.getClass().getName());
                    continue;
                }
                ParsedObject parsedObject = handler.parseObject(o);
                String key = parsedObject.getKey();
                if (parsedObject.getKey() != null) {
                    UpdateResponse ursp;
                    SolrQuery query = new SolrQuery();
                    String queryString = new StringBuilder(40).append("fieldname.key").append(':').append(ClientUtils.escapeQueryChars((String)key)).toString();
                    query.setQuery(queryString);
                    QueryResponse qrsp = this.server.query((SolrParams)query);
                    if (!qrsp.getResults().isEmpty() && (ursp = this.server.deleteByQuery(queryString)).getStatus() < 300) {
                        this.server.commit();
                    }
                }
                String type = parsedObject.getType();
                String title = parsedObject.getTitle();
                String description = parsedObject.getDescription();
                String content = parsedObject.getContent();
                String language = parsedObject.getLanguage();
                URL url = parsedObject.getURL();
                String className = parsedObject.getClassName();
                SolrInputDocument doc = new SolrInputDocument();
                if (key != null) {
                    doc.addField("fieldname.key", (Object)key, 1.0f);
                }
                if (type != null) {
                    doc.addField("fieldname.type", (Object)type, 1.0f);
                }
                if (title != null) {
                    doc.addField("fieldname.title", (Object)title, 1.0f);
                }
                if (description != null) {
                    doc.addField("fieldname.description", (Object)description, 1.0f);
                }
                if (content != null) {
                    doc.addField("fieldname.content", (Object)content, 1.0f);
                }
                if (language != null) {
                    doc.addField("fieldname.language", (Object)language, 1.0f);
                }
                if (url != null) {
                    String urlString = url.toString();
                    doc.addField("fieldname.url", (Object)urlString, 1.0f);
                }
                if (className != null) {
                    doc.addField("fieldname.className", (Object)className, 1.0f);
                }
                if ((keywordArray = parsedObject.getKeywords()) != null) {
                    for (int i = 0; i < keywordArray.length; ++i) {
                        String keyword = keywordArray[i];
                        doc.addField("fieldname.keywords", (Object)keyword, 1.0f);
                    }
                }
                Map keywords = parsedObject.getKeywordsMap();
                this.addFieldsToDocument(doc, keywords);
                Map fields = parsedObject.getFields();
                this.addFieldsToDocument(doc, fields);
                ArrayList<String> syntheticField = new ArrayList<String>();
                for (Map.Entry entry : doc.entrySet()) {
                    SolrInputField field = (SolrInputField)entry.getValue();
                    Object value = field.getFirstValue();
                    if (value == null) continue;
                    syntheticField.add(value.toString());
                }
                doc.addField("fieldname.synthetic", (Object)StringUtils.join(syntheticField, (char)' '), 1.0f);
                docs.add(doc);
            }
            if (objects.size() > 0) {
                this.server.add(docs);
                this.server.commit();
                if (this.optimizeAfterUpdate) {
                    try {
                        this.server.optimize();
                    }
                    catch (IOException e) {
                        log.error("Error while trying to optimize index.", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Error while writing index.", (Throwable)e);
            return false;
        }
        return true;
    }

    private void addFieldsToDocument(SolrInputDocument doc, Map fields) {
        if (fields != null) {
            for (Object key : fields.keySet()) {
                Object values;
                if (key == null || !this.searchableMetadataFieldNames.contains(key) || (values = fields.get(key)) == null) continue;
                if (values instanceof Collection) {
                    for (Object value : (Collection)values) {
                        if (value == null) continue;
                        doc.addField(key.toString(), (Object)value.toString(), 1.0f);
                    }
                    continue;
                }
                doc.addField(key.toString(), (Object)values.toString(), 1.0f);
            }
        }
    }

    private void addFieldsToParsedObject(SolrDocument doc, ParsedObject o) {
        try {
            MultiValueMap multiKeywords = new MultiValueMap();
            MultiValueMap multiFields = new MultiValueMap();
            HashMap fieldMap = new HashMap();
            Object classNameField = doc.getFirstValue("fieldname.className");
            if (classNameField != null) {
                String className = classNameField.toString();
                o.setClassName(className);
                ObjectHandler handler = this.handlerFactory.getHandler(className);
                Set fields = handler.getFields();
                this.addFieldsToMap(doc, fields, (Map)multiFields);
                this.addFieldsToMap(doc, fields, fieldMap);
                Set keywords = handler.getKeywords();
                this.addFieldsToMap(doc, keywords, (Map)multiKeywords);
            }
            o.setKeywordsMap((Map)multiKeywords);
            o.setFields((Map)multiFields);
            o.setFields(fieldMap);
        }
        catch (Exception e) {
            log.error("Error trying to add fields to parsed object.", (Throwable)e);
        }
    }

    private void addFieldsToMap(SolrDocument doc, Set fieldNames, Map fields) {
        for (String fieldName : fieldNames) {
            Collection values = doc.getFieldValues(fieldName);
            if (values == null) continue;
            for (Object value : values) {
                fields.put(fieldName, value.toString());
            }
        }
    }
}

