/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.transform.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.portals.applications.transform.Transform;
import org.apache.portals.applications.transform.TransformException;
import org.apache.portals.applications.transform.TransformObjectPublisher;
import org.apache.portals.applications.transform.impl.TransformDTDEntityResolver;
import org.apache.portals.applications.util.Streams;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JetspeedTransform
implements Transform {
    private static DocumentBuilderFactory domFactory = null;
    private static SAXParserFactory saxFactory = null;
    private static SAXTransformerFactory transformerFactory = null;
    private static final String CONFIG_JAX_FACTORY_SAX = "jax.factory.sax";
    private static final String jaxSaxFactoryProp = "org.apache.xerces.jaxp.SAXParserFactoryImpl";
    private static final String CONFIG_JAX_FACTORY_DOM = "jax.factory.dom";
    private static final String jaxDomFactoryProp = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static final String CONFIG_JAX_FACTORY_TRANSFORM = "jax.factory.transform";
    private static final String jaxTransformFactoryProp = "org.apache.xalan.processor.TransformerFactoryImpl";
    private static final Object mutex = new Object();
    private static final String JAX_TRANSFORM_PROPERTY = "javax.xml.transform.TransformerFactory";
    private static final String JAX_SAX_PARSER_PROPERTY = "javax.xml.parsers.SAXParserFactory";
    private static final String JAX_DOM_PARSER_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String SAX_XML_READER_PROPERTY = "org.xml.sax.driver";
    private static final String saxXmlReaderProp = "org.apache.xerces.parsers.SAXParser";
    private static Map dtds = new HashMap();
    private TransformObjectPublisher publisher = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JetspeedTransform() {
        Object object = mutex;
        synchronized (object) {
            if (transformerFactory == null) {
                System.setProperty(JAX_TRANSFORM_PROPERTY, jaxTransformFactoryProp);
                System.setProperty(JAX_SAX_PARSER_PROPERTY, jaxSaxFactoryProp);
                System.setProperty(JAX_DOM_PARSER_PROPERTY, jaxDomFactoryProp);
                System.setProperty(SAX_XML_READER_PROPERTY, saxXmlReaderProp);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setValidating(false);
                saxFactory = SAXParserFactory.newInstance();
                saxFactory.setValidating(false);
                transformerFactory = (SAXTransformerFactory)tFactory;
            }
        }
        this.publisher = new TransformObjectPublisher();
    }

    public void transform(String xslt, InputSource inputSource, OutputStream os, Map parameters) throws TransformException {
        if (xslt == null) {
            try {
                Streams.drain(inputSource.getByteStream(), os);
            }
            catch (IOException e) {
                throw new TransformException(e);
            }
        } else {
            JetspeedTransform.transformStream(xslt, inputSource, new StreamResult(os), parameters);
        }
    }

    public void transform(String xslt, InputSource inputSource, Writer writer, Map parameters) throws TransformException {
        if (xslt == null) {
            try {
                Streams.drain(inputSource.getCharacterStream(), writer);
            }
            catch (IOException e) {
                throw new TransformException(e);
            }
        } else {
            JetspeedTransform.transformStream(xslt, inputSource, new StreamResult(writer), parameters);
        }
    }

    private static void transformStream(String xslt, InputSource inputSource, StreamResult streamResult, Map parameters) throws TransformException {
        if (xslt == null) {
            throw new TransformException("Invalid Transform, no stylesheet set!");
        }
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = domFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(new TransformDTDEntityResolver(dtds));
        }
        catch (ParserConfigurationException e) {
            throw new TransformException("Failed to load JAX Document Builder: " + e.toString());
        }
        try {
            TemplatesHandler templatesHandler = transformerFactory.newTemplatesHandler();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(templatesHandler);
            reader.setEntityResolver(new TransformDTDEntityResolver(dtds));
            FileInputStream is = new FileInputStream(xslt);
            InputStreamReader ssreader = new InputStreamReader(is);
            InputSource xstyle = new InputSource(ssreader);
            xstyle.setSystemId(xslt);
            reader.parse(xstyle);
            Templates templates = templatesHandler.getTemplates();
            TransformerHandler handler = transformerFactory.newTransformerHandler(templates);
            reader.setContentHandler(handler);
            Document doc = docBuilder.parse(inputSource);
            Transformer processor = handler.getTransformer();
            Iterator keys = parameters.keySet().iterator();
            while (keys.hasNext()) {
                String name = (String)keys.next();
                String value = (String)parameters.get(name);
                processor.setParameter(name, value);
            }
            processor.transform(new DOMSource(doc), streamResult);
        }
        catch (Exception e) {
            throw new TransformException("Error in Transformation: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformStream(String xslt, Document document, StreamResult streamResult, Map parameters) throws TransformException {
        if (xslt == null) {
            throw new TransformException("Invalid Transform, no stylesheet set!");
        }
        Object object = mutex;
        synchronized (object) {
            if (transformerFactory == null) {
                System.setProperty(JAX_TRANSFORM_PROPERTY, jaxTransformFactoryProp);
                System.setProperty(JAX_SAX_PARSER_PROPERTY, jaxSaxFactoryProp);
                System.setProperty(JAX_DOM_PARSER_PROPERTY, jaxDomFactoryProp);
                System.setProperty(SAX_XML_READER_PROPERTY, saxXmlReaderProp);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setValidating(false);
                saxFactory = SAXParserFactory.newInstance();
                saxFactory.setValidating(false);
                if (!tFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                    throw new TransformException("Invalid SAX Tranformer. Doesn't support SAX");
                }
                transformerFactory = (SAXTransformerFactory)tFactory;
            }
        }
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = domFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(new TransformDTDEntityResolver(dtds));
        }
        catch (ParserConfigurationException e) {
            throw new TransformException("Failed to load JAX Document Builder: " + e.toString());
        }
        try {
            TemplatesHandler templatesHandler = transformerFactory.newTemplatesHandler();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(templatesHandler);
            reader.setEntityResolver(new TransformDTDEntityResolver(dtds));
            FileInputStream is = new FileInputStream(xslt);
            InputStreamReader ssreader = new InputStreamReader(is);
            InputSource xstyle = new InputSource(ssreader);
            xstyle.setSystemId(xslt);
            reader.parse(xstyle);
            Templates templates = templatesHandler.getTemplates();
            TransformerHandler handler = transformerFactory.newTransformerHandler(templates);
            reader.setContentHandler(handler);
            Transformer processor = handler.getTransformer();
            Iterator keys = parameters.keySet().iterator();
            while (keys.hasNext()) {
                String name = (String)keys.next();
                String value = (String)parameters.get(name);
                processor.setParameter(name, value);
            }
            processor.transform(new DOMSource(document), streamResult);
        }
        catch (Exception e) {
            throw new TransformException("Error in Transformation: " + e.toString());
        }
    }

    public void transform(String xslt, Document document, OutputStream os, Map parameters) throws TransformException {
        if (xslt == null) {
            throw new TransformException("xslt is null");
        }
        JetspeedTransform.transformStream(xslt, document, new StreamResult(os), parameters);
    }

    public TransformObjectPublisher getPublisher() {
        return this.publisher;
    }
}

