/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.rss;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.portals.applications.rss.servlets.SpringInitServlet;
import org.apache.portals.applications.transform.Transform;
import org.apache.portals.applications.transform.TransformCache;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.springframework.beans.factory.BeanFactory;

public abstract class AbstractRssPortlet
extends GenericVelocityPortlet {
    protected TransformCache cache;
    protected Transform transform;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        BeanFactory factory = SpringInitServlet.getSpringFactory();
        this.cache = (TransformCache)factory.getBean("transformCache");
        this.transform = (Transform)factory.getBean("transform");
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        this.processPreferencesAction(request, actionResponse);
        String url = request.getPreferences().getValue("url", "http://www.npr.org/rss/rss.php?topicId=4");
        String stylesheet = this.getPortletConfig().getInitParameter("stylesheet");
        String key = this.cache.constructKey(url, stylesheet);
        this.cache.remove(key);
    }
}

