/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.rewriter.html.neko;

import org.apache.jetspeed.rewriter.Rewriter;
import org.apache.jetspeed.rewriter.html.neko.XMLAttributesWrapper;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.cyberneko.html.filters.DefaultFilter;

public class URLRewriterFilter
extends DefaultFilter {
    private Rewriter rewriter;

    public URLRewriterFilter(Rewriter rewriter) {
        this.rewriter = rewriter;
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        if (!this.rewriter.enterSimpleTagEvent(element.rawname, new XMLAttributesWrapper(attrs))) {
            this.doRewrite(element, attrs);
            String appended = this.rewriter.exitSimpleTagEvent(element.rawname, new XMLAttributesWrapper(attrs));
            if (null != appended) {
                // empty if block
            }
        }
        super.startElement(element, attrs, augs);
    }

    protected void doRewrite(QName element, XMLAttributes attrs) {
        if (element.rawname.equals("A")) {
            this.rewriteAttribute("href", attrs);
        } else if (element.rawname.equals("FORM")) {
            this.rewriteAttribute("action", attrs);
        }
    }

    protected void rewriteAttribute(String attrName, XMLAttributes attributes) {
        String uri = attributes.getValue(attrName);
        if (uri != null) {
            // empty if block
        }
    }

    public void emptyElement(QName element, XMLAttributes attrs, Augmentations arg2) throws XNIException {
        this.doRewrite(element, attrs);
        super.emptyElement(element, attrs, arg2);
    }

    public void comment(XMLString comment, Augmentations augs) throws XNIException {
        if (!this.rewriter.shouldRemoveComments()) {
            super.comment(comment, augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        super.endElement(element, augs);
    }

    public void characters(XMLString text, Augmentations arg1) throws XNIException {
        if (text.ch[0] != '>' && !this.rewriter.enterText(text.ch, text.offset)) {
            super.characters(text, arg1);
        }
    }
}

