/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.rewriter;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.rewriter.BasicRewriter;
import org.apache.jetspeed.rewriter.ParserAdaptor;
import org.apache.jetspeed.rewriter.Rewriter;
import org.apache.jetspeed.rewriter.RewriterController;
import org.apache.jetspeed.rewriter.RewriterException;
import org.apache.jetspeed.rewriter.RulesetRewriter;
import org.apache.jetspeed.rewriter.RulesetRewriterImpl;
import org.apache.jetspeed.rewriter.html.SwingParserAdaptor;
import org.apache.jetspeed.rewriter.rules.Ruleset;
import org.apache.jetspeed.rewriter.xml.SaxParserAdaptor;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JetspeedRewriterController
implements RewriterController {
    protected static final Log log = LogFactory.getLog((Class)JetspeedRewriterController.class);
    static final String CONFIG_MAPPING_FILE = "mapping";
    static final String CONFIG_BASIC_REWRITER = "basic.class";
    static final String CONFIG_RULESET_REWRITER = "ruleset.class";
    static final String CONFIG_ADAPTOR_HTML = "adaptor.html";
    static final String CONFIG_ADAPTOR_XML = "adaptor.xml";
    protected String mappingFile = null;
    protected Mapping mapper = null;
    protected Map rulesets = Collections.synchronizedMap(new HashMap());
    protected Class basicRewriterClass = BasicRewriter.class;
    protected Class rulesetRewriterClass = RulesetRewriterImpl.class;
    protected Class adaptorHtmlClass = SwingParserAdaptor.class;
    protected Class adaptorXmlClass = SaxParserAdaptor.class;

    public JetspeedRewriterController(String mappingFile) throws RewriterException {
        this.mappingFile = mappingFile;
        this.loadMapping();
    }

    public JetspeedRewriterController(String mappingFile, List rewriterClasses, List adaptorClasses) throws RewriterException {
        this.mappingFile = mappingFile;
        if (rewriterClasses.size() > 0) {
            this.basicRewriterClass = (Class)rewriterClasses.get(0);
            if (rewriterClasses.size() > 1) {
                this.rulesetRewriterClass = (Class)rewriterClasses.get(1);
            }
        }
        if (adaptorClasses.size() > 0) {
            this.adaptorHtmlClass = (Class)adaptorClasses.get(0);
            if (adaptorClasses.size() > 1) {
                this.adaptorXmlClass = (Class)adaptorClasses.get(1);
            }
        }
        this.loadMapping();
    }

    public JetspeedRewriterController(String mappingFile, String basicRewriterClassName, String rulesetRewriterClassName, String adaptorHtmlClassName, String adaptorXmlClassName) throws RewriterException {
        this(mappingFile, JetspeedRewriterController.toClassList(basicRewriterClassName, rulesetRewriterClassName), JetspeedRewriterController.toClassList(adaptorHtmlClassName, adaptorXmlClassName));
    }

    protected static List toClassList(String classNameA, String classNameB) {
        try {
            ArrayList list = new ArrayList(2);
            if (classNameA != null) {
                list.add(Class.forName(classNameA));
            }
            if (classNameB != null) {
                list.add(Class.forName(classNameB));
            }
            return list;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Rewriter createRewriter() throws InstantiationException, IllegalAccessException {
        return (Rewriter)this.basicRewriterClass.newInstance();
    }

    public RulesetRewriter createRewriter(Ruleset ruleset) throws RewriterException {
        try {
            RulesetRewriter rewriter = (RulesetRewriter)this.rulesetRewriterClass.newInstance();
            rewriter.setRuleset(ruleset);
            return rewriter;
        }
        catch (Exception e) {
            log.error((Object)"Error creating rewriter class", (Throwable)e);
            return null;
        }
    }

    public ParserAdaptor createParserAdaptor(String mimeType) throws RewriterException {
        try {
            if (mimeType.equals("text/html")) {
                return (ParserAdaptor)this.adaptorHtmlClass.newInstance();
            }
            if (mimeType.equals("text/xml")) {
                return (ParserAdaptor)this.adaptorXmlClass.newInstance();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error creating rewriter class", (Throwable)e);
        }
        return null;
    }

    protected void loadMapping() throws RewriterException {
        try {
            Reader reader = this.getReader(this.mappingFile);
            this.mapper = new Mapping();
            InputSource is = new InputSource(reader);
            is.setSystemId(this.mappingFile);
            this.mapper.loadMapping(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "RewriterService: Error in castor mapping creation";
            log.error((Object)msg, (Throwable)e);
            throw new RewriterException(msg, e);
        }
    }

    protected Reader getReader(String resource) throws RewriterException {
        File file = new File(resource);
        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                return new FileReader(file);
            }
            catch (Exception e) {
                throw new RewriterException("could not open rewriter file " + resource, e);
            }
        }
        throw new RewriterException("could not access rewriter file " + resource);
    }

    public Ruleset lookupRuleset(String id) {
        return (Ruleset)this.rulesets.get(id);
    }

    public Ruleset loadRuleset(Reader reader) {
        Ruleset ruleset = null;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            InputSource source = new InputSource(reader);
            Document doc = builder.parse(source);
            Unmarshaller unmarshaller = new Unmarshaller(this.mapper);
            ruleset = (Ruleset)unmarshaller.unmarshal((Node)doc);
            ruleset.sync();
            this.rulesets.put(ruleset.getId(), ruleset);
        }
        catch (Throwable t) {
            log.error((Object)("ForwardService: Could not unmarshal: " + reader), t);
        }
        return ruleset;
    }
}

