/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.window.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.apache.commons.collections.list.TreeList;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.aggregator.RenderTrackable;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.PortletWindowID;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.portlet.HeadElement;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.util.HeadElementsUtils;
import org.apache.jetspeed.util.KeyValue;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;

public class PortletWindowImpl
implements PortletWindow,
PortletWindowID,
RenderTrackable {
    private static final long serialVersionUID = 6578938580906866201L;
    private String id;
    private String portletEntityId;
    private ContentFragment fragment;
    private Map<String, Object> attributes;
    protected int timeoutCount = 0;
    protected long expiration = 0L;
    private PortletDefinition pd;
    private RequestContext requestContext;
    private PortletWindow.Action action;
    private PortletRequest portletRequest;
    private PortletResponseContext portletResponseContext;
    private PortletRequestContext portletRequestContext;
    private PortletResponse portletResponse;
    private PortletInstance portletInstance;
    private PortletMode portletMode;
    private WindowState windowState;
    private List<KeyValue<String, HeadElement>> headElements;
    private boolean valid;

    public PortletWindowImpl(RequestContext requestContext, ContentFragment fragment) {
        this(requestContext, fragment, null);
    }

    public PortletWindowImpl(RequestContext requestContext, ContentFragment fragment, PortletDefinition pd) {
        this.requestContext = requestContext;
        this.id = fragment.getId();
        this.portletEntityId = fragment.getFragmentId();
        if (this.portletEntityId == null) {
            this.portletEntityId = this.id;
        }
        this.fragment = fragment;
        this.pd = pd;
        this.valid = pd != null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getWindowId() {
        return this.id;
    }

    public PortletWindowID getId() {
        return this;
    }

    public String getPortletEntityId() {
        return this.portletEntityId;
    }

    public String toString() {
        return this.getStringId();
    }

    public String getStringId() {
        return this.id;
    }

    public PortletDefinition getPortletDefinition() {
        return this.pd;
    }

    public ContentFragment getFragment() {
        return this.fragment;
    }

    public boolean isInstantlyRendered() {
        return this.fragment.isInstantlyRendered();
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public PortletMode getPortletMode() {
        if (this.portletMode == null && this.valid) {
            this.portletMode = this.requestContext.getPortalURL().getNavigationalState().getMode((PortletWindow)this);
        }
        return this.portletMode != null ? this.portletMode : PortletMode.VIEW;
    }

    public WindowState getWindowState() {
        if (this.windowState == null && this.valid) {
            this.windowState = this.requestContext.getPortalURL().getNavigationalState().getState((PortletWindow)this);
        }
        return this.windowState != null ? this.windowState : WindowState.NORMAL;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    public Object getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is required");
        }
        if (value == null) {
            this.getAttributes().remove(name);
        } else {
            this.getAttributes().put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    public int getRenderTimeoutCount() {
        return this.timeoutCount;
    }

    public synchronized void incrementRenderTimeoutCount() {
        ++this.timeoutCount;
    }

    public synchronized void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void success() {
        this.timeoutCount = 0;
    }

    public void setRenderTimeoutCount(int timeoutCount) {
        this.timeoutCount = timeoutCount;
    }

    public void setInvocationState(PortletWindow.Action action, PortletRequestContext portletRequestContext, PortletResponseContext portletResponseContext, PortletRequest portletRequest, PortletResponse portletResponse, PortletInstance portletInstance) {
        if (!this.valid) {
            throw new IllegalStateException("Invalid window " + this.getId() + " should not have been invoked");
        }
        this.action = action;
        this.portletRequest = portletRequest;
        this.portletResponseContext = portletResponseContext;
        this.portletRequestContext = portletRequestContext;
        this.portletResponse = portletResponse;
        this.portletInstance = portletInstance;
    }

    public void clearInvocationState() {
        this.action = null;
        this.portletRequest = null;
        this.portletResponseContext = null;
        this.portletRequestContext = null;
        this.portletResponse = null;
        this.portletInstance = null;
    }

    public PortletWindow.Action getAction() {
        return this.action;
    }

    public PortletRequest getPortletRequest() {
        return this.portletRequest;
    }

    public PortletResponseContext getPortletResponseContext() {
        return this.portletResponseContext;
    }

    public PortletRequestContext getPortletRequestContext() {
        return this.portletRequestContext;
    }

    public PortletResponse getPortletResponse() {
        return this.portletResponse;
    }

    public PortletInstance getPortletInstance() {
        return this.portletInstance;
    }

    public List<KeyValue<String, HeadElement>> getHeadElements() {
        PortletContent portletContent;
        if (this.headElements == null && this.fragment != null && this.fragment.getPortletContent() != null && ((portletContent = this.fragment.getPortletContent()).isComplete() || !"portlet".equals(this.fragment.getType()))) {
            this.headElements = new TreeList();
            HeadElementsUtils.aggregateHeadElements(this.headElements, (ContentFragment)this.fragment);
            if (!this.headElements.isEmpty()) {
                HeadElementsUtils.mergeHeadElementsByHint(this.headElements);
            }
        }
        if (this.headElements == null) {
            return Collections.emptyList();
        }
        return this.headElements;
    }
}

