/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.jetspeed.om.portlet.DisplayName;
import org.apache.jetspeed.om.portlet.SecuredPortlet;
import org.apache.jetspeed.om.portlet.SecurityConstraint;
import org.apache.jetspeed.om.portlet.UserDataConstraint;
import org.apache.jetspeed.om.portlet.impl.DisplayNameImpl;
import org.apache.jetspeed.om.portlet.impl.SecuredPortletImpl;
import org.apache.jetspeed.om.portlet.impl.UserDataConstraintImpl;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.jetspeed.util.ojb.CollectionUtils;

public class SecurityConstraintImpl
implements SecurityConstraint,
Serializable {
    protected UserDataConstraintImpl userDataConstraints;
    protected List<SecuredPortlet> portletNames;
    protected List<DisplayName> displayNames;

    public DisplayName getDisplayName(Locale locale) {
        return (DisplayName)JetspeedLocale.getBestLocalizedObject(this.getDisplayNames(), (Locale)locale);
    }

    public List<DisplayName> getDisplayNames() {
        if (this.displayNames == null) {
            this.displayNames = CollectionUtils.createList();
        }
        return this.displayNames;
    }

    public DisplayName addDisplayName(String lang) {
        DisplayNameImpl d = new DisplayNameImpl(this, lang);
        for (DisplayName dn : this.getDisplayNames()) {
            if (!dn.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("DisplayName for language: " + d.getLocale() + " already defined");
        }
        this.displayNames.add(d);
        return d;
    }

    public List<String> getPortletNames() {
        if (this.portletNames == null) {
            this.portletNames = CollectionUtils.createList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (SecuredPortlet sp : this.portletNames) {
            result.add(sp.toString());
        }
        return result;
    }

    public void addPortletName(String portletName) {
        if (this.portletNames == null) {
            this.portletNames = CollectionUtils.createList();
        }
        for (SecuredPortlet sp : this.portletNames) {
            if (!sp.equals(portletName)) continue;
            throw new IllegalArgumentException("Support for security constraint portlet name with identifier: " + portletName + " already defined");
        }
        this.portletNames.add(new SecuredPortletImpl(portletName));
    }

    public UserDataConstraint getUserDataConstraint() {
        if (this.userDataConstraints == null) {
            this.userDataConstraints = new UserDataConstraintImpl();
        }
        return this.userDataConstraints;
    }
}

