/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.components.portletpreferences.JetspeedPreferenceImpl;
import org.apache.jetspeed.components.portletpreferences.PortletPreferencesProvider;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.serializer.AbstractJetspeedComponentSerializer;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSApplication;
import org.apache.jetspeed.serializer.objects.JSApplications;
import org.apache.jetspeed.serializer.objects.JSEntities;
import org.apache.jetspeed.serializer.objects.JSEntity;
import org.apache.jetspeed.serializer.objects.JSEntityPreference;
import org.apache.jetspeed.serializer.objects.JSEntityPreferenceCompat;
import org.apache.jetspeed.serializer.objects.JSEntityPreferences;
import org.apache.jetspeed.serializer.objects.JSNVPElement;
import org.apache.jetspeed.serializer.objects.JSNVPElements;
import org.apache.jetspeed.serializer.objects.JSPortlet;
import org.apache.jetspeed.serializer.objects.JSPortlets;
import org.apache.jetspeed.serializer.objects.JSSnapshot;
import org.apache.pluto.container.PortletPreference;
import org.slf4j.Logger;

public class JetspeedRegistrySerializer
extends AbstractJetspeedComponentSerializer {
    protected PortletRegistry registry;
    protected PortletPreferencesProvider prefsProvider;
    protected SearchEngine searchEngine;

    public JetspeedRegistrySerializer(PortletRegistry registry, PortletPreferencesProvider prefsProvider, SearchEngine searchEngine) {
        this.registry = registry;
        this.prefsProvider = prefsProvider;
        this.searchEngine = searchEngine;
    }

    protected void processExport(JSSnapshot snapshot, Map<String, Object> settings, Logger log) throws SerializerException {
        if (JetspeedRegistrySerializer.isSettingSet(settings, (String)"process_user_preferences")) {
            log.info("collecting applications and entities");
            this.exportEntities(snapshot, settings, log);
        }
    }

    protected void processImport(JSSnapshot snapshot, Map<String, Object> settings, Logger log) throws SerializerException {
        if (JetspeedRegistrySerializer.isSettingSet(settings, (String)"process_user_preferences")) {
            log.info("creating entities");
            this.importEntities(snapshot, settings, log);
        }
    }

    protected void deleteData(Map<String, Object> settings, Logger log) throws SerializerException {
        if (JetspeedRegistrySerializer.isSettingSet(settings, (String)"process_user_preferences")) {
            log.info("deleting applications");
            try {
                for (PortletApplication pa : this.registry.getPortletApplications()) {
                    List portlets = pa.getPortlets();
                    List clones = pa.getClones();
                    if (this.searchEngine != null) {
                        ArrayList<PortletApplication> list = new ArrayList<PortletApplication>(portlets.size() + clones.size() + 1);
                        list.add(pa);
                        list.addAll(portlets);
                        list.addAll(clones);
                        this.searchEngine.remove(list);
                    }
                    this.registry.removeApplication(pa);
                }
            }
            catch (Exception e) {
                throw new SerializerException((Throwable)e);
            }
        }
    }

    private void importEntities(JSSnapshot snapshot, Map<String, Object> settings, Logger log) throws SerializerException {
        JSApplications applications = snapshot.getApplications();
        if (applications == null) {
            return;
        }
        boolean importAll = this.registry.getPortletApplications().isEmpty();
        if (!applications.isEmpty()) {
            for (JSApplication app : applications) {
                PortletApplication portletApp = this.registry.getPortletApplication(app.getName());
                if (portletApp == null && !importAll) continue;
                this.importPA(app, portletApp, settings, log);
            }
        }
    }

    void importPA(JSApplication app, PortletApplication pa, Map<String, Object> settings, Logger log) throws SerializerException {
        for (JSPortlet portlet : app.getPortlets()) {
            if (pa != null) {
                PortletDefinition pd = pa.getPortlet(portlet.getName());
                if (pd == null) continue;
                this.importPD(app, portlet, pd, settings, log);
                continue;
            }
            this.importPD(app, portlet, null, settings, log);
        }
    }

    private void importPD(JSApplication app, JSPortlet portlet, PortletDefinition pd, Map<String, Object> settings, Logger log) throws SerializerException {
        for (JSEntity entity : portlet.getEntities()) {
            this.importEntityPref(app, portlet, entity, pd, settings, log);
        }
    }

    private void importEntityPref(JSApplication app, JSPortlet portlet, JSEntity entity, PortletDefinition pd, Map<String, Object> settings, Logger log) {
        JSEntityPreferences preferences = entity.getEntityPreferences();
        if (preferences == null || preferences.size() == 0) {
            return;
        }
        try {
            Iterator it = preferences.iterator();
            while (it.hasNext()) {
                JSEntityPreference pref;
                HashMap<String, JetspeedPreferenceImpl> portletPreference = new HashMap<String, JetspeedPreferenceImpl>();
                Object preference = it.next();
                String userName = null;
                JSNVPElements preferenceElements = null;
                if (preference instanceof JSEntityPreference) {
                    pref = (JSEntityPreference)preference;
                    userName = pref.getPrincapalName();
                    preferenceElements = pref.getPreferences();
                } else if (preference instanceof JSEntityPreferenceCompat) {
                    pref = (JSEntityPreferenceCompat)preference;
                    userName = pref.getName();
                    preferenceElements = pref.getPreferences();
                }
                for (JSNVPElement element : preferenceElements.getValues()) {
                    if (element.getValues() == null) {
                        portletPreference.put(element.getKey(), new JetspeedPreferenceImpl(element.getKey(), new String[]{element.getValue()}, element.isReadOnly()));
                        continue;
                    }
                    portletPreference.put(element.getKey(), new JetspeedPreferenceImpl(element.getKey(), element.getValues(), element.isReadOnly()));
                }
                if (portletPreference.size() <= 0) continue;
                if (pd != null) {
                    this.prefsProvider.storePortletPreference(pd, entity.getId(), userName, portletPreference);
                    continue;
                }
                this.prefsProvider.storePortletPreference(app.getName(), portlet.getName(), entity.getId(), userName, portletPreference);
            }
        }
        catch (Exception e) {
            log.error("Error in importing ");
            return;
        }
    }

    private void exportEntities(JSSnapshot snapshot, Map<String, Object> settings, Logger log) throws SerializerException {
        Collection col = this.registry.getPortletApplications();
        if (col == null || col.size() == 0) {
            return;
        }
        Iterator list = null;
        try {
            list = col.iterator();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"registry", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                PortletApplication pa = (PortletApplication)list.next();
                JSApplication app = this.exportPA(pa, settings, log);
                if (app == null) continue;
                snapshot.getApplications().add((Object)app);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"PortletApplicationDefinition", e.getMessage()}), (Throwable)e);
            }
        }
    }

    private JSApplication exportPA(PortletApplication pa, Map<String, Object> settings, Logger log) throws SerializerException {
        JSApplication jsApplication = null;
        Iterator pi = pa.getPortlets().iterator();
        PortletDefinition pd = null;
        JSPortlets portlets = new JSPortlets();
        while (pi.hasNext()) {
            try {
                pd = (PortletDefinition)pi.next();
                JSPortlet p = this.exportPD(pd, settings, log);
                if (p != null) {
                    log.debug("--processed PA " + pa.getName() + " with pd=" + pd.getPortletName());
                    portlets.add((Object)p);
                    continue;
                }
                log.debug("--processed PA " + pa.getName() + " with NULL pd=" + pd.getPortletName());
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"PortletDefinition", e.getMessage()}), (Throwable)e);
            }
        }
        if (!portlets.isEmpty()) {
            jsApplication = new JSApplication();
            log.debug("--exporting PA " + pa.getName());
            jsApplication.setName(pa.getName());
            jsApplication.setPortlets(portlets);
        }
        return jsApplication;
    }

    private JSPortlet exportPD(PortletDefinition pd, Map<String, Object> settings, Logger log) throws SerializerException {
        JSPortlet jsPortlet = null;
        try {
            Set windowIds = this.prefsProvider.getPortletWindowIds(pd);
            if (windowIds == null || windowIds.size() == 0) {
                return null;
            }
            JSEntities entities = new JSEntities();
            for (String windowId : windowIds) {
                JSEntity jsEntity = this.exportEntityPref(pd, windowId, settings, log);
                if (jsEntity == null) continue;
                entities.add((Object)jsEntity);
            }
            if (!entities.isEmpty()) {
                jsPortlet = new JSPortlet();
                jsPortlet.setName(pd.getPortletName());
                jsPortlet.setEntities(entities);
                log.debug("-----exporting for PD=" + pd.getPortletName());
            }
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Entity", e.getMessage()}), (Throwable)e);
        }
        return jsPortlet;
    }

    JSEntity exportEntityPref(PortletDefinition definition, String windowId, Map<String, Object> settings, Logger log) {
        JSEntity jsEntity = null;
        jsEntity = new JSEntity();
        jsEntity.setId(windowId);
        JSEntityPreferences entityPreferences = new JSEntityPreferences();
        Set userNames = this.prefsProvider.getUserNames(definition, windowId);
        for (String userName : userNames) {
            Map userPreferences = this.prefsProvider.getUserPreferences(definition, windowId, userName);
            JSEntityPreference userPreference = new JSEntityPreference();
            userPreference.setPrincapalName(userName);
            Iterator preferences = userPreferences.keySet().iterator();
            JSNVPElements v = new JSNVPElements("preference");
            while (preferences.hasNext()) {
                String pKey = (String)preferences.next();
                PortletPreference portletPreference = (PortletPreference)userPreferences.get(pKey);
                JSNVPElement element = new JSNVPElement();
                element.setKey(pKey);
                element.setValues(portletPreference.getValues());
                element.setReadOnly(portletPreference.isReadOnly());
                v.add(element);
            }
            if (v.size() > 0) {
                userPreference.setPreferences(v);
                entityPreferences.add((Object)userPreference);
            }
            if (entityPreferences.isEmpty()) continue;
            log.debug("processed preferences for entity=" + windowId);
            jsEntity.setEntityPreferences(entityPreferences);
        }
        return jsEntity;
    }
}

