/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.util.List;
import java.util.Locale;
import javax.portlet.PortletMode;
import org.apache.jetspeed.om.portlet.CustomPortletMode;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.impl.DescriptionImpl;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.jetspeed.util.ojb.CollectionUtils;

public class CustomPortletModeImpl
implements CustomPortletMode {
    protected String customName;
    protected String mappedName;
    protected Boolean portalManaged;
    protected List<Description> descriptions;
    protected transient PortletMode customMode;
    protected transient PortletMode mappedMode;

    public void setPortletMode(String customName) {
        this.customName = customName.toLowerCase();
    }

    public void setMappedName(String mappedName) {
        if (this.mappedName != null || this.mappedMode != null) {
            throw new IllegalArgumentException("MappedName already set");
        }
        if (mappedName != null) {
            this.mappedName = mappedName.toLowerCase();
        }
    }

    public PortletMode getCustomMode() {
        if (this.customMode == null) {
            this.customMode = new PortletMode(this.customName);
        }
        return this.customMode;
    }

    public PortletMode getMappedMode() {
        if (this.mappedMode == null) {
            this.mappedMode = this.mappedName != null ? new PortletMode(this.mappedName) : this.getCustomMode();
        }
        return this.mappedMode;
    }

    public int hashCode() {
        return this.customName != null ? this.customName.hashCode() : super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CustomPortletModeImpl) {
            return this.customName.equals(((CustomPortletModeImpl)object).customName);
        }
        return false;
    }

    public Description getDescription(Locale locale) {
        return (Description)JetspeedLocale.getBestLocalizedObject(this.getDescriptions(), (Locale)locale);
    }

    public List<Description> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = CollectionUtils.createList();
        }
        return this.descriptions;
    }

    public Description addDescription(String lang) {
        DescriptionImpl d = new DescriptionImpl(this, lang);
        for (Description desc : this.getDescriptions()) {
            if (!desc.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("Description for language: " + d.getLocale() + " already defined");
        }
        this.descriptions.add(d);
        return d;
    }

    public String getPortletMode() {
        return this.customName;
    }

    public boolean isPortalManaged() {
        return this.portalManaged == null ? true : this.portalManaged;
    }

    public void setPortalManaged(boolean value) {
        this.portalManaged = value ? Boolean.TRUE : Boolean.FALSE;
    }
}

