/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletregistry;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.impl.EhCacheElementImpl;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryCacheObjectWrapper;
import org.apache.jetspeed.components.portletregistry.RegistryEventListener;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;

public class RegistryApplicationCache
implements ObjectCache {
    private static JetspeedCache oidCache;
    private static JetspeedCache nameCache;
    private static PortletRegistry registry;
    private static List listeners;

    public RegistryApplicationCache(PersistenceBroker broker, Properties props) {
    }

    public static synchronized void cacheInit(PortletRegistry r, JetspeedCache o, JetspeedCache n, List l) {
        registry = r;
        oidCache = o;
        nameCache = n;
        listeners = l;
    }

    public Object lookup(Identity oid) {
        return RegistryApplicationCache.cacheLookup(oid);
    }

    public static synchronized Object cacheLookup(Identity oid) {
        CacheElement element = oidCache.get((Object)oid);
        if (element != null) {
            return element.getContent();
        }
        return null;
    }

    public void cache(Identity oid, Object obj) {
        RegistryApplicationCache.cacheAdd(oid, obj);
    }

    public static synchronized void cacheAdd(Identity oid, Object obj) {
        oidCache.remove((Object)oid);
        EhCacheElementImpl entry = new EhCacheElementImpl((Serializable)oid, obj);
        oidCache.put((CacheElement)entry);
        PortletApplication pa = (PortletApplication)obj;
        RegistryCacheObjectWrapper wrapper = new RegistryCacheObjectWrapper(oid, pa.getName());
        nameCache.remove((Object)pa.getName());
        CacheElement nameEntry = nameCache.createElement((Object)pa.getName(), (Object)wrapper);
        nameCache.put(nameEntry);
        if (listeners != null) {
            for (int ix = 0; ix < listeners.size(); ++ix) {
                RegistryEventListener listener = (RegistryEventListener)listeners.get(ix);
                listener.applicationUpdated((PortletApplication)obj);
            }
        }
    }

    public void clear() {
        RegistryApplicationCache.cacheClear();
    }

    public static synchronized void cacheClear() {
        oidCache.clear();
        nameCache.clear();
    }

    public void remove(Identity oid) {
        RegistryApplicationCache.cacheRemove(oid);
    }

    public static synchronized void cacheRemove(Identity oid) {
        PortletApplication pd = (PortletApplication)RegistryApplicationCache.cacheLookup(oid);
        if (pd == null) {
            return;
        }
        oidCache.remove((Object)oid);
        nameCache.remove((Object)pd.getName());
        if (listeners != null) {
            for (int ix = 0; ix < listeners.size(); ++ix) {
                RegistryEventListener listener = (RegistryEventListener)listeners.get(ix);
                listener.applicationRemoved(pd);
            }
        }
    }

    public static synchronized void cacheRemoveQuiet(String key, RegistryCacheObjectWrapper w) {
        CacheElement cacheElement;
        RegistryCacheObjectWrapper wrapper = w;
        if (wrapper == null && (cacheElement = nameCache.get((Object)key)) != null) {
            wrapper = (RegistryCacheObjectWrapper)cacheElement.getContent();
        }
        if (wrapper == null) {
            return;
        }
        Identity oid = wrapper.getId();
        PortletApplication pd = (PortletApplication)RegistryApplicationCache.cacheLookup(oid);
        if (pd == null) {
            return;
        }
        oidCache.removeQuiet((Object)oid);
        nameCache.removeQuiet((Object)pd.getName());
    }

    static {
        listeners = null;
    }
}

