/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletpreferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletRequest;
import javax.portlet.PreferencesValidator;
import javax.portlet.ValidatorException;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.components.portletpreferences.DatabasePreference;
import org.apache.jetspeed.components.portletpreferences.DatabasePreferenceValue;
import org.apache.jetspeed.components.portletpreferences.JetspeedPreferenceImpl;
import org.apache.jetspeed.components.portletpreferences.JetspeedPreferencesMap;
import org.apache.jetspeed.components.portletpreferences.PortletPreferencesProvider;
import org.apache.jetspeed.components.portletpreferences.PreferencesException;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Preference;
import org.apache.jetspeed.om.portlet.Preferences;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletPreference;
import org.apache.pluto.container.PortletWindow;
import org.springframework.orm.ojb.support.PersistenceBrokerDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesServiceImpl
extends PersistenceBrokerDaoSupport
implements PortletPreferencesProvider {
    protected static final String DISCRIMINATOR_PORTLET = "portlet";
    protected static final String DISCRIMINATOR_ENTITY = "entity";
    protected static final String DISCRIMINATOR_USER = "user";
    protected static final String KEY_SEPARATOR = ":";
    protected static final String EMPTY_VALUE = "_";
    protected static final String DTYPE = "dtype";
    protected static final String APPLICATION_NAME = "applicationName";
    protected static final String PORTLET_NAME = "portletName";
    protected static final String ENTITY_ID = "entityId";
    protected static final String USER_NAME = "userName";
    private PortletFactory portletFactory;
    private JetspeedCache preferenceCache;
    private List<String> preloadedApplications = null;
    private boolean preloadEntities = false;
    private boolean useEntityPreferences = true;

    public boolean isUseEntityPreferences() {
        return this.useEntityPreferences;
    }

    public void setUseEntityPreferences(boolean useEntityPreferences) {
        this.useEntityPreferences = useEntityPreferences;
    }

    public PortletPreferencesServiceImpl(PortletFactory portletFactory, JetspeedCache preferenceCache) throws ClassNotFoundException {
        this.portletFactory = portletFactory;
        this.preferenceCache = preferenceCache;
    }

    public PortletPreferencesServiceImpl(PortletFactory portletFactory, JetspeedCache preferenceCache, List<String> apps, boolean preloadEntities) throws ClassNotFoundException {
        this(portletFactory, preferenceCache);
        this.preloadedApplications = apps;
        this.preloadEntities = preloadEntities;
    }

    public void init() {
    }

    public void destroy() {
        this.preferenceCache = null;
        this.preloadedApplications = null;
        this.preloadEntities = false;
    }

    public Map<String, PortletPreference> getDefaultPreferences(PortletWindow pw, PortletRequest request) throws PortletContainerException {
        org.apache.jetspeed.container.PortletWindow window = (org.apache.jetspeed.container.PortletWindow)pw;
        PortletDefinition pd = window.getPortletDefinition();
        String entityId = window.getPortletEntityId();
        Map<String, PortletPreference> defaultsMap = this.retrieveDefaultPreferences(pd);
        if (this.useEntityPreferences) {
            String portletName;
            JetspeedPreferencesMap entityMap = null;
            String appName = pd.getApplication().getName();
            String entityCacheKey = this.getEntityPreferenceKey(appName, portletName = pd.getPortletName(), entityId);
            CacheElement cachedEntity = this.preferenceCache.get((Object)entityCacheKey);
            entityMap = cachedEntity != null ? (JetspeedPreferencesMap)cachedEntity.getContent() : (JetspeedPreferencesMap)this.retrieveEntityPreferences(window);
            if (entityMap != null && entityMap.size() > 0) {
                JetspeedPreferencesMap mergedMap = new JetspeedPreferencesMap(defaultsMap);
                for (Map.Entry<String, PortletPreference> entry : entityMap.entrySet()) {
                    mergedMap.put(entry.getKey(), entry.getValue());
                }
                return mergedMap;
            }
        }
        return defaultsMap;
    }

    public Map<String, PortletPreference> getStoredPreferences(PortletWindow pw, PortletRequest request) throws PortletContainerException {
        String userName;
        org.apache.jetspeed.container.PortletWindow window = (org.apache.jetspeed.container.PortletWindow)pw;
        if (request.getPortletMode().equals((Object)JetspeedActions.EDIT_DEFAULTS_MODE)) {
            return this.retrieveEntityPreferences(window);
        }
        String string = userName = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
        if (userName == null) {
            userName = SubjectHelper.getPrincipal((Subject)window.getRequestContext().getSubject(), User.class).getName();
        }
        return this.retrieveUserPreferences(window, userName);
    }

    public Map<String, PortletPreference> retrieveUserPreferences(org.apache.jetspeed.container.PortletWindow window, String userName) {
        String entityId;
        String portletName;
        String appName = window.getPortletDefinition().getApplication().getName();
        String cacheKey = this.getUserPreferenceKey(appName, portletName = window.getPortletDefinition().getPortletName(), entityId = window.getPortletEntityId(), userName);
        CacheElement cachedElement = this.preferenceCache.get((Object)cacheKey);
        if (cachedElement != null) {
            JetspeedPreferencesMap map = (JetspeedPreferencesMap)cachedElement.getContent();
            return map;
        }
        JetspeedPreferencesMap map = new JetspeedPreferencesMap();
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_USER);
        c.addEqualTo(APPLICATION_NAME, (Object)appName);
        c.addEqualTo(PORTLET_NAME, (Object)portletName);
        c.addEqualTo(ENTITY_ID, (Object)entityId);
        c.addEqualTo(USER_NAME, (Object)userName);
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
        while (preferences.hasNext()) {
            DatabasePreference preference = (DatabasePreference)preferences.next();
            map.put(preference.getName(), (PortletPreference)new JetspeedPreferenceImpl(preference.getName(), preference.getValues(), preference.isReadOnly()));
        }
        this.preferenceCache.put(this.preferenceCache.createElement((Object)cacheKey, (Object)map));
        return map;
    }

    public void store(PortletWindow pw, PortletRequest request, Map<String, PortletPreference> map) throws PortletContainerException {
        String userName;
        org.apache.jetspeed.container.PortletWindow window = (org.apache.jetspeed.container.PortletWindow)pw;
        if (request.getPortletMode().equals((Object)JetspeedActions.EDIT_DEFAULTS_MODE)) {
            try {
                this.storeEntityPreferences(map, window);
            }
            catch (PreferencesException e) {
                throw new PortletContainerException((Throwable)e);
            }
            return;
        }
        String string = userName = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
        if (userName == null) {
            userName = SubjectHelper.getPrincipal((Subject)window.getRequestContext().getSubject(), User.class).getName();
        }
        try {
            this.storeUserPreferences(map, window, userName);
        }
        catch (PreferencesException e) {
            throw new PortletContainerException((Throwable)e);
        }
    }

    public void storeUserPreferences(Map<String, PortletPreference> map, org.apache.jetspeed.container.PortletWindow window, String userName) throws PreferencesException {
        try {
            DatabasePreferenceValue dbValue;
            String[] values;
            short index;
            DatabasePreference dbPref;
            String appName = window.getPortletDefinition().getApplication().getName();
            String portletName = window.getPortletDefinition().getPortletName();
            String entityId = window.getPortletEntityId();
            Criteria c = new Criteria();
            c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_USER);
            c.addEqualTo(APPLICATION_NAME, (Object)appName);
            c.addEqualTo(PORTLET_NAME, (Object)portletName);
            c.addEqualTo(ENTITY_ID, (Object)entityId);
            c.addEqualTo(USER_NAME, (Object)userName);
            QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
            HashMap<String, DatabasePreference> mergeMap = new HashMap<String, DatabasePreference>();
            LinkedList<DatabasePreference> deletes = new LinkedList<DatabasePreference>();
            LinkedList<DatabasePreference> updates = new LinkedList<DatabasePreference>();
            LinkedList<PortletPreference> inserts = new LinkedList<PortletPreference>();
            Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
            while (preferences.hasNext()) {
                DatabasePreference preference = (DatabasePreference)preferences.next();
                PortletPreference found = map.get(preference.getName());
                if (found == null) {
                    deletes.add(preference);
                } else if (this.isModified(preference, found)) {
                    updates.add(preference);
                }
                mergeMap.put(preference.getName(), preference);
            }
            for (PortletPreference preference : map.values()) {
                dbPref = (DatabasePreference)mergeMap.get(preference.getName());
                if (dbPref != null) continue;
                inserts.add(preference);
            }
            for (DatabasePreference dbPref2 : deletes) {
                this.getPersistenceBrokerTemplate().delete((Object)dbPref2);
            }
            for (PortletPreference preference : inserts) {
                dbPref = new DatabasePreference();
                dbPref.setDtype(DISCRIMINATOR_USER);
                dbPref.setApplicationName(appName);
                dbPref.setPortletName(portletName);
                dbPref.setEntityId(entityId);
                dbPref.setUserName(userName);
                dbPref.setName(preference.getName());
                dbPref.setReadOnly(preference.isReadOnly());
                index = 0;
                values = preference.getValues();
                if (values != null) {
                    for (String value : values) {
                        dbValue = new DatabasePreferenceValue();
                        dbValue.setIndex(index);
                        dbValue.setValue(value);
                        dbPref.getPreferenceValues().add(dbValue);
                        index = (short)(index + 1);
                    }
                }
                this.getPersistenceBrokerTemplate().store((Object)dbPref);
            }
            for (DatabasePreference dbPref2 : updates) {
                dbPref2.getPreferenceValues().clear();
                PortletPreference preference = map.get(dbPref2.getName());
                index = 0;
                values = preference.getValues();
                if (values != null) {
                    for (String value : values) {
                        dbValue = new DatabasePreferenceValue();
                        dbValue.setIndex(index);
                        dbValue.setValue(value);
                        index = (short)(index + 1);
                        dbPref2.getPreferenceValues().add(dbValue);
                    }
                }
                this.getPersistenceBrokerTemplate().store((Object)dbPref2);
            }
            String cacheKey = this.getUserPreferenceKey(appName, portletName, entityId, userName);
            this.preferenceCache.remove((Object)cacheKey);
        }
        catch (Throwable t) {
            throw new PreferencesException(t);
        }
    }

    public PreferencesValidator getPreferencesValidator(org.apache.pluto.container.om.portlet.PortletDefinition pd) throws ValidatorException {
        return this.portletFactory.getPreferencesValidator((PortletDefinition)pd);
    }

    private String getPortletPreferenceKey(String applicationName, String portletName) {
        return "portlet:" + applicationName + KEY_SEPARATOR + portletName;
    }

    private String getEntityPreferenceKey(String applicationName, String portletName, String entityId) {
        return "portlet:" + applicationName + KEY_SEPARATOR + portletName + KEY_SEPARATOR + entityId;
    }

    private String getUserPreferenceKey(String applicationName, String portletName, String entityId, String userName) {
        return "user:" + applicationName + KEY_SEPARATOR + portletName + KEY_SEPARATOR + entityId + KEY_SEPARATOR + userName;
    }

    public void preloadApplicationPreferences(String portletApplicationName) {
        JetspeedPreferencesMap map = new JetspeedPreferencesMap();
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo(APPLICATION_NAME, (Object)portletApplicationName);
        String previousPortletName = "";
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        query.addOrderByAscending(DTYPE);
        query.addOrderByAscending(APPLICATION_NAME);
        query.addOrderByAscending(PORTLET_NAME);
        Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
        while (preferences.hasNext()) {
            DatabasePreference preference = (DatabasePreference)preferences.next();
            if (preference.getPortletName().equals(previousPortletName)) {
                map = new JetspeedPreferencesMap();
                String defaultsCacheKey = this.getPortletPreferenceKey(portletApplicationName, preference.getPortletName());
                this.preferenceCache.put(this.preferenceCache.createElement((Object)defaultsCacheKey, (Object)map));
                previousPortletName = preference.getPortletName();
            }
            map.put(preference.getName(), (PortletPreference)new JetspeedPreferenceImpl(preference.getName(), preference.getValues(), preference.isReadOnly()));
        }
    }

    public void preloadUserPreferences() {
        JetspeedPreferencesMap map = new JetspeedPreferencesMap();
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_USER);
        String previousKey = "";
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        query.addOrderByAscending(DTYPE);
        query.addOrderByAscending(APPLICATION_NAME);
        query.addOrderByAscending(PORTLET_NAME);
        query.addOrderByAscending(ENTITY_ID);
        query.addOrderByAscending(USER_NAME);
        Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
        while (preferences.hasNext()) {
            DatabasePreference preference = (DatabasePreference)preferences.next();
            String cacheKey = this.getUserPreferenceKey(preference.getApplicationName(), preference.getPortletName(), preference.getEntityId(), preference.getUserName());
            if (!cacheKey.equals(previousKey)) {
                map = new JetspeedPreferencesMap();
                this.preferenceCache.put(this.preferenceCache.createElement((Object)cacheKey, (Object)map));
                previousKey = cacheKey;
            }
            map.put(preference.getName(), (PortletPreference)new JetspeedPreferenceImpl(preference.getName(), preference.getValues(), preference.isReadOnly()));
        }
    }

    public void preload() throws Exception {
        if (this.preloadedApplications != null) {
            for (String appName : this.preloadedApplications) {
                this.preloadApplicationPreferences(appName);
            }
        }
        if (this.preloadEntities) {
            this.preloadUserPreferences();
        }
    }

    public void storeDefaults(PortletApplication app) {
        for (PortletDefinition pd : app.getPortlets()) {
            this.storeDefaults(pd, (Preferences)null);
        }
    }

    public void storeDefaults(PortletDefinition pd, Preferences newprefs) {
        Preferences preferences = newprefs == null ? pd.getDescriptorPreferences() : newprefs;
        JetspeedPreferencesMap map = new JetspeedPreferencesMap();
        for (Preference preference : preferences.getPortletPreferences()) {
            map.put(preference.getName(), (PortletPreference)new JetspeedPreferenceImpl(preference.getName(), preference.getValues().toArray(new String[preference.getValues().size()]), preference.isReadOnly()));
        }
        this.storePortletPreference(pd, null, null, map);
    }

    public void storeDefaults(PortletDefinition pd, Preference preference) {
        String appName = pd.getApplication().getName();
        String portletName = pd.getPortletName();
        String preferenceName = preference.getName();
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo(APPLICATION_NAME, (Object)appName);
        c.addEqualTo(PORTLET_NAME, (Object)portletName);
        c.addEqualTo(ENTITY_ID, (Object)EMPTY_VALUE);
        c.addEqualTo(USER_NAME, (Object)EMPTY_VALUE);
        c.addEqualTo("name", (Object)preferenceName);
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        DatabasePreference dbPref = (DatabasePreference)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (dbPref == null) {
            dbPref = new DatabasePreference();
            dbPref.setDtype(DISCRIMINATOR_PORTLET);
            dbPref.setApplicationName(appName);
            dbPref.setPortletName(portletName);
            dbPref.setEntityId(EMPTY_VALUE);
            dbPref.setUserName(EMPTY_VALUE);
            dbPref.setName(preferenceName);
        }
        dbPref.setReadOnly(preference.isReadOnly());
        dbPref.getPreferenceValues().clear();
        short index = 0;
        for (String value : preference.getValues()) {
            DatabasePreferenceValue dbValue = new DatabasePreferenceValue();
            dbValue.setIndex(index);
            dbValue.setValue(value);
            dbPref.getPreferenceValues().add(dbValue);
            index = (short)(index + 1);
        }
        this.getPersistenceBrokerTemplate().store((Object)dbPref);
        String defaultsCacheKey = this.getPortletPreferenceKey(appName, portletName);
        CacheElement cacheElement = this.preferenceCache.get((Object)defaultsCacheKey);
        JetspeedPreferencesMap map = cacheElement != null ? (JetspeedPreferencesMap)cacheElement.getContent() : new JetspeedPreferencesMap();
        map.put(preferenceName, (PortletPreference)new JetspeedPreferenceImpl(preferenceName, dbPref.getValues(), dbPref.isReadOnly()));
        this.preferenceCache.put(this.preferenceCache.createElement((Object)defaultsCacheKey, (Object)map));
    }

    public Map<String, PortletPreference> retrieveEntityPreferences(org.apache.jetspeed.container.PortletWindow window) {
        JetspeedPreferencesMap entityMap = new JetspeedPreferencesMap();
        List fragmentPrefs = window.getFragment().getPreferences();
        if (fragmentPrefs != null && fragmentPrefs.size() > 0) {
            entityMap = new JetspeedPreferencesMap();
            for (FragmentPreference fragmentPref : fragmentPrefs) {
                String[] entityValues = new String[fragmentPref.getValueList().size()];
                int ix = 0;
                for (Object value : fragmentPref.getValueList()) {
                    entityValues[ix] = (String)value;
                    ++ix;
                }
                entityMap.put(fragmentPref.getName(), (PortletPreference)new JetspeedPreferenceImpl(fragmentPref.getName(), entityValues, fragmentPref.isReadOnly()));
            }
        }
        return entityMap;
    }

    public void storeEntityPreferences(Map<String, PortletPreference> map, org.apache.jetspeed.container.PortletWindow window) throws PreferencesException {
        for (Map.Entry<String, PortletPreference> entry : map.entrySet()) {
            PortletDefinition pd = window.getPortletDefinition();
            String entityId = window.getPortletEntityId();
            String appName = pd.getApplication().getName();
            String portletName = pd.getPortletName();
            String entityCacheKey = this.getEntityPreferenceKey(appName, portletName, entityId);
            this.preferenceCache.remove((Object)entityCacheKey);
        }
        try {
            ContentFragment fragment = window.getFragment();
            fragment.updatePreferences(map);
        }
        catch (Exception e) {
            throw new PreferencesException((Throwable)e);
        }
    }

    public void removeDefaults(PortletDefinition pd) {
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo(APPLICATION_NAME, (Object)pd.getApplication().getName());
        c.addEqualTo(PORTLET_NAME, (Object)pd.getPortletName());
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
        String defaultsCacheKey = this.getPortletPreferenceKey(pd.getApplication().getName(), pd.getPortletName());
        this.preferenceCache.remove((Object)defaultsCacheKey);
    }

    public void removeDefaults(PortletDefinition pd, String preferenceName) {
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo(APPLICATION_NAME, (Object)pd.getApplication().getName());
        c.addEqualTo(PORTLET_NAME, (Object)pd.getPortletName());
        c.addEqualTo("name", (Object)preferenceName);
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
        String defaultsCacheKey = this.getPortletPreferenceKey(pd.getApplication().getName(), pd.getPortletName());
        JetspeedPreferencesMap map = (JetspeedPreferencesMap)this.preferenceCache.get((Object)defaultsCacheKey).getContent();
        map.remove(preferenceName);
        this.preferenceCache.put(this.preferenceCache.createElement((Object)defaultsCacheKey, (Object)map));
    }

    public void removeDefaults(PortletApplication app) {
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo(APPLICATION_NAME, (Object)app.getName());
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
        for (PortletDefinition pd : app.getPortlets()) {
            String defaultsCacheKey = this.getPortletPreferenceKey(pd.getApplication().getName(), pd.getPortletName());
            this.preferenceCache.remove((Object)defaultsCacheKey);
        }
    }

    public Map<String, PortletPreference> retrieveDefaultPreferences(PortletDefinition pd) {
        JetspeedPreferencesMap defaultsMap;
        String portletName;
        String appName = pd.getApplication().getName();
        String defaultsCacheKey = this.getPortletPreferenceKey(appName, portletName = pd.getPortletName());
        CacheElement cachedDefaults = this.preferenceCache.get((Object)defaultsCacheKey);
        if (cachedDefaults != null) {
            defaultsMap = (JetspeedPreferencesMap)cachedDefaults.getContent();
        } else {
            JetspeedPreferencesMap map = new JetspeedPreferencesMap();
            Criteria c = new Criteria();
            c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_PORTLET);
            c.addEqualTo(APPLICATION_NAME, (Object)appName);
            c.addEqualTo(PORTLET_NAME, (Object)portletName);
            QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
            Collection preferenceList = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            for (DatabasePreference preference : preferenceList) {
                if (EMPTY_VALUE.equals(preference.getEntityId())) continue;
                map.put(preference.getName(), (PortletPreference)new JetspeedPreferenceImpl(preference.getName(), preference.getValues(), preference.isReadOnly()));
            }
            for (DatabasePreference preference : preferenceList) {
                if (!EMPTY_VALUE.equals(preference.getEntityId())) continue;
                map.put(preference.getName(), (PortletPreference)new JetspeedPreferenceImpl(preference.getName(), preference.getValues(), preference.isReadOnly()));
            }
            this.preferenceCache.put(this.preferenceCache.createElement((Object)defaultsCacheKey, (Object)map));
            defaultsMap = map;
        }
        return defaultsMap;
    }

    public Set<String> getPortletWindowIds(PortletDefinition portletdefinition) {
        TreeSet<String> windowsId = new TreeSet<String>();
        String appName = portletdefinition.getApplication().getName();
        String portletName = portletdefinition.getPortletName();
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_USER);
        c.addEqualTo(APPLICATION_NAME, (Object)appName);
        c.addEqualTo(PORTLET_NAME, (Object)portletName);
        c.addNotEqualTo((Object)ENTITY_ID, (Object)EMPTY_VALUE);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DatabasePreference.class, (Criteria)c);
        query.setAttributes(new String[]{ENTITY_ID, "id"});
        Iterator ObjectwindowsId = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (ObjectwindowsId.hasNext()) {
            windowsId.add((String)((Object[])ObjectwindowsId.next())[0]);
        }
        return windowsId;
    }

    public Map<String, PortletPreference> getUserPreferences(PortletDefinition portletdefinition, String windowId, String userName) {
        String portletName;
        JetspeedPreferencesMap userPreferences = new JetspeedPreferencesMap();
        String appName = portletdefinition.getApplication().getName();
        String userCacheKey = this.getUserPreferenceKey(appName, portletName = portletdefinition.getPortletName(), windowId, userName);
        CacheElement cachedDefaults = this.preferenceCache.get((Object)userCacheKey);
        if (cachedDefaults != null) {
            userPreferences = (JetspeedPreferencesMap)cachedDefaults.getContent();
        } else {
            Criteria c = new Criteria();
            c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_USER);
            c.addEqualTo(APPLICATION_NAME, (Object)appName);
            c.addEqualTo(PORTLET_NAME, (Object)portletName);
            c.addEqualTo(USER_NAME, (Object)userName);
            c.addEqualTo(ENTITY_ID, (Object)windowId);
            QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
            Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
            while (preferences.hasNext()) {
                DatabasePreference preference = (DatabasePreference)preferences.next();
                userPreferences.put(preference.getName(), (PortletPreference)new JetspeedPreferenceImpl(preference.getName(), preference.getValues(), preference.isReadOnly()));
            }
            this.preferenceCache.put(this.preferenceCache.createElement((Object)userCacheKey, (Object)userPreferences));
        }
        return userPreferences;
    }

    public Set<String> getUserNames(PortletDefinition portletdefinition, String windowId) {
        TreeSet<String> userNames = new TreeSet<String>();
        String appName = portletdefinition.getApplication().getName();
        String portletName = portletdefinition.getPortletName();
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_USER);
        c.addEqualTo(APPLICATION_NAME, (Object)appName);
        c.addEqualTo(PORTLET_NAME, (Object)portletName);
        c.addEqualTo(ENTITY_ID, (Object)windowId);
        c.addNotEqualTo((Object)USER_NAME, (Object)EMPTY_VALUE);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DatabasePreference.class, (Criteria)c);
        query.setAttributes(new String[]{USER_NAME, "id"});
        query.setDistinct(true);
        Iterator userObjects = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (userObjects.hasNext()) {
            userNames.add((String)((Object[])userObjects.next())[0]);
        }
        return userNames;
    }

    public void storePortletPreference(PortletDefinition portletdefinition, String windowId, String userName, Map<String, PortletPreference> map) {
        String appName = portletdefinition.getApplication().getName();
        String portletName = portletdefinition.getPortletName();
        this.storePortletPreference(appName, portletName, windowId, userName, map);
    }

    private boolean isModified(DatabasePreference dbPref, PortletPreference pref) {
        String[] dbValues = dbPref.getValues();
        String[] values = pref.getValues();
        if (dbValues == null || values == null) {
            return true;
        }
        if (dbValues.length != values.length) {
            return true;
        }
        for (int ix = 0; ix < values.length; ++ix) {
            if (values[ix].equals(dbValues[ix])) continue;
            return true;
        }
        return false;
    }

    public void storePortletPreference(String appName, String portletName, String windowId, String userName, Map<String, PortletPreference> map) {
        short index;
        DatabasePreference dbPref;
        Criteria c = new Criteria();
        c.addEqualTo(DTYPE, (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo(APPLICATION_NAME, (Object)appName);
        c.addEqualTo(PORTLET_NAME, (Object)portletName);
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        HashMap<String, DatabasePreference> mergeMap = new HashMap<String, DatabasePreference>();
        LinkedList<DatabasePreference> deletes = new LinkedList<DatabasePreference>();
        LinkedList<DatabasePreference> updates = new LinkedList<DatabasePreference>();
        LinkedList<PortletPreference> inserts = new LinkedList<PortletPreference>();
        Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
        while (preferences.hasNext()) {
            DatabasePreference preference = (DatabasePreference)preferences.next();
            PortletPreference found = map.get(preference.getName());
            if (found == null) {
                deletes.add(preference);
            } else if (this.isModified(preference, found)) {
                updates.add(preference);
            }
            mergeMap.put(preference.getName(), preference);
        }
        for (PortletPreference preference : map.values()) {
            dbPref = (DatabasePreference)mergeMap.get(preference.getName());
            if (dbPref != null) continue;
            inserts.add(preference);
        }
        for (DatabasePreference dbPref2 : deletes) {
            this.getPersistenceBrokerTemplate().delete((Object)dbPref2);
        }
        for (PortletPreference preference : inserts) {
            dbPref = new DatabasePreference();
            dbPref.setDtype(DISCRIMINATOR_PORTLET);
            dbPref.setApplicationName(appName);
            dbPref.setPortletName(portletName);
            dbPref.setEntityId(windowId);
            dbPref.setUserName(userName);
            dbPref.setName(preference.getName());
            dbPref.setReadOnly(preference.isReadOnly());
            index = 0;
            String[] values = preference.getValues();
            if (values != null) {
                for (String value : values) {
                    DatabasePreferenceValue dbValue = new DatabasePreferenceValue();
                    dbValue.setIndex(index);
                    dbValue.setValue(value);
                    dbPref.getPreferenceValues().add(dbValue);
                    index = (short)(index + 1);
                }
            }
            this.getPersistenceBrokerTemplate().store((Object)dbPref);
        }
        for (DatabasePreference dbPref2 : updates) {
            dbPref2.getPreferenceValues().clear();
            PortletPreference preference = map.get(dbPref2.getName());
            index = 0;
            for (String value : preference.getValues()) {
                DatabasePreferenceValue dbValue = new DatabasePreferenceValue();
                dbValue.setIndex(index);
                dbValue.setValue(value);
                index = (short)(index + 1);
                dbPref2.getPreferenceValues().add(dbValue);
            }
            this.getPersistenceBrokerTemplate().store((Object)dbPref2);
        }
        String cacheKey = this.getPortletPreferenceKey(appName, portletName);
        this.preferenceCache.remove((Object)cacheKey);
    }
}

