/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletentity;

import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.container.PortletEntity;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.portlet.PortletDefinition;

public class PortletEntityImpl
implements PortletEntity {
    private static PortletRegistry registry;
    private Long oid;
    private String id;
    private PortletWindow portletWindow = null;
    private PortletDefinition portletDefinition = null;
    protected String portletName;
    protected String appName;
    private ContentFragment fragment;

    public PortletEntityImpl(ContentFragment fragment) {
        this.setFragment(fragment);
    }

    public PortletEntityImpl() {
    }

    public String getId() {
        return this.id;
    }

    public Long getOid() {
        return this.oid;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPortletWindow(PortletWindow window) {
        this.portletWindow = window;
    }

    public PortletWindow getPortletWindow() {
        return this.portletWindow;
    }

    public PortletDefinition getPortletDefinition() {
        if (this.portletDefinition == null) {
            PortletDefinition pd = registry.getPortletDefinitionByUniqueName(this.getPortletUniqueName());
            if (pd != null) {
                this.setPortletDefinition(pd);
            } else {
                return null;
            }
        }
        return this.portletDefinition;
    }

    public void setPortletDefinition(PortletDefinition pd) {
        if (pd == null) {
            throw new IllegalArgumentException("Cannot pass a null PortletDefinition to a PortletEntity.");
        }
        this.portletDefinition = pd;
        this.appName = this.portletDefinition.getApplication().getName();
        this.portletName = this.portletDefinition.getPortletName();
    }

    public String getPortletUniqueName() {
        if (this.appName != null && this.portletName != null) {
            return this.appName + "::" + this.portletName;
        }
        if (this.fragment != null) {
            return this.fragment.getName();
        }
        return null;
    }

    public ContentFragment getFragment() {
        return this.fragment;
    }

    public void setFragment(ContentFragment fragment) {
        this.fragment = fragment;
    }

    protected String getEntityFragmentKey() {
        String entityId = this.getId() == null ? "-unknown-entity" : this.getId().toString();
        return "org.apache.jetspeed" + entityId;
    }

    public static void setPortletRegistry(PortletRegistry registry) {
        PortletEntityImpl.registry = registry;
    }
}

