/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletentity;

import java.rmi.server.UID;
import java.util.Collection;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletentity.PortletEntityImpl;
import org.apache.jetspeed.components.portletentity.PortletEntityNotDeletedException;
import org.apache.jetspeed.components.portletentity.PortletEntityNotGeneratedException;
import org.apache.jetspeed.components.portletentity.PortletEntityNotStoredException;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.container.PortletEntity;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.springframework.orm.ojb.support.PersistenceBrokerDaoSupport;

public class PersistenceBrokerPortletEntityAccess
extends PersistenceBrokerDaoSupport
implements PortletEntityAccessComponent {
    private PortletRegistry registry;
    boolean mergeSharedPreferences = false;

    public PersistenceBrokerPortletEntityAccess(PortletRegistry registry) {
        this(registry, false);
    }

    public PersistenceBrokerPortletEntityAccess(PortletRegistry registry, boolean mergeSharedPreferences) {
        this.registry = registry;
        this.mergeSharedPreferences = mergeSharedPreferences;
    }

    public PortletEntity generateEntityFromFragment(ContentFragment fragment) throws PortletEntityNotGeneratedException {
        PortletDefinition pd = this.registry.getPortletDefinitionByUniqueName(fragment.getName());
        String entityKey = this.generateEntityKey(fragment);
        PortletEntity portletEntity = null;
        if (pd != null) {
            portletEntity = this.newPortletEntityInstance(pd);
            if (portletEntity == null) {
                throw new PortletEntityNotGeneratedException("Failed to create Portlet Entity for " + fragment.getName());
            }
        } else {
            String msg = "Failed to retrieve Portlet Definition for " + fragment.getName();
            this.logger.warn((Object)msg);
            portletEntity = new PortletEntityImpl(fragment);
            fragment.overrideRenderedContent(msg);
        }
        portletEntity.setId(entityKey);
        return portletEntity;
    }

    public String generateEntityKey(ContentFragment fragment) {
        return fragment.getId();
    }

    public Collection getPortletEntities(PortletDefinition portletDefinition) {
        Criteria c = new Criteria();
        String appName = portletDefinition.getApplication().getName();
        String portletName = portletDefinition.getPortletName();
        c.addEqualTo("appName", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PortletEntityImpl.class, (Criteria)c));
    }

    public Collection getPortletEntities(String portletUniqueName) {
        String[] split = portletUniqueName.split("::");
        String appName = split[0];
        String portletName = split[1];
        Criteria c = new Criteria();
        c.addEqualTo("appName", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PortletEntityImpl.class, (Criteria)c));
    }

    public PortletEntity getPortletEntity(String id) {
        try {
            return this.getPortletEntity(id, null);
        }
        catch (PortletEntityNotStoredException e) {
            IllegalStateException ise = new IllegalStateException("Unexepected error while retrieving portlet entity " + id);
            ise.initCause(e);
            throw ise;
        }
    }

    protected PortletEntity getPortletEntity(String id, ContentFragment fragment) throws PortletEntityNotStoredException {
        Criteria c = new Criteria();
        c.addEqualTo("id", (Object)id.toString());
        QueryByCriteria q = QueryFactory.newQuery(PortletEntityImpl.class, (Criteria)c);
        PortletEntity portletEntity = (PortletEntity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)q);
        if (portletEntity == null) {
            return null;
        }
        String portletUniqueName = portletEntity.getPortletUniqueName();
        PortletDefinition parentPortletDef = this.registry.getPortletDefinitionByUniqueName(portletUniqueName);
        if (parentPortletDef != null) {
            if (fragment != null && !portletUniqueName.equals(fragment.getName())) {
                parentPortletDef = this.registry.getPortletDefinitionByUniqueName(fragment.getName());
                portletEntity.setPortletDefinition(parentPortletDef);
                this.storePortletEntity(portletEntity);
            } else {
                portletEntity.setPortletDefinition(parentPortletDef);
            }
        } else if (fragment != null && parentPortletDef == null && (parentPortletDef = this.registry.getPortletDefinitionByUniqueName(fragment.getName())) != null) {
            portletEntity.setPortletDefinition(parentPortletDef);
            this.storePortletEntity(portletEntity);
        }
        if (parentPortletDef == null) {
            String msg = "Portlet " + portletUniqueName + " not found";
            String content = fragment.getOverriddenContent();
            if (content == null || !content.equals(msg)) {
                fragment.overrideRenderedContent(msg);
                this.logger.error((Object)msg);
            }
        }
        return portletEntity;
    }

    public PortletEntity getPortletEntityForFragment(ContentFragment fragment) throws PortletEntityNotStoredException {
        return this.getPortletEntity(this.generateEntityKey(fragment), fragment);
    }

    public PortletEntity newPortletEntityInstance(PortletDefinition portletDefinition) {
        return this.newPortletEntityInstance(portletDefinition, this.autoGenerateID(portletDefinition));
    }

    public PortletEntity newPortletEntityInstance(PortletDefinition portletDefinition, String id) {
        PortletEntityImpl portletEntity = new PortletEntityImpl();
        portletEntity.setPortletDefinition(portletDefinition);
        portletEntity.setId(id);
        return portletEntity;
    }

    public void removeFromCache(PortletEntity entity) {
    }

    public void removePortletEntities(PortletDefinition portletDefinition) throws PortletEntityNotDeletedException {
        for (PortletEntity entity : this.getPortletEntities(portletDefinition)) {
            this.removePortletEntity(entity);
        }
    }

    public void removePortletEntity(PortletEntity portletEntity) throws PortletEntityNotDeletedException {
        this.getPersistenceBrokerTemplate().delete((Object)portletEntity);
        this.removeFromCache(portletEntity);
    }

    public void updatePortletEntity(PortletEntity portletEntity, ContentFragment fragment) throws PortletEntityNotStoredException {
        if (!fragment.getId().equals(portletEntity.getId().toString())) {
            throw new PortletEntityNotStoredException("Fragment and PortletEntity ids do not match, update skipped: " + fragment.getId() + " != " + portletEntity.getId());
        }
        PortletDefinition pd = this.registry.getPortletDefinitionByUniqueName(fragment.getName());
        if (pd == null) {
            throw new PortletEntityNotStoredException("Fragment PortletDefinition not found: " + fragment.getName());
        }
        ((PortletEntityImpl)portletEntity).setPortletDefinition(pd);
    }

    public void storePortletEntity(PortletEntity portletEntity) throws PortletEntityNotStoredException {
        try {
            this.getPersistenceBrokerTemplate().store((Object)portletEntity);
        }
        catch (Exception e) {
            throw new PortletEntityNotStoredException("Failed to store portlet Entity: " + e.toString(), (Throwable)e);
        }
    }

    protected String autoGenerateID(PortletDefinition pd) {
        String appName = pd.getApplication().getName();
        String portletName = pd.getPortletName();
        return appName + "::" + portletName + "::" + new UID().toString();
    }

    public boolean isMergeSharedPreferences() {
        return this.mergeSharedPreferences;
    }
}

