/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.filter.PortletFilter;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.DisplayName;
import org.apache.jetspeed.om.portlet.Filter;
import org.apache.jetspeed.om.portlet.FilterLifecycle;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.impl.DescriptionImpl;
import org.apache.jetspeed.om.portlet.impl.DisplayNameImpl;
import org.apache.jetspeed.om.portlet.impl.FilterLifecycleImpl;
import org.apache.jetspeed.om.portlet.impl.InitParamImpl;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.jetspeed.util.ojb.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterImpl
implements Filter,
Serializable {
    protected String filterName;
    protected String filterClass;
    protected List<FilterLifecycle> lifecycles;
    protected List<InitParam> initParams;
    protected List<Description> descriptions;
    protected List<DisplayName> displayNames;
    protected PortletFilter filterInstance;

    public Description getDescription(Locale locale) {
        return (Description)JetspeedLocale.getBestLocalizedObject(this.getDescriptions(), (Locale)locale);
    }

    public List<Description> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = CollectionUtils.createList();
        }
        return this.descriptions;
    }

    public Description addDescription(String lang) {
        DescriptionImpl d = new DescriptionImpl(this, lang);
        for (Description desc : this.getDescriptions()) {
            if (!desc.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("Description for language: " + d.getLocale() + " already defined");
        }
        this.descriptions.add(d);
        return d;
    }

    public DisplayName getDisplayName(Locale locale) {
        return (DisplayName)JetspeedLocale.getBestLocalizedObject(this.getDisplayNames(), (Locale)locale);
    }

    public List<DisplayName> getDisplayNames() {
        if (this.displayNames == null) {
            this.displayNames = CollectionUtils.createList();
        }
        return this.displayNames;
    }

    public DisplayName addDisplayName(String lang) {
        DisplayNameImpl d = new DisplayNameImpl(this, lang);
        for (DisplayName dn : this.getDisplayNames()) {
            if (!dn.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("DisplayName for language: " + d.getLocale() + " already defined");
        }
        this.displayNames.add(d);
        return d;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String value) {
        this.filterName = value;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String value) {
        this.filterClass = value;
    }

    public List<String> getLifecycles() {
        if (this.lifecycles == null) {
            this.lifecycles = CollectionUtils.createList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (FilterLifecycle flc : this.lifecycles) {
            result.add(flc.toString());
        }
        return result;
    }

    public void addLifecycle(String name) {
        if (this.lifecycles == null) {
            this.lifecycles = CollectionUtils.createList();
        }
        for (FilterLifecycle flc : this.lifecycles) {
            if (!flc.equals(name)) continue;
            throw new IllegalArgumentException("Support for filter lifecycle parameter with identifier: " + name + " already defined");
        }
        this.lifecycles.add(new FilterLifecycleImpl(name));
    }

    public InitParam getInitParam(String name) {
        for (InitParam param : this.getInitParams()) {
            if (!param.getParamName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public List<InitParam> getInitParams() {
        if (this.initParams == null) {
            this.initParams = CollectionUtils.createList();
        }
        return this.initParams;
    }

    public InitParam addInitParam(String paramName) {
        if (this.getInitParam(paramName) != null) {
            throw new IllegalArgumentException("Init parameter: " + paramName + " already defined");
        }
        InitParamImpl param = new InitParamImpl(this, paramName);
        this.getInitParams();
        this.initParams.add(param);
        return param;
    }
}

