/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletregistry;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.impl.EhCacheElementImpl;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryCacheObjectWrapper;
import org.apache.jetspeed.components.portletregistry.RegistryEventListener;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;

public class RegistryPortletCache
implements ObjectCache {
    private static JetspeedCache oidCache;
    private static JetspeedCache nameCache;
    private static PortletRegistry registry;
    private static List listeners;

    public RegistryPortletCache(PersistenceBroker broker, Properties props) {
    }

    public static synchronized void cacheInit(PortletRegistry r, JetspeedCache o, JetspeedCache n, List l) {
        registry = r;
        oidCache = o;
        nameCache = n;
        listeners = l;
    }

    public Object lookup(Identity oid) {
        return RegistryPortletCache.cacheLookup(oid);
    }

    public static synchronized Object cacheLookup(Identity oid) {
        CacheElement element = oidCache.get((Object)oid);
        if (element != null) {
            return element.getContent();
        }
        return null;
    }

    public void cache(Identity oid, Object obj) {
        RegistryPortletCache.cacheAdd(oid, obj);
    }

    public static synchronized void cacheAdd(Identity oid, Object obj) {
        oidCache.remove((Object)oid);
        EhCacheElementImpl entry = new EhCacheElementImpl((Serializable)oid, obj);
        oidCache.put((CacheElement)entry);
        PortletDefinition pd = (PortletDefinition)obj;
        RegistryCacheObjectWrapper wrapper = new RegistryCacheObjectWrapper(oid, pd.getUniqueName());
        nameCache.remove((Object)pd.getUniqueName());
        CacheElement nameEntry = nameCache.createElement((Object)pd.getUniqueName(), (Object)wrapper);
        nameCache.put(nameEntry);
        if (listeners != null) {
            for (int ix = 0; ix < listeners.size(); ++ix) {
                RegistryEventListener listener = (RegistryEventListener)listeners.get(ix);
                listener.portletUpdated((PortletDefinition)obj);
            }
        }
    }

    public void clear() {
        RegistryPortletCache.cacheClear();
    }

    public static synchronized void cacheClear() {
        oidCache.clear();
        nameCache.clear();
    }

    public void remove(Identity oid) {
        RegistryPortletCache.cacheRemove(oid);
    }

    public static synchronized void cacheRemove(Identity oid) {
        PortletDefinition pd = (PortletDefinition)RegistryPortletCache.cacheLookup(oid);
        if (pd == null) {
            return;
        }
        oidCache.remove((Object)oid);
        nameCache.remove((Object)pd.getUniqueName());
        if (listeners != null) {
            for (int ix = 0; ix < listeners.size(); ++ix) {
                RegistryEventListener listener = (RegistryEventListener)listeners.get(ix);
                listener.portletRemoved(pd);
            }
        }
    }

    public static synchronized void cacheRemoveQuiet(String key, RegistryCacheObjectWrapper w) {
        RegistryCacheObjectWrapper wrapper = w;
        if (wrapper == null && (wrapper = (RegistryCacheObjectWrapper)nameCache.get((Object)key)) == null) {
            return;
        }
        Identity oid = wrapper.getId();
        PortletDefinition pd = (PortletDefinition)RegistryPortletCache.cacheLookup(oid);
        if (pd == null) {
            return;
        }
        oidCache.removeQuiet((Object)oid);
        nameCache.removeQuiet((Object)pd.getUniqueName());
    }

    static {
        listeners = null;
    }
}

