/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.PublicRenderParameter;
import org.apache.jetspeed.om.portlet.impl.DescriptionImpl;
import org.apache.jetspeed.om.portlet.impl.ParameterAliasImpl;
import org.apache.jetspeed.util.JetspeedLocale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicRenderParameterImpl
implements PublicRenderParameter,
Serializable {
    private static final long serialVersionUID = 1L;
    private String localPart;
    private String prefix;
    private String namespace;
    protected String identifier;
    protected List<ParameterAliasImpl> aliases;
    protected List<Description> descriptions;

    public PublicRenderParameterImpl() {
    }

    public PublicRenderParameterImpl(String name, String identifier) {
        this.localPart = name;
        this.identifier = identifier;
    }

    public PublicRenderParameterImpl(QName qname) {
        this.namespace = qname.getNamespaceURI();
        if (this.namespace != null && this.namespace.equals("")) {
            this.namespace = null;
        }
        this.prefix = qname.getPrefix();
        if (this.prefix != null && this.prefix.equals("")) {
            this.prefix = null;
        }
        this.localPart = qname.getLocalPart();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String value) {
        this.identifier = value;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public QName getQName() {
        if (this.namespace == null) {
            return new QName(this.localPart);
        }
        if (this.prefix == null) {
            return new QName(this.namespace, this.localPart);
        }
        return new QName(this.namespace, this.localPart, this.prefix);
    }

    public void setQName(QName qname) {
        this.namespace = qname.getNamespaceURI();
        if (this.namespace != null && this.namespace.equals("")) {
            this.namespace = null;
        }
        this.prefix = qname.getPrefix();
        if (this.prefix != null && this.prefix.equals("")) {
            this.prefix = null;
        }
        this.localPart = qname.getLocalPart();
    }

    public boolean equals(Object o) {
        String i2;
        if (!(o instanceof PublicRenderParameter)) {
            return false;
        }
        PublicRenderParameter param = (PublicRenderParameter)o;
        String i1 = param.getIdentifier() == null ? "" : param.getIdentifier();
        String string = i2 = this.identifier == null ? "" : this.identifier;
        if (i1.equals(i2)) {
            return true;
        }
        return this.toString().equals(param.toString());
    }

    public String toString() {
        return (this.getNamespace() == null ? "" : this.getNamespace() + "//:") + (this.getPrefix() == null ? "" : this.getPrefix() + ":") + (this.getLocalPart() == null ? "" : this.getLocalPart());
    }

    public String getName() {
        return this.localPart;
    }

    public void setName(String name) {
        this.localPart = name;
        this.prefix = null;
        this.namespace = null;
    }

    public List<QName> getAliases() {
        ArrayList<QName> result = new ArrayList<QName>();
        if (this.aliases != null) {
            for (ParameterAliasImpl qname : this.aliases) {
                result.add(qname.getQName());
            }
        }
        return result;
    }

    public void addAlias(QName alias) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<ParameterAliasImpl>();
        }
        if (!this.containsAlias(alias)) {
            this.aliases.add(new ParameterAliasImpl(alias));
        }
    }

    protected boolean containsAlias(QName qname) {
        ParameterAliasImpl alias = new ParameterAliasImpl(qname);
        for (ParameterAliasImpl p : this.aliases) {
            if (!((Object)p).equals(alias)) continue;
            return true;
        }
        return false;
    }

    public Description getDescription(Locale locale) {
        return (Description)JetspeedLocale.getBestLocalizedObject(this.getDescriptions(), (Locale)locale);
    }

    public List<Description> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<Description>();
        }
        return this.descriptions;
    }

    public Description addDescription(String lang) {
        DescriptionImpl d = new DescriptionImpl(this, lang);
        for (Description desc : this.getDescriptions()) {
            if (!desc.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("Description for language: " + d.getLocale() + " already defined");
        }
        this.descriptions.add(d);
        return d;
    }
}

