/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.LocalizedField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericMetadataImpl
implements GenericMetadata {
    private Collection<LocalizedField> fields = null;
    private transient MultiValueMap fieldMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiValueMap getFieldMap(boolean create) {
        if (this.fieldMap == null && create) {
            GenericMetadataImpl genericMetadataImpl = this;
            synchronized (genericMetadataImpl) {
                if (this.fieldMap == null) {
                    this.fieldMap = new MultiValueMap();
                }
            }
        }
        return this.fieldMap;
    }

    public void addField(Locale locale, String name, String value) {
        LocalizedField field = this.createLocalizedField();
        field.setName(name);
        field.setValue(value);
        field.setLocale(locale);
        this.addField(field);
    }

    public void addField(LocalizedField field) {
        if (this.fields == null) {
            this.fields = new ArrayList<LocalizedField>();
        }
        this.fields.add(field);
        this.getFieldMap(true).put((Object)field.getName(), (Object)field);
    }

    public Collection<LocalizedField> getFields(String name) {
        MultiValueMap fieldMap = this.getFieldMap(false);
        return (Collection)(fieldMap != null ? fieldMap.get((Object)name) : null);
    }

    public void setFields(String name, Collection<LocalizedField> values) {
        MultiValueMap fieldMap = this.getFieldMap(false);
        if (fieldMap != null) {
            fieldMap.remove((Object)name);
        }
        Iterator<LocalizedField> fieldIter = this.fields.iterator();
        while (fieldIter.hasNext()) {
            LocalizedField field = fieldIter.next();
            if (field == null || field.getName() == null || !field.getName().equals(name)) continue;
            fieldIter.remove();
        }
        if (values != null) {
            for (LocalizedField field : values) {
                this.getFieldMap(true).put((Object)field.getName(), (Object)field);
            }
            this.fields.addAll(values);
        }
    }

    public Collection<LocalizedField> getFields() {
        return this.fields;
    }

    public void setFields(Collection<LocalizedField> fields) {
        this.fields = fields;
        MultiValueMap fieldMap = this.getFieldMap(false);
        if (fieldMap != null) {
            fieldMap.clear();
        }
        if (fields != null) {
            for (LocalizedField field : fields) {
                if (field.getName() == null) continue;
                this.getFieldMap(true).put((Object)field.getName(), (Object)field);
            }
        }
    }

    public void copyFields(Collection<LocalizedField> fields) {
        MultiValueMap fieldMap;
        if (this.fields != null && !this.fields.isEmpty()) {
            if (fields != null) {
                this.fields.retainAll(fields);
            } else {
                this.fields = null;
            }
        }
        if (fields != null && !fields.isEmpty()) {
            if (this.fields == null) {
                this.fields = new ArrayList<LocalizedField>();
            }
            for (LocalizedField field : fields) {
                if (this.fields.contains(field)) continue;
                this.addField(field.getLocale(), field.getName(), field.getValue());
            }
        }
        if ((fieldMap = this.getFieldMap(false)) != null) {
            fieldMap.clear();
        }
        if (this.fields != null) {
            for (LocalizedField field : this.fields) {
                this.getFieldMap(true).put((Object)field.getName(), (Object)field);
            }
        }
    }
}

