/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletpreferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletRequest;
import javax.portlet.PreferencesValidator;
import javax.portlet.ValidatorException;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.components.portletpreferences.DatabasePreference;
import org.apache.jetspeed.components.portletpreferences.DatabasePreferenceValue;
import org.apache.jetspeed.components.portletpreferences.JetspeedPreferenceImpl;
import org.apache.jetspeed.components.portletpreferences.JetspeedPreferencesMap;
import org.apache.jetspeed.components.portletpreferences.PortletPreferencesProvider;
import org.apache.jetspeed.components.portletpreferences.PreferencesException;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.Preference;
import org.apache.jetspeed.om.portlet.Preferences;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletPreference;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.springframework.orm.ojb.support.PersistenceBrokerDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesServiceImpl
extends PersistenceBrokerDaoSupport
implements PortletPreferencesProvider {
    protected static final String DISCRIMINATOR_PORTLET = "portlet";
    protected static final String DISCRIMINATOR_ENTITY = "entity";
    protected static final String DISCRIMINATOR_USER = "user";
    protected static final String KEY_SEPARATOR = ":";
    protected static final String EMPTY_VALUE = "_";
    private PortletFactory portletFactory;
    private PageManager pageManager;
    private JetspeedCache preferenceCache;
    private List<String> preloadedApplications = null;
    private boolean preloadEntities = false;
    private boolean useEntityPreferences = true;

    public boolean isUseEntityPreferences() {
        return this.useEntityPreferences;
    }

    public void setUseEntityPreferences(boolean useEntityPreferences) {
        this.useEntityPreferences = useEntityPreferences;
    }

    public PortletPreferencesServiceImpl(PortletFactory portletFactory, JetspeedCache preferenceCache) throws ClassNotFoundException {
        this.portletFactory = portletFactory;
        this.preferenceCache = preferenceCache;
    }

    public PortletPreferencesServiceImpl(PortletFactory portletFactory, JetspeedCache preferenceCache, PageManager pageManager) throws ClassNotFoundException {
        this(portletFactory, preferenceCache);
        this.pageManager = pageManager;
    }

    public PortletPreferencesServiceImpl(PortletFactory portletFactory, JetspeedCache preferenceCache, PageManager pageManager, List<String> apps, boolean preloadEntities) throws ClassNotFoundException {
        this(portletFactory, preferenceCache, pageManager);
        this.preloadedApplications = apps;
        this.preloadEntities = preloadEntities;
    }

    public void destroy() {
        this.preferenceCache = null;
        this.preloadedApplications = null;
        this.preloadEntities = false;
    }

    public Map<String, PortletPreference> getDefaultPreferences(PortletWindow pw, PortletRequest request) throws PortletContainerException {
        org.apache.jetspeed.container.PortletWindow window = (org.apache.jetspeed.container.PortletWindow)pw;
        org.apache.jetspeed.om.portlet.PortletDefinition pd = window.getPortletDefinition();
        String entityId = window.getPortletEntityId();
        Map<String, PortletPreference> defaultsMap = this.retrieveDefaultPreferences(pd);
        if (this.useEntityPreferences) {
            String portletName;
            JetspeedPreferencesMap entityMap = null;
            String appName = pd.getApplication().getName();
            String entityCacheKey = this.getEntityPreferenceKey(appName, portletName = pd.getPortletName(), entityId);
            CacheElement cachedEntity = this.preferenceCache.get((Object)entityCacheKey);
            entityMap = cachedEntity != null ? (JetspeedPreferencesMap)cachedEntity.getContent() : (JetspeedPreferencesMap)this.retrieveEntityPreferences(window);
            if (entityMap != null && entityMap.size() > 0) {
                JetspeedPreferencesMap mergedMap = new JetspeedPreferencesMap(defaultsMap);
                for (Map.Entry<String, PortletPreference> entry : entityMap.entrySet()) {
                    mergedMap.put(entry.getKey(), entry.getValue());
                }
                return mergedMap;
            }
        }
        return defaultsMap;
    }

    public Map<String, PortletPreference> getStoredPreferences(PortletWindow pw, PortletRequest request) throws PortletContainerException {
        String userName;
        org.apache.jetspeed.container.PortletWindow window = (org.apache.jetspeed.container.PortletWindow)pw;
        if (request.getPortletMode().equals((Object)JetspeedActions.EDIT_DEFAULTS_MODE)) {
            return this.retrieveEntityPreferences(window);
        }
        String string = userName = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
        if (userName == null) {
            userName = SubjectHelper.getPrincipal((Subject)window.getRequestContext().getSubject(), User.class).getName();
        }
        return this.retrieveUserPreferences(window, userName);
    }

    public Map<String, PortletPreference> retrieveUserPreferences(org.apache.jetspeed.container.PortletWindow window, String userName) {
        String entityId;
        String portletName;
        String appName = window.getPortletDefinition().getApplication().getName();
        String cacheKey = this.getUserPreferenceKey(appName, portletName = window.getPortletDefinition().getPortletName(), entityId = window.getPortletEntityId(), userName);
        CacheElement cachedElement = this.preferenceCache.get((Object)cacheKey);
        if (cachedElement != null) {
            JetspeedPreferencesMap map = (JetspeedPreferencesMap)cachedElement.getContent();
            return map;
        }
        JetspeedPreferencesMap map = new JetspeedPreferencesMap();
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_USER);
        c.addEqualTo("applicationName", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        c.addEqualTo("entityId", (Object)entityId);
        c.addEqualTo("userName", (Object)userName);
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
        while (preferences.hasNext()) {
            DatabasePreference preference = (DatabasePreference)preferences.next();
            JetspeedPreferenceImpl value = new JetspeedPreferenceImpl(preference.getName(), preference.getValues());
            value.setReadOnly(preference.isReadOnly());
            map.put(preference.getName(), (PortletPreference)value);
        }
        this.preferenceCache.put(this.preferenceCache.createElement((Object)cacheKey, (Object)map));
        return map;
    }

    public void store(PortletWindow pw, PortletRequest request, Map<String, PortletPreference> map) throws PortletContainerException {
        String userName;
        org.apache.jetspeed.container.PortletWindow window = (org.apache.jetspeed.container.PortletWindow)pw;
        if (request.getPortletMode().equals((Object)JetspeedActions.EDIT_DEFAULTS_MODE)) {
            RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            try {
                this.storeEntityPreferences(map, rc.getPage(), window);
            }
            catch (PreferencesException e) {
                throw new PortletContainerException((Throwable)e);
            }
            return;
        }
        String string = userName = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
        if (userName == null) {
            userName = SubjectHelper.getPrincipal((Subject)window.getRequestContext().getSubject(), User.class).getName();
        }
        try {
            this.storeUserPreferences(map, window, userName);
        }
        catch (PreferencesException e) {
            throw new PortletContainerException((Throwable)e);
        }
    }

    public void storeUserPreferences(Map<String, PortletPreference> map, org.apache.jetspeed.container.PortletWindow window, String userName) throws PreferencesException {
        try {
            DatabasePreferenceValue dbValue;
            short index;
            DatabasePreference dbPref;
            String appName = window.getPortletDefinition().getApplication().getName();
            String portletName = window.getPortletDefinition().getPortletName();
            String entityId = window.getPortletEntityId();
            Criteria c = new Criteria();
            c.addEqualTo("dtype", (Object)DISCRIMINATOR_USER);
            c.addEqualTo("applicationName", (Object)appName);
            c.addEqualTo("portletName", (Object)portletName);
            c.addEqualTo("entityId", (Object)entityId);
            c.addEqualTo("userName", (Object)userName);
            QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
            HashMap<String, DatabasePreference> mergeMap = new HashMap<String, DatabasePreference>();
            LinkedList<DatabasePreference> deletes = new LinkedList<DatabasePreference>();
            LinkedList<DatabasePreference> updates = new LinkedList<DatabasePreference>();
            LinkedList<PortletPreference> inserts = new LinkedList<PortletPreference>();
            Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
            while (preferences.hasNext()) {
                DatabasePreference preference = (DatabasePreference)preferences.next();
                PortletPreference found = map.get(preference.getName());
                if (found == null) {
                    deletes.add(preference);
                } else {
                    updates.add(preference);
                }
                mergeMap.put(preference.getName(), preference);
            }
            for (PortletPreference preference : map.values()) {
                dbPref = (DatabasePreference)mergeMap.get(preference.getName());
                if (dbPref != null) continue;
                inserts.add(preference);
            }
            for (DatabasePreference dbPref2 : deletes) {
                this.getPersistenceBrokerTemplate().delete((Object)dbPref2);
            }
            for (PortletPreference preference : inserts) {
                dbPref = new DatabasePreference();
                dbPref.setDtype(DISCRIMINATOR_USER);
                dbPref.setApplicationName(appName);
                dbPref.setPortletName(portletName);
                dbPref.setEntityId(entityId);
                dbPref.setUserName(userName);
                dbPref.setName(preference.getName());
                dbPref.setReadOnly(preference.isReadOnly());
                index = 0;
                for (String value : preference.getValues()) {
                    dbValue = new DatabasePreferenceValue();
                    dbValue.setIndex(index);
                    dbValue.setValue(value);
                    dbPref.getPreferenceValues().add(dbValue);
                    index = (short)(index + 1);
                }
                this.getPersistenceBrokerTemplate().store((Object)dbPref);
            }
            for (DatabasePreference dbPref2 : updates) {
                dbPref2.getPreferenceValues().clear();
                PortletPreference preference = map.get(dbPref2.getName());
                index = 0;
                for (String value : preference.getValues()) {
                    dbValue = new DatabasePreferenceValue();
                    dbValue.setIndex(index);
                    dbValue.setValue(value);
                    index = (short)(index + 1);
                    dbPref2.getPreferenceValues().add(dbValue);
                }
                this.getPersistenceBrokerTemplate().store((Object)dbPref2);
            }
            String cacheKey = this.getUserPreferenceKey(appName, portletName, entityId, userName);
            this.preferenceCache.remove((Object)cacheKey);
        }
        catch (Throwable t) {
            throw new PreferencesException(t);
        }
    }

    public PreferencesValidator getPreferencesValidator(PortletDefinition pd) throws ValidatorException {
        return this.portletFactory.getPreferencesValidator((org.apache.jetspeed.om.portlet.PortletDefinition)pd);
    }

    private String getPorletPreferenceKey(String applicationName, String portletName) {
        return "portlet:" + applicationName + KEY_SEPARATOR + portletName;
    }

    private String getEntityPreferenceKey(String applicationName, String portletName, String entityId) {
        return "portlet:" + applicationName + KEY_SEPARATOR + portletName + KEY_SEPARATOR + entityId;
    }

    private String getUserPreferenceKey(String applicationName, String portletName, String entityId, String userName) {
        return "user:" + applicationName + KEY_SEPARATOR + portletName + KEY_SEPARATOR + entityId + KEY_SEPARATOR + userName;
    }

    public void preloadApplicationPreferences(String portletApplicationName) {
        JetspeedPreferencesMap map = new JetspeedPreferencesMap();
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo("applicationName", (Object)portletApplicationName);
        String previousPortletName = "";
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        query.addOrderByAscending("dtype");
        query.addOrderByAscending("applicationName");
        query.addOrderByAscending("portletName");
        Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
        while (preferences.hasNext()) {
            DatabasePreference preference = (DatabasePreference)preferences.next();
            if (preference.getPortletName().equals(previousPortletName)) {
                map = new JetspeedPreferencesMap();
                String defaultsCacheKey = this.getPorletPreferenceKey(portletApplicationName, preference.getPortletName());
                this.preferenceCache.put(this.preferenceCache.createElement((Object)defaultsCacheKey, (Object)map));
                previousPortletName = preference.getPortletName();
            }
            JetspeedPreferenceImpl value = new JetspeedPreferenceImpl(preference.getName(), preference.getValues());
            value.setReadOnly(preference.isReadOnly());
            map.put(preference.getName(), (PortletPreference)value);
        }
    }

    public void preloadUserPreferences() {
        JetspeedPreferencesMap map = new JetspeedPreferencesMap();
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_USER);
        String previousKey = "";
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        query.addOrderByAscending("dtype");
        query.addOrderByAscending("applicationName");
        query.addOrderByAscending("portletName");
        query.addOrderByAscending("entityId");
        query.addOrderByAscending("userName");
        Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
        while (preferences.hasNext()) {
            DatabasePreference preference = (DatabasePreference)preferences.next();
            String cacheKey = this.getUserPreferenceKey(preference.getApplicationName(), preference.getPortletName(), preference.getEntityId(), preference.getUserName());
            if (!cacheKey.equals(previousKey)) {
                map = new JetspeedPreferencesMap();
                this.preferenceCache.put(this.preferenceCache.createElement((Object)cacheKey, (Object)map));
                previousKey = cacheKey;
            }
            JetspeedPreferenceImpl value = new JetspeedPreferenceImpl(preference.getName(), preference.getValues());
            value.setReadOnly(preference.isReadOnly());
            map.put(preference.getName(), (PortletPreference)value);
        }
    }

    public void init() throws Exception {
        if (this.preloadedApplications != null) {
            for (String appName : this.preloadedApplications) {
                this.preloadApplicationPreferences(appName);
            }
        }
        if (this.preloadEntities) {
            this.preloadUserPreferences();
        }
    }

    public void storeDefaults(PortletApplication app) {
        for (org.apache.jetspeed.om.portlet.PortletDefinition pd : app.getPortlets()) {
            this.storeDefaults(pd);
        }
    }

    public void storeDefaults(org.apache.jetspeed.om.portlet.PortletDefinition pd) {
        Preferences preferences = pd.getDescriptorPreferences();
        String defaultsCacheKey = this.getPorletPreferenceKey(pd.getApplication().getName(), pd.getPortletName());
        JetspeedPreferencesMap map = new JetspeedPreferencesMap();
        for (Preference preference : preferences.getPortletPreferences()) {
            DatabasePreference dbPref = new DatabasePreference();
            dbPref.setDtype(DISCRIMINATOR_PORTLET);
            dbPref.setApplicationName(pd.getApplication().getName());
            dbPref.setPortletName(pd.getPortletName());
            dbPref.setEntityId(EMPTY_VALUE);
            dbPref.setUserName(EMPTY_VALUE);
            dbPref.setName(preference.getName());
            dbPref.setReadOnly(preference.isReadOnly());
            short index = 0;
            for (String value : preference.getValues()) {
                DatabasePreferenceValue dbValue = new DatabasePreferenceValue();
                dbValue.setIndex(index);
                dbValue.setValue(value);
                dbPref.getPreferenceValues().add(dbValue);
                index = (short)(index + 1);
            }
            JetspeedPreferenceImpl cached = new JetspeedPreferenceImpl(dbPref.getName(), dbPref.getValues());
            cached.setReadOnly(dbPref.isReadOnly());
            map.put(preference.getName(), (PortletPreference)cached);
            this.getPersistenceBrokerTemplate().store((Object)dbPref);
        }
        this.preferenceCache.put(this.preferenceCache.createElement((Object)defaultsCacheKey, (Object)map));
    }

    public void storeDefaults(org.apache.jetspeed.om.portlet.PortletDefinition pd, Preference preference) {
        String appName = pd.getApplication().getName();
        String portletName = pd.getPortletName();
        String preferenceName = preference.getName();
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo("applicationName", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        c.addEqualTo("entityId", (Object)EMPTY_VALUE);
        c.addEqualTo("userName", (Object)EMPTY_VALUE);
        c.addEqualTo("name", (Object)preferenceName);
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        DatabasePreference dbPref = (DatabasePreference)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (dbPref == null) {
            dbPref = new DatabasePreference();
            dbPref.setDtype(DISCRIMINATOR_PORTLET);
            dbPref.setApplicationName(appName);
            dbPref.setPortletName(portletName);
            dbPref.setEntityId(EMPTY_VALUE);
            dbPref.setUserName(EMPTY_VALUE);
            dbPref.setName(preferenceName);
        }
        dbPref.setReadOnly(preference.isReadOnly());
        dbPref.getPreferenceValues().clear();
        short index = 0;
        for (String value : preference.getValues()) {
            DatabasePreferenceValue dbValue = new DatabasePreferenceValue();
            dbValue.setIndex(index);
            dbValue.setValue(value);
            dbPref.getPreferenceValues().add(dbValue);
            index = (short)(index + 1);
        }
        this.getPersistenceBrokerTemplate().store((Object)dbPref);
        JetspeedPreferenceImpl cached = new JetspeedPreferenceImpl(preferenceName, dbPref.getValues());
        cached.setReadOnly(dbPref.isReadOnly());
        String defaultsCacheKey = this.getPorletPreferenceKey(appName, portletName);
        CacheElement cacheElement = this.preferenceCache.get((Object)defaultsCacheKey);
        JetspeedPreferencesMap map = cacheElement != null ? (JetspeedPreferencesMap)cacheElement.getContent() : new JetspeedPreferencesMap();
        map.put(preferenceName, (PortletPreference)cached);
        this.preferenceCache.put(this.preferenceCache.createElement((Object)defaultsCacheKey, (Object)map));
    }

    public Map<String, PortletPreference> retrieveEntityPreferences(org.apache.jetspeed.container.PortletWindow window) {
        JetspeedPreferencesMap entityMap = new JetspeedPreferencesMap();
        List fragmentPrefs = window.getFragment().getPreferences();
        if (fragmentPrefs.size() > 0) {
            entityMap = new JetspeedPreferencesMap();
            for (FragmentPreference fragmentPref : fragmentPrefs) {
                String[] entityValues = new String[fragmentPref.getValueList().size()];
                int ix = 0;
                for (Object value : fragmentPref.getValueList()) {
                    entityValues[ix] = (String)value;
                    ++ix;
                }
                JetspeedPreferenceImpl preference = new JetspeedPreferenceImpl(fragmentPref.getName(), entityValues);
                preference.setReadOnly(fragmentPref.isReadOnly());
                entityMap.put(fragmentPref.getName(), (PortletPreference)preference);
            }
        }
        return entityMap;
    }

    public void storeEntityPreferences(Map<String, PortletPreference> map, ContentPage page, org.apache.jetspeed.container.PortletWindow window) throws PreferencesException {
        ContentFragment fragment = window.getFragment();
        List fragmentPrefs = fragment.getPreferences();
        fragmentPrefs.clear();
        for (Map.Entry<String, PortletPreference> entry : map.entrySet()) {
            String name = entry.getKey();
            PortletPreference pref = entry.getValue();
            FragmentPreference fp = this.pageManager.newFragmentPreference();
            fp.setName(name);
            fp.setReadOnly(pref.isReadOnly());
            String[] values = pref.getValues();
            if (values != null) {
                List list = fp.getValueList();
                for (String value : values) {
                    list.add(value);
                }
            }
            fragmentPrefs.add(fp);
            org.apache.jetspeed.om.portlet.PortletDefinition pd = window.getPortletDefinition();
            String entityId = window.getPortletEntityId();
            String appName = pd.getApplication().getName();
            String portletName = pd.getPortletName();
            String entityCacheKey = this.getEntityPreferenceKey(appName, portletName, entityId);
            this.preferenceCache.remove((Object)entityCacheKey);
        }
        try {
            this.pageManager.updatePage((Page)page);
        }
        catch (Exception e) {
            throw new PreferencesException((Throwable)e);
        }
    }

    public void removeDefaults(org.apache.jetspeed.om.portlet.PortletDefinition pd) {
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo("applicationName", (Object)pd.getApplication().getName());
        c.addEqualTo("portletName", (Object)pd.getPortletName());
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
        String defaultsCacheKey = this.getPorletPreferenceKey(pd.getApplication().getName(), pd.getPortletName());
        this.preferenceCache.remove((Object)defaultsCacheKey);
    }

    public void removeDefaults(org.apache.jetspeed.om.portlet.PortletDefinition pd, String preferenceName) {
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo("applicationName", (Object)pd.getApplication().getName());
        c.addEqualTo("portletName", (Object)pd.getPortletName());
        c.addEqualTo("name", (Object)preferenceName);
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
        String defaultsCacheKey = this.getPorletPreferenceKey(pd.getApplication().getName(), pd.getPortletName());
        JetspeedPreferencesMap map = (JetspeedPreferencesMap)this.preferenceCache.get((Object)defaultsCacheKey).getContent();
        map.remove(preferenceName);
        this.preferenceCache.put(this.preferenceCache.createElement((Object)defaultsCacheKey, (Object)map));
    }

    public void removeDefaults(PortletApplication app) {
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_PORTLET);
        c.addEqualTo("applicationName", (Object)app.getName());
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
        for (org.apache.jetspeed.om.portlet.PortletDefinition pd : app.getPortlets()) {
            String defaultsCacheKey = this.getPorletPreferenceKey(pd.getApplication().getName(), pd.getPortletName());
            this.preferenceCache.remove((Object)defaultsCacheKey);
        }
    }

    public Map<String, PortletPreference> retrieveDefaultPreferences(org.apache.jetspeed.om.portlet.PortletDefinition pd) {
        JetspeedPreferencesMap defaultsMap;
        String portletName;
        String appName = pd.getApplication().getName();
        String defaultsCacheKey = this.getPorletPreferenceKey(appName, portletName = pd.getPortletName());
        CacheElement cachedDefaults = this.preferenceCache.get((Object)defaultsCacheKey);
        if (cachedDefaults != null) {
            defaultsMap = (JetspeedPreferencesMap)cachedDefaults.getContent();
        } else {
            JetspeedPreferencesMap map = new JetspeedPreferencesMap();
            Criteria c = new Criteria();
            c.addEqualTo("dtype", (Object)DISCRIMINATOR_PORTLET);
            c.addEqualTo("applicationName", (Object)appName);
            c.addEqualTo("portletName", (Object)portletName);
            QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
            Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
            while (preferences.hasNext()) {
                DatabasePreference preference = (DatabasePreference)preferences.next();
                JetspeedPreferenceImpl value = new JetspeedPreferenceImpl(preference.getName(), preference.getValues());
                value.setReadOnly(preference.isReadOnly());
                map.put(preference.getName(), (PortletPreference)value);
            }
            this.preferenceCache.put(this.preferenceCache.createElement((Object)defaultsCacheKey, (Object)map));
            defaultsMap = map;
        }
        return defaultsMap;
    }

    public Set<String> getPortletWindowIds(org.apache.jetspeed.om.portlet.PortletDefinition portletdefinition) {
        TreeSet<String> windowsId = new TreeSet<String>();
        String appName = portletdefinition.getApplication().getName();
        String portletName = portletdefinition.getPortletName();
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_USER);
        c.addEqualTo("applicationName", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        c.addNotEqualTo((Object)"entityId", (Object)EMPTY_VALUE);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DatabasePreference.class, (Criteria)c);
        query.setAttributes(new String[]{"entityId", "id"});
        Iterator ObjectwindowsId = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (ObjectwindowsId.hasNext()) {
            windowsId.add((String)((Object[])ObjectwindowsId.next())[0]);
        }
        return windowsId;
    }

    public Map<String, PortletPreference> getUserPreferences(org.apache.jetspeed.om.portlet.PortletDefinition portletdefinition, String windowId, String userName) {
        String portletName;
        JetspeedPreferencesMap userPreferences = new JetspeedPreferencesMap();
        String appName = portletdefinition.getApplication().getName();
        String userCacheKey = this.getUserPreferenceKey(appName, portletName = portletdefinition.getPortletName(), windowId, userName);
        CacheElement cachedDefaults = this.preferenceCache.get((Object)userCacheKey);
        if (cachedDefaults != null) {
            userPreferences = (JetspeedPreferencesMap)cachedDefaults.getContent();
        } else {
            Criteria c = new Criteria();
            c.addEqualTo("dtype", (Object)DISCRIMINATOR_USER);
            c.addEqualTo("applicationName", (Object)appName);
            c.addEqualTo("portletName", (Object)portletName);
            c.addEqualTo("userName", (Object)userName);
            c.addEqualTo("entityId", (Object)windowId);
            QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
            Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
            while (preferences.hasNext()) {
                DatabasePreference preference = (DatabasePreference)preferences.next();
                JetspeedPreferenceImpl value = new JetspeedPreferenceImpl(preference.getName(), preference.getValues());
                value.setReadOnly(preference.isReadOnly());
                userPreferences.put(preference.getName(), (PortletPreference)value);
            }
            this.preferenceCache.put(this.preferenceCache.createElement((Object)userCacheKey, (Object)userPreferences));
        }
        return userPreferences;
    }

    public Set<String> getUserNames(org.apache.jetspeed.om.portlet.PortletDefinition portletdefinition, String windowId) {
        TreeSet<String> userNames = new TreeSet<String>();
        String appName = portletdefinition.getApplication().getName();
        String portletName = portletdefinition.getPortletName();
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_USER);
        c.addEqualTo("applicationName", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        c.addEqualTo("entityId", (Object)windowId);
        c.addNotEqualTo((Object)"userName", (Object)EMPTY_VALUE);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(DatabasePreference.class, (Criteria)c);
        query.setAttributes(new String[]{"userName", "id"});
        query.setDistinct(true);
        Iterator userObjects = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (userObjects.hasNext()) {
            userNames.add((String)((Object[])userObjects.next())[0]);
        }
        return userNames;
    }

    public void storePortletPreference(org.apache.jetspeed.om.portlet.PortletDefinition portletdefinition, String windowId, String userName, Map<String, PortletPreference> map) {
        DatabasePreferenceValue dbValue;
        short index;
        DatabasePreference dbPref;
        String appName = portletdefinition.getApplication().getName();
        String portletName = portletdefinition.getPortletName();
        Criteria c = new Criteria();
        c.addEqualTo("dtype", (Object)DISCRIMINATOR_USER);
        c.addEqualTo("applicationName", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        c.addEqualTo("entityId", (Object)windowId);
        c.addEqualTo("userName", (Object)userName);
        QueryByCriteria query = QueryFactory.newQuery(DatabasePreference.class, (Criteria)c);
        HashMap<String, DatabasePreference> mergeMap = new HashMap<String, DatabasePreference>();
        LinkedList<DatabasePreference> deletes = new LinkedList<DatabasePreference>();
        LinkedList<DatabasePreference> updates = new LinkedList<DatabasePreference>();
        LinkedList<PortletPreference> inserts = new LinkedList<PortletPreference>();
        Iterator preferences = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
        while (preferences.hasNext()) {
            DatabasePreference preference = (DatabasePreference)preferences.next();
            PortletPreference found = map.get(preference.getName());
            if (found == null) {
                deletes.add(preference);
            } else {
                updates.add(preference);
            }
            mergeMap.put(preference.getName(), preference);
        }
        for (PortletPreference preference : map.values()) {
            dbPref = (DatabasePreference)mergeMap.get(preference.getName());
            if (dbPref != null) continue;
            inserts.add(preference);
        }
        for (DatabasePreference dbPref2 : deletes) {
            this.getPersistenceBrokerTemplate().delete((Object)dbPref2);
        }
        for (PortletPreference preference : inserts) {
            dbPref = new DatabasePreference();
            dbPref.setDtype(DISCRIMINATOR_USER);
            dbPref.setApplicationName(appName);
            dbPref.setPortletName(portletName);
            dbPref.setEntityId(windowId);
            dbPref.setUserName(userName);
            dbPref.setName(preference.getName());
            dbPref.setReadOnly(preference.isReadOnly());
            index = 0;
            for (String value : preference.getValues()) {
                dbValue = new DatabasePreferenceValue();
                dbValue.setIndex(index);
                dbValue.setValue(value);
                dbPref.getPreferenceValues().add(dbValue);
                index = (short)(index + 1);
            }
            this.getPersistenceBrokerTemplate().store((Object)dbPref);
        }
        for (DatabasePreference dbPref2 : updates) {
            dbPref2.getPreferenceValues().clear();
            PortletPreference preference = map.get(dbPref2.getName());
            index = 0;
            for (String value : preference.getValues()) {
                dbValue = new DatabasePreferenceValue();
                dbValue.setIndex(index);
                dbValue.setValue(value);
                index = (short)(index + 1);
                dbPref2.getPreferenceValues().add(dbValue);
            }
            this.getPersistenceBrokerTemplate().store((Object)dbPref2);
        }
        String cacheKey = this.getUserPreferenceKey(appName, portletName, windowId, userName);
        this.preferenceCache.remove((Object)cacheKey);
    }
}

