/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.preference.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.common.preference.PreferenceComposite;
import org.apache.jetspeed.om.impl.PreferenceDescriptionImpl;
import org.apache.pluto.om.common.Description;

public class PrefsPreference
implements PreferenceComposite {
    protected static final String VALUES_PATH = "values";
    protected static final String VALUES_SIZE = "size";
    public static final String PORTLET_PREFERENCES_ROOT = "preferences";
    protected static final String LOCALE_TOKEN = "_";
    protected Preferences prefValueNode;
    protected Preferences prefValueSizeNode;
    protected Preferences prefNode;
    protected String name;
    public static final String[] DEFAULT_OPEN_NODES = new String[]{"portlet_entity", "portlets"};

    public PrefsPreference(Preferences prefNode, String name) {
        this.prefNode = prefNode;
        if (prefNode == null) {
            throw new IllegalArgumentException("prefNode cannot be null for PrefsPreferences(Preference).");
        }
        this.name = name;
        if (this.name == null) {
            throw new IllegalArgumentException("Preference does requires a \"name\" property.");
        }
        this.prefValueNode = prefNode.node(VALUES_PATH);
        this.prefValueSizeNode = prefNode.node(VALUES_SIZE);
    }

    public PrefsPreference(PortletDefinitionComposite portlet, String name) {
        this(PrefsPreference.createPrefenceNode(portlet).node(name), name);
    }

    private int getPrefValueSize(boolean store) {
        int size = this.prefValueSizeNode.getInt(VALUES_SIZE, -1);
        if (size == -1) {
            try {
                size = this.prefValueNode.keys().length;
            }
            catch (BackingStoreException e) {
                String msg = "Preference backing store failed: " + e.toString();
                IllegalStateException ise = new IllegalStateException(msg);
                ise.initCause(e);
                throw ise;
            }
            if (store) {
                this.prefValueSizeNode.putInt(VALUES_SIZE, size);
            }
        }
        return size;
    }

    public void addDescription(Locale locale, String description) {
        String localePath = locale.toString();
        this.prefNode.node("description").put(localePath, description);
    }

    public Description getDescription(Locale locale) {
        String localePath = locale.toString();
        String value = this.prefNode.node("description").get(localePath, null);
        PreferenceDescriptionImpl desc = new PreferenceDescriptionImpl();
        desc.setDescription(value);
        desc.setLocale(locale);
        desc.setLanguage(locale.getLanguage());
        return desc;
    }

    public String getValueAt(int index) {
        return this.prefValueNode.get(String.valueOf(index), null);
    }

    public void removeValueAt(int index) {
        String[] values;
        int size;
        if (index > -1 && index < (size = this.getPrefValueSize(true))) {
            int i;
            values = new String[size - 1];
            for (i = 0; i < index; ++i) {
                values[i] = this.prefValueNode.get(String.valueOf(i), null);
            }
            for (i = index + 1; i < size; ++i) {
                values[i] = this.prefValueNode.get(String.valueOf(i), null);
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        this.setValues(values);
    }

    public void setValueAt(int index, String value) {
        if (index > -1) {
            int size = this.getPrefValueSize(true);
            if (index < size) {
                if (value != null) {
                    this.prefValueNode.put(String.valueOf(index), value);
                } else {
                    this.prefValueNode.remove(String.valueOf(index));
                }
            } else {
                this.prefValueSizeNode.putInt(VALUES_SIZE, index + 1);
                if (value != null) {
                    this.prefValueNode.put(String.valueOf(index), value);
                }
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public void addValue(String value) {
        int size = this.getPrefValueSize(true);
        this.prefValueSizeNode.putInt(VALUES_SIZE, size + 1);
        if (value != null) {
            this.prefValueNode.put(String.valueOf(size), value);
        }
    }

    public String[] getValueArray() {
        int size = this.getPrefValueSize(false);
        String[] values = new String[size];
        for (int i = 0; i < size; ++i) {
            values[i] = this.prefValueNode.get(String.valueOf(i), null);
        }
        return values;
    }

    public void setValues(String[] stringValues) {
        try {
            this.prefValueNode.clear();
            int size = stringValues != null ? stringValues.length : 0;
            this.prefValueSizeNode.putInt(VALUES_SIZE, size);
            for (int i = 0; i < size; ++i) {
                if (stringValues[i] == null) continue;
                this.prefValueNode.put(String.valueOf(i), stringValues[i]);
            }
        }
        catch (BackingStoreException e) {
            String msg = "Preference backing store failed: " + e.toString();
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(e);
            throw ise;
        }
    }

    public String getType() {
        return null;
    }

    public void setType(String string) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValues(List arg0) {
        if (arg0 != null) {
            this.setValues(arg0.toArray(new String[arg0.size()]));
        }
    }

    public void setReadOnly(String readOnly) {
        this.prefNode.put("read_only", readOnly);
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.prefNode.put("read_only", "true");
        } else {
            this.prefNode.put("read_only", "false");
        }
    }

    public String getName() {
        return this.name;
    }

    public Iterator getValues() {
        return Arrays.asList(this.getValueArray()).iterator();
    }

    public boolean isReadOnly() {
        return Boolean.valueOf(this.prefNode.get("read_only", "false"));
    }

    public boolean isValueSet() {
        return this.getPrefValueSize(false) > 0;
    }

    protected Locale parseLocal(String localString) {
        StringTokenizer lcTk = new StringTokenizer(localString, LOCALE_TOKEN);
        String lang = null;
        String country = null;
        String variant = null;
        while (lcTk.hasMoreTokens()) {
            if (lang == null) {
                lang = lcTk.nextToken();
                continue;
            }
            if (country == null) {
                country = lcTk.nextToken();
                continue;
            }
            if (variant != null) continue;
            variant = lcTk.nextToken();
        }
        return new Locale(lang, country, variant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] cloneValues() {
        String[] clonedValues;
        Preferences preferences = this.prefValueNode;
        synchronized (preferences) {
            String[] currentValues = this.getValueArray();
            clonedValues = new String[currentValues.length];
            System.arraycopy(currentValues, 0, clonedValues, 0, currentValues.length);
        }
        return clonedValues;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PrefsPreference && this.name != null) {
            PrefsPreference pref = (PrefsPreference)obj;
            return pref.name != null && this.name.equals(pref.name);
        }
        return false;
    }

    public int hashCode() {
        return (this.getClass().getName() + "::" + this.name).hashCode();
    }

    public String toString() {
        return "Preference{" + this.name + "} values=" + this.getValueArray().toString();
    }

    public void flush() throws BackingStoreException {
        this.prefValueNode.flush();
    }

    public Iterator getDescriptions() {
        try {
            Preferences descNode = this.prefNode.node("description");
            String[] keys = descNode.keys();
            ArrayList<PreferenceDescriptionImpl> descs = new ArrayList<PreferenceDescriptionImpl>(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                PreferenceDescriptionImpl desc = new PreferenceDescriptionImpl();
                String localeKey = keys[i];
                desc.setDescription(descNode.get(localeKey, null));
                Locale locale = this.parseLocal(localeKey);
                desc.setLocale(locale);
                desc.setLanguage(locale.getLanguage());
                descs.add(desc);
            }
            return descs.iterator();
        }
        catch (BackingStoreException e) {
            String msg = "Preference backing store failed: " + e.toString();
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(e);
            throw ise;
        }
    }

    public static Preferences createPrefenceNode(PortletDefinitionComposite portlet) {
        MutablePortletApplication app = (MutablePortletApplication)portlet.getPortletApplicationDefinition();
        if (app == null) {
            throw new IllegalArgumentException("createPrefencePath() requires a PortletDefinition whose Application is not null.");
        }
        String portletDefPrefPath = "portlet_application/" + app.getName() + "/" + "portlets" + "/" + portlet.getName() + "/" + PORTLET_PREFERENCES_ROOT;
        return Preferences.systemRoot().node(portletDefPrefPath);
    }
}

