/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.preference.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PreferencesValidator;
import org.apache.jetspeed.om.common.preference.PreferenceSetComposite;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.pluto.om.common.Preference;

public class FragmentPortletPreferenceSet
implements PreferenceSetComposite {
    private final PreferenceSetComposite preferenceSet;
    private final Map prefs;

    public FragmentPortletPreferenceSet(PreferenceSetComposite preferenceSet, Fragment fragment) {
        this.preferenceSet = preferenceSet;
        int prefsSize = preferenceSet.size() + 1;
        if (fragment != null && fragment.getPreferences() != null) {
            prefsSize += fragment.getPreferences().size();
        }
        this.prefs = new HashMap(prefsSize);
        Iterator iterator = preferenceSet.iterator();
        while (iterator.hasNext()) {
            Preference pref = (Preference)iterator.next();
            this.prefs.put(pref.getName(), pref);
        }
        if (fragment != null && fragment.getPreferences() != null) {
            Iterator itr = fragment.getPreferences().iterator();
            while (itr.hasNext()) {
                Preference pref = (Preference)itr.next();
                this.prefs.put(pref.getName(), pref);
            }
        }
    }

    public Preference add(String arg0, List arg1) {
        Preference pref = this.preferenceSet.add(arg0, arg1);
        this.prefs.put(arg0, pref);
        return pref;
    }

    public Preference get(String name) {
        return (Preference)this.prefs.get(name);
    }

    public Set getNames() {
        return this.prefs.keySet();
    }

    public PreferencesValidator getPreferencesValidator() {
        return this.preferenceSet.getPreferencesValidator();
    }

    public Iterator iterator() {
        return this.prefs.values().iterator();
    }

    public void remove(Preference pref) {
        this.prefs.remove(pref.getName());
        this.preferenceSet.remove(pref);
    }

    public Preference remove(String name) {
        Preference pref = (Preference)this.prefs.remove(name);
        this.preferenceSet.remove(name);
        return pref;
    }

    public int size() {
        return this.prefs.size();
    }
}

