/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.common.JetspeedServiceReference;
import org.apache.jetspeed.om.common.Support;
import org.apache.jetspeed.om.common.UserAttribute;
import org.apache.jetspeed.om.common.UserAttributeRef;
import org.apache.jetspeed.om.common.portlet.CustomPortletMode;
import org.apache.jetspeed.om.common.portlet.CustomWindowState;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.impl.UserAttributeImpl;
import org.apache.jetspeed.om.portlet.impl.PortletApplicationMetadataImpl;
import org.apache.jetspeed.om.portlet.impl.PortletDefinitionListImpl;
import org.apache.jetspeed.util.JetspeedLongObjectID;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.portlet.PortletDefinitionList;
import org.apache.pluto.om.servlet.WebApplicationDefinition;

public class PortletApplicationDefinitionImpl
implements MutablePortletApplication,
Serializable,
Support {
    private Long id;
    private JetspeedLongObjectID oid;
    private String name;
    private String version;
    private String applicationIdentifier;
    private transient WebApplicationDefinition webApplication;
    protected long webApplicationId;
    private Collection metadataFields = null;
    private Collection services = new ArrayList();
    private String description;
    private Collection portlets;
    private Collection userAttributeRefs;
    private Collection userAttributes;
    private PortletDefinitionListImpl listWrapper = new PortletDefinitionListImpl();
    private int applicationType = 0;
    private String checksum = "0";
    private long checksumLong = -1L;
    private List customPortletModes;
    private List customWindowStates;
    private String jetspeedSecurityConstraint = null;
    private transient Map supportedCustomModes;
    private transient Map supportedCustomStates;
    private transient Map mappedCustomModes;
    private transient Map mappedCustomStates;
    private transient Collection supportedPortletModes;
    private transient Collection supportedWindowStates;

    public PortletApplicationDefinitionImpl() {
        this.portlets = new ArrayList();
        this.userAttributes = new ArrayList();
        this.userAttributeRefs = new ArrayList();
        this.customPortletModes = new ArrayList();
        this.customWindowStates = new ArrayList();
    }

    public ObjectID getId() {
        if (this.oid == null && this.id != null) {
            this.oid = new JetspeedLongObjectID(this.id);
        }
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public WebApplicationDefinition getWebApplicationDefinition() {
        return this.webApplication;
    }

    public PortletDefinitionList getPortletDefinitionList() {
        return new PortletDefinitionListImpl(this.portlets);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setWebApplicationDefinition(WebApplicationDefinition wad) {
        this.webApplication = wad;
    }

    public void addPortletDefinition(PortletDefinition pd) {
        ((PortletDefinitionComposite)pd).setPortletApplicationDefinition((PortletApplicationDefinition)this);
        this.portlets.add(pd);
    }

    public Collection getPortletDefinitions() {
        return this.portlets;
    }

    public PortletDefinition getPortletDefinitionByName(String name) {
        this.listWrapper.setInnerCollection(this.portlets);
        return this.listWrapper.get(name);
    }

    public void setPortletDefinitionList(PortletDefinitionList portlets) {
        this.portlets = ((PortletDefinitionListImpl)portlets).getInnerCollection();
    }

    public void setUserAttributeRefs(Collection userAttributeRefs) {
        this.userAttributeRefs = userAttributeRefs;
    }

    public Collection getUserAttributeRefs() {
        return this.userAttributeRefs;
    }

    public void addUserAttributeRef(UserAttributeRef userAttributeRef) {
        this.userAttributeRefs.add(userAttributeRef);
    }

    public void addUserAttribute(UserAttribute userAttribute) {
        this.userAttributes.add(userAttribute);
    }

    public void addUserAttribute(String userName, String description) {
        UserAttributeImpl userAttribute = new UserAttributeImpl();
        userAttribute.setName(userName);
        userAttribute.setDescription(description);
        this.userAttributes.add(userAttribute);
    }

    public void setUserAttributes(Collection userAttributes) {
        this.userAttributes = userAttributes;
    }

    public Collection getUserAttributes() {
        return this.userAttributes;
    }

    public void setApplicationIdentifier(String applicationIdentifier) {
        this.applicationIdentifier = applicationIdentifier;
    }

    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public void setApplicationType(int type) {
        this.applicationType = type;
    }

    public int getApplicationType() {
        return this.applicationType;
    }

    public GenericMetadata getMetadata() {
        if (this.metadataFields == null) {
            this.metadataFields = new ArrayList();
        }
        PortletApplicationMetadataImpl metadata = new PortletApplicationMetadataImpl();
        metadata.setFields(this.metadataFields);
        return metadata;
    }

    public void setMetadata(GenericMetadata metadata) {
        this.metadataFields = metadata.getFields();
    }

    protected Collection getMetadataFields() {
        return this.metadataFields;
    }

    protected void setMetadataFields(Collection metadataFields) {
        this.metadataFields = metadataFields;
    }

    public Collection getJetspeedServices() {
        return this.services;
    }

    public void addJetspeedService(JetspeedServiceReference service) {
        this.services.add(service);
    }

    public long getChecksum() {
        if (this.checksumLong == -1L) {
            this.checksumLong = Long.parseLong(this.checksum);
        }
        return this.checksumLong;
    }

    public void setChecksum(long checksum) {
        this.checksumLong = checksum;
        this.checksum = Long.toString(checksum);
    }

    public void postLoad(Object parameter) throws Exception {
        Iterator portletDefinitions = this.getPortletDefinitions().iterator();
        while (portletDefinitions.hasNext()) {
            ((Support)portletDefinitions.next()).postLoad((Object)this);
        }
    }

    public Collection getCustomPortletModes() {
        return this.customPortletModes;
    }

    public void addCustomPortletMode(CustomPortletMode customPortletMode) {
        this.supportedPortletModes = null;
        this.supportedCustomModes = null;
        this.mappedCustomModes = null;
        if (!this.customPortletModes.contains(customPortletMode)) {
            this.customPortletModes.add(customPortletMode);
        }
    }

    public void setCustomPortletModes(Collection customPortletModes) {
        this.supportedPortletModes = null;
        this.supportedCustomModes = null;
        this.mappedCustomModes = null;
        this.customPortletModes.clear();
        if (customPortletModes != null) {
            this.customPortletModes.addAll(customPortletModes);
        }
    }

    public PortletMode getMappedPortletMode(PortletMode mode) {
        if (JetspeedActions.getStandardPortletModes().contains(mode)) {
            return mode;
        }
        if (this.getSupportedPortletModes().contains(mode)) {
            return (PortletMode)this.mappedCustomModes.get(mode);
        }
        return null;
    }

    public PortletMode getCustomPortletMode(PortletMode mode) {
        if (JetspeedActions.getStandardPortletModes().contains(mode)) {
            return mode;
        }
        if (JetspeedActions.getExtendedPortletModes().contains(mode)) {
            this.getSupportedPortletModes();
            return (PortletMode)this.supportedCustomModes.get(mode);
        }
        return null;
    }

    public Collection getSupportedPortletModes() {
        if (this.supportedPortletModes == null) {
            ArrayList<PortletMode> list = new ArrayList<PortletMode>(JetspeedActions.getStandardPortletModes());
            this.supportedCustomModes = new HashMap();
            this.mappedCustomModes = new HashMap();
            if (this.customPortletModes.size() > 0) {
                Iterator iter = this.customPortletModes.iterator();
                while (iter.hasNext()) {
                    CustomPortletMode customMode = (CustomPortletMode)iter.next();
                    if (list.contains(customMode.getCustomMode()) || !JetspeedActions.getExtendedPortletModes().contains(customMode.getMappedMode())) continue;
                    list.add(customMode.getCustomMode());
                    this.supportedCustomModes.put(customMode.getMappedMode(), customMode.getCustomMode());
                    this.mappedCustomModes.put(customMode.getCustomMode(), customMode.getMappedMode());
                }
            }
            this.supportedPortletModes = Collections.unmodifiableCollection(list);
        }
        return this.supportedPortletModes;
    }

    public Collection getCustomWindowStates() {
        return this.customWindowStates;
    }

    public void addCustomWindowState(CustomWindowState customWindowState) {
        this.supportedWindowStates = null;
        this.supportedCustomStates = null;
        this.mappedCustomStates = null;
        if (!this.customWindowStates.contains(customWindowState)) {
            this.customWindowStates.add(customWindowState);
        }
    }

    public void setCustomWindowStates(Collection customWindowStates) {
        this.supportedWindowStates = null;
        this.supportedCustomStates = null;
        this.mappedCustomStates = null;
        this.customWindowStates.clear();
        if (customWindowStates != null) {
            this.customWindowStates.addAll(customWindowStates);
        }
    }

    public WindowState getMappedWindowState(WindowState state) {
        if (JetspeedActions.getStandardWindowStates().contains(state)) {
            return state;
        }
        if (this.getSupportedWindowStates().contains(state)) {
            return (WindowState)this.mappedCustomStates.get(state);
        }
        return null;
    }

    public WindowState getCustomWindowState(WindowState state) {
        if (JetspeedActions.getStandardWindowStates().contains(state)) {
            return state;
        }
        if (JetspeedActions.getExtendedWindowStates().contains(state)) {
            this.getSupportedWindowStates();
            return (WindowState)this.supportedCustomStates.get(state);
        }
        return null;
    }

    public Collection getSupportedWindowStates() {
        if (this.supportedWindowStates == null) {
            ArrayList<WindowState> list = new ArrayList<WindowState>(JetspeedActions.getStandardWindowStates());
            this.supportedCustomStates = new HashMap();
            this.mappedCustomStates = new HashMap();
            if (this.customWindowStates.size() > 0) {
                Iterator iter = this.customWindowStates.iterator();
                while (iter.hasNext()) {
                    CustomWindowState customState = (CustomWindowState)iter.next();
                    if (list.contains(customState.getCustomState()) || !JetspeedActions.getExtendedWindowStates().contains(customState.getMappedState())) continue;
                    list.add(customState.getCustomState());
                    this.supportedCustomStates.put(customState.getMappedState(), customState.getCustomState());
                    this.mappedCustomStates.put(customState.getCustomState(), customState.getMappedState());
                }
            }
            this.supportedWindowStates = Collections.unmodifiableCollection(list);
        }
        return this.supportedWindowStates;
    }

    public String getJetspeedSecurityConstraint() {
        return this.jetspeedSecurityConstraint;
    }

    public void setJetspeedSecurityConstraint(String constraint) {
        this.jetspeedSecurityConstraint = constraint;
    }

    public boolean isLayoutApplication() {
        Collection c;
        return this.getMetadata() != null && (c = this.getMetadata().getFields("layout-app")) != null && !c.isEmpty();
    }
}

