/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.jetspeed.om.common.MutableLanguage;
import org.apache.jetspeed.om.common.Support;
import org.apache.jetspeed.om.impl.LanguageImpl;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.pluto.om.common.Language;
import org.apache.pluto.om.common.LanguageSet;

public class LanguageSetImpl
implements LanguageSet,
Serializable,
Support {
    private transient ClassLoader classLoader = null;
    private String resources;
    protected Collection innerCollection;

    public LanguageSetImpl(Collection collection) {
        this.innerCollection = collection;
    }

    public LanguageSetImpl() {
        this(Collections.synchronizedList(new ArrayList()));
    }

    public Iterator iterator() {
        return this.innerCollection.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getLocales() {
        HashSet<Locale> localSet = new HashSet<Locale>();
        Collection collection = this.innerCollection;
        synchronized (collection) {
            Iterator itr = this.innerCollection.iterator();
            while (itr.hasNext()) {
                Language lang = (Language)itr.next();
                localSet.add(lang.getLocale());
            }
        }
        return localSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language get(Locale locale) {
        LanguageImpl fallback = null;
        Collection collection = this.innerCollection;
        synchronized (collection) {
            Iterator searchItr = this.innerCollection.iterator();
            while (searchItr.hasNext()) {
                LanguageImpl lang = (LanguageImpl)searchItr.next();
                if (lang.getLocale().equals(locale)) {
                    if (this.resources != null && lang.getParentResourceBundle() == null) {
                        lang.setResourceBundle(this.loadResourceBundle(lang.getLocale()));
                    }
                    return lang;
                }
                if (!lang.getLocale().getLanguage().equals(locale.getLanguage())) continue;
                fallback = lang;
            }
        }
        if (fallback == null) {
            if (this.getDefaultLocale().equals(locale)) {
                LanguageImpl defaultLanguage = new LanguageImpl();
                defaultLanguage.setLocale(locale);
                if (this.resources != null) {
                    defaultLanguage.setResourceBundle(this.loadResourceBundle(locale));
                    defaultLanguage.loadDefaults();
                    this.innerCollection.add(defaultLanguage);
                    return defaultLanguage;
                }
            } else {
                fallback = (LanguageImpl)this.get(this.getDefaultLocale());
            }
        }
        LanguageImpl language = new LanguageImpl();
        language.setLocale(locale);
        language.setTitle(fallback.getTitle());
        language.setShortTitle(fallback.getShortTitle());
        language.setKeywords(fallback.getKeywordStr());
        if (this.resources != null) {
            language.setResourceBundle(this.loadResourceBundle(locale));
        }
        language.loadDefaults();
        this.innerCollection.add(language);
        return language;
    }

    public Locale getDefaultLocale() {
        return JetspeedLocale.getDefaultLocale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        if (o instanceof Language) {
            Language language = (Language)o;
            if (language.getLocale() == null) {
                ((MutableLanguage)o).setLocale(this.getDefaultLocale());
            }
            Collection collection = this.innerCollection;
            synchronized (collection) {
                Iterator ite = this.innerCollection.iterator();
                while (ite.hasNext()) {
                    Language lang = (Language)ite.next();
                    if (!lang.equals(language)) continue;
                    this.innerCollection.remove(lang);
                    return this.innerCollection.add(o);
                }
            }
            return this.innerCollection.add(o);
        }
        return false;
    }

    public Collection getInnerCollection() {
        return this.innerCollection;
    }

    public void setInnerCollection(Collection collection) {
        this.innerCollection = collection;
    }

    public int size() {
        return this.innerCollection.size();
    }

    public void setResources(String string) {
        this.resources = string;
    }

    public void postLoad(Object parameter) throws Exception {
        LanguageImpl language;
        Iterator iter = ((Collection)parameter).iterator();
        while (iter.hasNext()) {
            language = (LanguageImpl)this.get((Locale)iter.next());
            language.loadDefaults();
        }
        language = (LanguageImpl)this.get(this.getDefaultLocale());
        language.loadDefaults();
    }

    protected ResourceBundle loadResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            if (this.resources != null) {
                resourceBundle = this.classLoader != null ? ResourceBundle.getBundle(this.resources, locale, this.classLoader) : ResourceBundle.getBundle(this.resources, locale, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (MissingResourceException x) {
            return null;
        }
        return resourceBundle;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }
}

