/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.om.common.MutableLanguage;
import org.apache.jetspeed.util.HashCodeBuilder;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.pluto.om.common.Language;

public class LanguageImpl
extends ResourceBundle
implements MutableLanguage,
Serializable {
    public static final String JAVAX_PORTLET_KEYWORDS = "javax.portlet.keywords";
    public static final String JAVAX_PORTLET_SHORT_TITLE = "javax.portlet.short-title";
    public static final String JAVAX_PORTLET_TITLE = "javax.portlet.title";
    private Set keys = Collections.synchronizedSet(new HashSet(3));
    private String title;
    private String shortTitle;
    private Locale locale;
    private String keywordStr;
    private Collection keywords;
    protected long id;
    protected long portletId;

    public LanguageImpl() {
        this.keys.add(JAVAX_PORTLET_TITLE);
        this.keys.add(JAVAX_PORTLET_SHORT_TITLE);
        this.keys.add(JAVAX_PORTLET_KEYWORDS);
        this.locale = JetspeedLocale.getDefaultLocale();
    }

    public Enumeration getKeys() {
        return Collections.enumeration(this.keys);
    }

    protected Object handleGetObject(String key) {
        if (key.equals(JAVAX_PORTLET_TITLE)) {
            return this.getTitle();
        }
        if (key.equals(JAVAX_PORTLET_SHORT_TITLE)) {
            return this.getShortTitle();
        }
        if (key.equals(JAVAX_PORTLET_KEYWORDS)) {
            return this.getKeywordStr();
        }
        return null;
    }

    private String getStringValue(ResourceBundle bundle, String key, String defaultValue) {
        String value = defaultValue;
        try {
            value = (String)bundle.getObject(key);
        }
        catch (MissingResourceException mre) {
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        return value;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        if (this.parent == null && bundle != null) {
            Enumeration<String> parentKeys = bundle.getKeys();
            while (parentKeys.hasMoreElements()) {
                this.keys.add(parentKeys.nextElement());
            }
            this.setParent(bundle);
        }
    }

    public void loadDefaults() {
        ResourceBundle bundle = this.getParentResourceBundle();
        if (bundle != null) {
            this.setTitle(this.getStringValue(bundle, JAVAX_PORTLET_TITLE, this.getTitle()));
            this.setShortTitle(this.getStringValue(bundle, JAVAX_PORTLET_SHORT_TITLE, this.getShortTitle()));
            this.setKeywords(this.getStringValue(bundle, JAVAX_PORTLET_KEYWORDS, this.getKeywordStr()));
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public Iterator getKeywords() {
        if (this.keywords == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.keywords.iterator();
    }

    public ResourceBundle getResourceBundle() {
        return this;
    }

    public ResourceBundle getParentResourceBundle() {
        return this.parent;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public void setKeywords(Collection keywords) {
        this.keywords = keywords;
    }

    public void setKeywords(String keywordStr) {
        if (this.keywords == null) {
            this.keywords = new ArrayList();
        } else {
            this.keywords.clear();
        }
        if (keywordStr == null) {
            keywordStr = "";
        }
        StringTokenizer tok = new StringTokenizer(keywordStr, ",");
        while (tok.hasMoreTokens()) {
            this.keywords.add(tok.nextToken());
        }
        this.keywordStr = keywordStr;
    }

    public String getKeywordStr() {
        if (this.keywordStr == null) {
            this.keywordStr = StringUtils.join((Iterator)this.getKeywords(), (String)",");
        }
        return this.keywordStr;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Language) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hasher = new HashCodeBuilder(19, 79);
        Locale locale = this.getLocale();
        hasher.append((Object)locale.getCountry()).append((Object)locale.getLanguage()).append((Object)locale.getVariant());
        return hasher.toHashCode();
    }
}

