/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.common.LocalizedField;

public abstract class GenericMetadataImpl
implements GenericMetadata {
    private Collection fields = null;
    private transient MultiValueMap fieldMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiValueMap getFieldMap(boolean create) {
        if (this.fieldMap == null && create) {
            GenericMetadataImpl genericMetadataImpl = this;
            synchronized (genericMetadataImpl) {
                if (this.fieldMap == null) {
                    this.fieldMap = new MultiValueMap();
                }
            }
        }
        return this.fieldMap;
    }

    public void addField(Locale locale, String name, String value) {
        LocalizedField field = this.createLocalizedField();
        field.setName(name);
        field.setValue(value);
        field.setLocale(locale);
        this.addField(field);
    }

    public void addField(LocalizedField field) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(field);
        this.getFieldMap(true).put((Object)field.getName(), (Object)field);
    }

    public Collection getFields(String name) {
        MultiValueMap fieldMap = this.getFieldMap(false);
        return (Collection)(fieldMap != null ? fieldMap.get((Object)name) : null);
    }

    public void setFields(String name, Collection values) {
        MultiValueMap fieldMap = this.getFieldMap(false);
        if (fieldMap != null) {
            fieldMap.remove((Object)name);
        }
        Iterator fieldIter = this.fields.iterator();
        while (fieldIter.hasNext()) {
            LocalizedField field = (LocalizedField)fieldIter.next();
            if (field == null || field.getName() == null || !field.getName().equals(name)) continue;
            fieldIter.remove();
        }
        if (values != null) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                LocalizedField field = (LocalizedField)iter.next();
                this.getFieldMap(true).put((Object)field.getName(), (Object)field);
            }
            this.fields.addAll(values);
        }
    }

    public Collection getFields() {
        return this.fields;
    }

    public void setFields(Collection fields) {
        this.fields = fields;
        MultiValueMap fieldMap = this.getFieldMap(false);
        if (fieldMap != null) {
            fieldMap.clear();
        }
        if (fields != null) {
            Iterator fieldIter = fields.iterator();
            while (fieldIter.hasNext()) {
                LocalizedField field = (LocalizedField)fieldIter.next();
                if (field.getName() == null) continue;
                this.getFieldMap(true).put((Object)field.getName(), (Object)field);
            }
        }
    }

    public void copyFields(Collection fields) {
        MultiValueMap fieldMap;
        if (this.fields != null && !this.fields.isEmpty()) {
            if (fields != null) {
                this.fields.retainAll(fields);
            } else {
                this.fields = null;
            }
        }
        if (fields != null && !fields.isEmpty()) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            Iterator fieldIter = fields.iterator();
            while (fieldIter.hasNext()) {
                LocalizedField field = (LocalizedField)fieldIter.next();
                if (this.fields.contains(field)) continue;
                this.addField(field.getLocale(), field.getName(), field.getValue());
            }
        }
        if ((fieldMap = this.getFieldMap(false)) != null) {
            fieldMap.clear();
        }
        if (this.fields != null) {
            Iterator fieldIter = this.fields.iterator();
            while (fieldIter.hasNext()) {
                LocalizedField field = (LocalizedField)fieldIter.next();
                this.getFieldMap(true).put((Object)field.getName(), (Object)field);
            }
        }
    }
}

