/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletentity;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.portlet.PortletMode;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.aggregator.RenderTrackable;
import org.apache.jetspeed.components.persistence.store.PersistenceStore;
import org.apache.jetspeed.components.persistence.store.PersistenceStoreRuntimeExcpetion;
import org.apache.jetspeed.components.persistence.store.RemovalAware;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.MutablePortletEntity;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.common.portlet.PrincipalAware;
import org.apache.jetspeed.om.common.preference.PreferenceSetComposite;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.impl.FragmentPortletDefinition;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.om.preference.impl.FragmentPreferenceSet;
import org.apache.jetspeed.om.preference.impl.PrefsPreference;
import org.apache.jetspeed.om.preference.impl.PrefsPreferenceSetImpl;
import org.apache.jetspeed.om.window.impl.PortletWindowListImpl;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestContextComponent;
import org.apache.jetspeed.util.JetspeedObjectID;
import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.om.window.PortletWindowList;
import org.apache.pluto.util.StringUtils;

public class PortletEntityImpl
implements MutablePortletEntity,
PrincipalAware,
RemovalAware,
RenderTrackable {
    private long oid;
    private JetspeedObjectID id;
    protected static PortletEntityAccessComponent pac;
    protected static PortletRegistry registry;
    protected static RequestContextComponent rcc;
    protected static PageManager pm;
    protected PreferenceSetComposite pagePreferenceSet;
    protected Map perPrincipalPrefs = Collections.synchronizedMap(new HashMap());
    private PortletApplicationEntity applicationEntity = null;
    private PortletWindowList portletWindows = new PortletWindowListImpl();
    private PortletDefinitionComposite portletDefinition = null;
    protected String portletName;
    protected String appName;
    private boolean dirty = false;
    private Fragment fragment;
    protected transient int timeoutCount = 0;
    protected transient long expiration = 0L;
    public static final String NO_PRINCIPAL = "no-principal";
    public static final String ENTITY_DEFAULT_PRINCIPAL = "entity-default";

    public PortletEntityImpl(Fragment fragment) {
        this.setFragment(fragment);
    }

    public PortletEntityImpl() {
    }

    public ObjectID getId() {
        return this.id;
    }

    public long getOid() {
        return this.oid;
    }

    public void setId(String id) {
        this.id = JetspeedObjectID.createFromString((String)id);
    }

    public PreferenceSet getPreferenceSet() {
        if (this.isEditDefaultsMode()) {
            return this.getPreferenceSetFromPage();
        }
        Principal currentUser = this.getPrincipal();
        return this.getPreferenceSet(currentUser);
    }

    public PreferenceSet getPreferenceSet(Principal principal) {
        PrefsPreferenceSetImpl preferenceSet = (PrefsPreferenceSetImpl)this.perPrincipalPrefs.get(principal);
        try {
            if (preferenceSet == null || !this.dirty) {
                String prefNodePath = "portlet_entity/" + this.getId() + "/" + principal.getName() + "/" + "preferences";
                Preferences prefNode = Preferences.userRoot().node(prefNodePath);
                preferenceSet = new PrefsPreferenceSetImpl(prefNode);
                this.perPrincipalPrefs.put(principal, preferenceSet);
                if (pac.isMergeSharedPreferences()) {
                    this.mergePreferencesSet(preferenceSet);
                }
                this.dirty = true;
            }
        }
        catch (BackingStoreException e) {
            String msg = "Preference backing store failed: " + e.toString();
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(e);
            throw ise;
        }
        return preferenceSet;
    }

    private PreferenceSet getPreferenceSetFromPage() {
        PreferenceSetComposite preferenceSet = this.pagePreferenceSet;
        if (preferenceSet == null || !this.dirty) {
            this.pagePreferenceSet = preferenceSet = new FragmentPreferenceSet(this.fragment, pm);
            this.dirty = true;
        }
        return preferenceSet;
    }

    private void mergePreferencesSet(PrefsPreferenceSetImpl userPrefSet) throws BackingStoreException {
        String sharedNodePath = "portlet_entity/" + this.getId() + "/" + NO_PRINCIPAL + "/" + "preferences";
        Preferences sharedNode = Preferences.userRoot().node(sharedNodePath);
        if (sharedNode == null) {
            return;
        }
        PrefsPreferenceSetImpl sharedSet = new PrefsPreferenceSetImpl(sharedNode);
        if (sharedSet.size() == 0) {
            return;
        }
        Set names = userPrefSet.getNames();
        Iterator sharedPrefs = sharedSet.iterator();
        int index = 0;
        while (sharedPrefs.hasNext()) {
            PrefsPreference sharedPref = (PrefsPreference)sharedPrefs.next();
            List<String> prefs = Arrays.asList(sharedPref.getValueArray());
            userPrefSet.add(sharedPref.getName(), prefs);
            ++index;
        }
    }

    public PortletDefinition getPortletDefinition() {
        if (this.portletDefinition == null) {
            PortletDefinitionComposite pd = registry.getPortletDefinitionByIdentifier(this.getPortletUniqueName());
            if (pd != null) {
                this.setPortletDefinition((PortletDefinition)pd);
            } else {
                return null;
            }
        }
        RequestContext rc = rcc.getRequestContext();
        String entityFragmentKey = this.getEntityFragmentKey();
        Object fpd = null;
        if (rc != null) {
            fpd = (PortletDefinition)rc.getAttribute(entityFragmentKey);
        }
        if (fpd == null) {
            fpd = new FragmentPortletDefinition(this.portletDefinition, this.fragment);
            if (rc != null) {
                rc.setAttribute(entityFragmentKey, fpd);
            }
        }
        return fpd;
    }

    public PortletApplicationEntity getPortletApplicationEntity() {
        return this.applicationEntity;
    }

    public PortletWindowList getPortletWindowList() {
        return this.portletWindows;
    }

    public void store() throws IOException {
        if (this.isEditDefaultsMode()) {
            this.storeToPage();
        } else {
            Principal currentUser = this.getPrincipal();
            this.store(currentUser);
        }
    }

    public void store(Principal principal) throws IOException {
        if (pac == null) {
            throw new IllegalStateException("You must call PortletEntityImpl.setPorteltEntityDao() before invoking PortletEntityImpl.store().");
        }
        PreferenceSet preferenceSet = (PreferenceSet)this.perPrincipalPrefs.get(principal);
        pac.storePreferenceSet(preferenceSet, (PortletEntity)this);
        this.dirty = false;
    }

    private void storeToPage() throws IOException {
        if (pm == null) {
            throw new IllegalStateException("You must set pageManager before invoking PortletEntityImpl.store().");
        }
        PreferenceSetComposite preferenceSet = this.pagePreferenceSet;
        ArrayList<FragmentPreference> preferences = new ArrayList<FragmentPreference>();
        Iterator it = preferenceSet.iterator();
        while (it.hasNext()) {
            Preference pref = (Preference)it.next();
            FragmentPreference preference = pm.newFragmentPreference();
            preference.setName(pref.getName());
            ArrayList preferenceValues = new ArrayList();
            Iterator iterVals = pref.getValues();
            while (iterVals.hasNext()) {
                preferenceValues.add(iterVals.next());
            }
            preference.setValueList(preferenceValues);
            preferences.add(preference);
        }
        this.fragment.setPreferences(preferences);
        try {
            pm.updatePage((Page)rcc.getRequestContext().getPage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dirty = false;
    }

    public void reset() throws IOException {
        this.dirty = false;
        this.getPreferenceSet(this.getPrincipal());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(1000);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(":");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("{");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("id='");
        buffer.append(this.oid);
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("definition-id='");
        if (this.portletDefinition != null) {
            buffer.append(this.portletDefinition.getId().toString());
        } else {
            buffer.append("null");
        }
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("}");
        return buffer.toString();
    }

    public Description getDescription(Locale arg0) {
        return this.portletDefinition.getDescription(arg0);
    }

    public void setPortletDefinition(PortletDefinition composite) {
        if (composite != null) {
            this.portletDefinition = (PortletDefinitionComposite)composite;
            RequestContext rc = rcc.getRequestContext();
            if (rc != null) {
                rc.getRequest().removeAttribute(this.getEntityFragmentKey());
            }
        } else {
            throw new IllegalArgumentException("Cannot pass a null PortletDefinition to a PortletEntity.");
        }
        this.appName = ((MutablePortletApplication)this.portletDefinition.getPortletApplicationDefinition()).getName();
        this.portletName = this.portletDefinition.getName();
    }

    public Principal getPrincipal() {
        if (rcc == null) {
            return new PortletEntityUserPrincipal(NO_PRINCIPAL);
        }
        RequestContext rc = rcc.getRequestContext();
        if (rc == null) {
            return new PortletEntityUserPrincipal(NO_PRINCIPAL);
        }
        Principal principal = rc.getUserPrincipal();
        if (principal == null) {
            principal = new PortletEntityUserPrincipal(NO_PRINCIPAL);
        }
        return principal;
    }

    public void postRemoval(PersistenceStore store) {
    }

    public void preRemoval(PersistenceStore store) {
        String rootForEntity = "portlet_entity/" + this.getId();
        try {
            if (Preferences.userRoot().nodeExists(rootForEntity)) {
                Preferences.userRoot().node(rootForEntity).removeNode();
            }
        }
        catch (BackingStoreException e) {
            throw new PersistenceStoreRuntimeExcpetion(e.toString(), (Throwable)e);
        }
    }

    public String getPortletUniqueName() {
        if (this.appName != null && this.portletName != null) {
            return this.appName + "::" + this.portletName;
        }
        if (this.fragment != null) {
            return this.fragment.getName();
        }
        return null;
    }

    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
        RequestContext rc = rcc.getRequestContext();
        if (rc != null) {
            rc.getRequest().removeAttribute(this.getEntityFragmentKey());
        }
    }

    public int getRenderTimeoutCount() {
        return this.timeoutCount;
    }

    public synchronized void incrementRenderTimeoutCount() {
        ++this.timeoutCount;
    }

    public synchronized void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void success() {
        this.timeoutCount = 0;
    }

    public void setRenderTimeoutCount(int timeoutCount) {
        this.timeoutCount = timeoutCount;
    }

    private boolean isEditDefaultsMode() {
        boolean editDefaultsMode = false;
        PortletWindow curWindow = null;
        if (this.portletWindows != null) {
            try {
                curWindow = (PortletWindow)this.portletWindows.iterator().next();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (rcc != null) {
            RequestContext context = rcc.getRequestContext();
            try {
                PortletMode curMode = context.getPortalURL().getNavigationalState().getMode(curWindow);
                editDefaultsMode = JetspeedActions.EDIT_DEFAULTS_MODE.equals((Object)curMode);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return editDefaultsMode;
    }

    protected String getEntityFragmentKey() {
        String entityId = this.getId() == null ? "-unknown-entity" : this.getId().toString();
        return "org.apache.jetspeed" + entityId;
    }

    class PortletEntityUserPrincipal
    implements Principal {
        String name;

        protected PortletEntityUserPrincipal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Principal) {
                Principal p = (Principal)obj;
                return this.name != null && p.getName() != null && this.name.equals(p.getName());
            }
            return false;
        }

        public int hashCode() {
            if (this.name != null) {
                return (this.getClass().getName() + ":" + this.name).hashCode();
            }
            return -1;
        }

        public String toString() {
            return this.name;
        }
    }
}

